/*
 * Decompiled with CFR 0.152.
 */
package com.ghca.kms.thrift.api;

import org.apache.thrift.TEnum;
import org.apache.thrift.annotation.Nullable;

public enum KeySpec implements TEnum
{
    RSA_1024(1),
    RSA_2048(2),
    EC_SM2(5),
    AES_256(6),
    AES_128(7),
    SM4(8),
    RSA_3072(3),
    RSA_4096(4);

    private final int value;

    private KeySpec(int value) {
        this.value = value;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Nullable
    public static KeySpec findByValue(int value) {
        switch (value) {
            case 1: {
                return RSA_1024;
            }
            case 2: {
                return RSA_2048;
            }
            case 5: {
                return EC_SM2;
            }
            case 6: {
                return AES_256;
            }
            case 7: {
                return AES_128;
            }
            case 8: {
                return SM4;
            }
            case 3: {
                return RSA_3072;
            }
            case 4: {
                return RSA_4096;
            }
        }
        return null;
    }
}

