/*
 * Decompiled with CFR 0.152.
 */
package kl.ssl.gmvpn.crypto.impl.bc;

import kl.ssl.gmvpn.Certificate;
import kl.ssl.gmvpn.DefaultTlsCredentialedSigner;
import kl.ssl.gmvpn.SignatureAndHashAlgorithm;
import kl.ssl.gmvpn.crypto.TlsCryptoParameters;
import kl.ssl.gmvpn.crypto.TlsSigner;
import kl.ssl.gmvpn.crypto.impl.bc.BcTlsCrypto;
import kl.ssl.gmvpn.crypto.impl.bc.BcTlsRSASigner;
import kl.ssl.gmvpn.crypto.impl.bc.BcTlsSM2Signer;
import kl.ssl.gmvpn.crypto.impl.bc.BcTlsSigner;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.RSAKeyParameters;

public class BcDefaultTlsCredentialedSigner
extends DefaultTlsCredentialedSigner {
    private static TlsSigner makeSigner(BcTlsCrypto crypto, AsymmetricKeyParameter privateKey, Certificate certificate, SignatureAndHashAlgorithm signatureAndHashAlgorithm) {
        BcTlsSigner signer;
        if (privateKey instanceof RSAKeyParameters) {
            signer = new BcTlsRSASigner(crypto, (RSAKeyParameters)privateKey);
        } else if (privateKey instanceof ECPrivateKeyParameters) {
            signer = new BcTlsSM2Signer(crypto, (ECPrivateKeyParameters)privateKey);
        } else {
            throw new IllegalArgumentException("'privateKey' type not supported: " + privateKey.getClass().getName());
        }
        return signer;
    }

    public BcDefaultTlsCredentialedSigner(TlsCryptoParameters cryptoParams, BcTlsCrypto crypto, AsymmetricKeyParameter privateKey, Certificate certificate, SignatureAndHashAlgorithm signatureAndHashAlgorithm) {
        super(cryptoParams, BcDefaultTlsCredentialedSigner.makeSigner(crypto, privateKey, certificate, signatureAndHashAlgorithm), certificate, signatureAndHashAlgorithm);
    }
}

