/*
 * Decompiled with CFR 0.152.
 */
package kl.ssl.gmvpn.crypto.impl.jcajce;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import kl.ssl.gmvpn.HashAlgorithm;
import kl.ssl.gmvpn.MACAlgorithm;
import kl.ssl.gmvpn.ProtocolVersion;
import kl.ssl.gmvpn.SignatureAndHashAlgorithm;
import kl.ssl.gmvpn.TlsFatalAlert;
import kl.ssl.gmvpn.TlsUtils;
import kl.ssl.gmvpn.crypto.SM2CipherText;
import kl.ssl.gmvpn.crypto.TlsCertificate;
import kl.ssl.gmvpn.crypto.TlsCipher;
import kl.ssl.gmvpn.crypto.TlsCryptoException;
import kl.ssl.gmvpn.crypto.TlsCryptoParameters;
import kl.ssl.gmvpn.crypto.TlsHMAC;
import kl.ssl.gmvpn.crypto.TlsHash;
import kl.ssl.gmvpn.crypto.TlsNonceGenerator;
import kl.ssl.gmvpn.crypto.TlsSecret;
import kl.ssl.gmvpn.crypto.impl.AbstractTlsCrypto;
import kl.ssl.gmvpn.crypto.impl.SM2Util;
import kl.ssl.gmvpn.crypto.impl.TlsAEADCipher;
import kl.ssl.gmvpn.crypto.impl.TlsAEADCipherImpl;
import kl.ssl.gmvpn.crypto.impl.TlsBlockCipher;
import kl.ssl.gmvpn.crypto.impl.TlsBlockCipherImpl;
import kl.ssl.gmvpn.crypto.impl.TlsEncryptor;
import kl.ssl.gmvpn.crypto.impl.TlsNullCipher;
import kl.ssl.gmvpn.crypto.impl.jcajce.ECUtil;
import kl.ssl.gmvpn.crypto.impl.jcajce.Exceptions;
import kl.ssl.gmvpn.crypto.impl.jcajce.JcaNonceGenerator;
import kl.ssl.gmvpn.crypto.impl.jcajce.JcaTlsCertificate;
import kl.ssl.gmvpn.crypto.impl.jcajce.JcaTlsHash;
import kl.ssl.gmvpn.crypto.impl.jcajce.JcaUtils;
import kl.ssl.gmvpn.crypto.impl.jcajce.JceAEADCipherImpl;
import kl.ssl.gmvpn.crypto.impl.jcajce.JceBlockCipherImpl;
import kl.ssl.gmvpn.crypto.impl.jcajce.JceBlockCipherWithCBCImplicitIVImpl;
import kl.ssl.gmvpn.crypto.impl.jcajce.JceTlsHMAC;
import kl.ssl.gmvpn.crypto.impl.jcajce.JceTlsSecret;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.ExtendedDigest;
import org.bouncycastle.crypto.digests.SM3Digest;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.jcajce.util.JcaJceHelper;
import org.bouncycastle.util.Arrays;

public class JcaTlsCrypto
extends AbstractTlsCrypto {
    private final JcaJceHelper helper;
    private final SecureRandom entropySource;
    private final SecureRandom nonceEntropySource;

    protected JcaTlsCrypto(JcaJceHelper helper, SecureRandom entropySource, SecureRandom nonceEntropySource) {
        this.helper = helper;
        this.entropySource = entropySource;
        this.nonceEntropySource = nonceEntropySource;
    }

    JceTlsSecret adoptLocalSecret(byte[] data) {
        return new JceTlsSecret(this, data);
    }

    Cipher createRSAEncryptionCipher() throws GeneralSecurityException {
        try {
            return this.getHelper().createCipher("RSA/NONE/PKCS1Padding");
        }
        catch (GeneralSecurityException e) {
            return this.getHelper().createCipher("RSA/ECB/PKCS1Padding");
        }
    }

    Cipher createSM2EncryptionCipher() throws GeneralSecurityException {
        return this.getHelper().createCipher("SM2/NONE/NOPADDING");
    }

    @Override
    public TlsNonceGenerator createNonceGenerator(byte[] additionalSeedMaterial) {
        return new JcaNonceGenerator(this.nonceEntropySource, additionalSeedMaterial);
    }

    @Override
    public SecureRandom getSecureRandom() {
        return this.entropySource;
    }

    @Override
    public TlsCertificate createCertificate(byte[] encoding) throws IOException {
        return new JcaTlsCertificate(this, encoding);
    }

    @Override
    protected TlsCipher createCipher(TlsCryptoParameters cryptoParams, int encryptionAlgorithm, int macAlgorithm) throws IOException {
        try {
            switch (encryptionAlgorithm) {
                case 1: {
                    return this.createSM4Cipher(cryptoParams, 16, macAlgorithm);
                }
                case 2: {
                    return this.createSM4GCMCipher(cryptoParams, 16, 16);
                }
            }
            throw new TlsFatalAlert(80);
        }
        catch (GeneralSecurityException e) {
            throw new TlsCryptoException("cannot create cipher: " + e.getMessage(), e);
        }
    }

    @Override
    public TlsHMAC createHMAC(short hashAlgorithm) {
        String digestName = this.getDigestName(hashAlgorithm).replaceAll("-", "");
        String hmacName = "Hmac" + digestName;
        return this.createHMAC(hmacName);
    }

    private TlsHMAC createHMACSM3() {
        return new HMacOperator((Digest)new SM3Digest());
    }

    @Override
    public TlsHMAC createHMAC(int macAlgorithm) {
        switch (macAlgorithm) {
            case 0: {
                return null;
            }
            case 1: {
                return this.createHMAC("HmacMD5");
            }
            case 2: {
                return this.createHMAC("HmacSHA1");
            }
            case 3: {
                return this.createHMAC("HmacSHA256");
            }
            case 4: {
                return this.createHMAC("HmacSHA384");
            }
            case 5: {
                return this.createHMAC("HmacSHA512");
            }
            case 6: {
                return this.createHMACSM3();
            }
        }
        throw new IllegalArgumentException("unknown MACAlgorithm: " + MACAlgorithm.getText(macAlgorithm));
    }

    @Override
    public boolean hasAllRawSignatureAlgorithms() {
        return false;
    }

    @Override
    public boolean hasEncryptionAlgorithm(int encryptionAlgorithm) {
        switch (encryptionAlgorithm) {
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasHashAlgorithm(short hashAlgorithm) {
        return true;
    }

    @Override
    public boolean hasMacAlgorithm(int macAlgorithm) {
        return true;
    }

    @Override
    public boolean hasNamedGroup(int namedGroup) {
        return false;
    }

    @Override
    public boolean hasRSAEncryption() {
        try {
            this.createRSAEncryptionCipher();
            return true;
        }
        catch (GeneralSecurityException e) {
            return false;
        }
    }

    @Override
    public boolean hasSignatureAlgorithm(short signatureAlgorithm) {
        switch (signatureAlgorithm) {
            case 1: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasSignatureAndHashAlgorithm(SignatureAndHashAlgorithm sigAndHashAlgorithm) {
        if (sigAndHashAlgorithm.getHash() == 3 && JcaUtils.isSunMSCAPIProviderActive()) {
            return false;
        }
        return this.hasSignatureAlgorithm(sigAndHashAlgorithm.getSignature());
    }

    @Override
    public TlsSecret createSecret(byte[] data) {
        return this.adoptLocalSecret(Arrays.clone((byte[])data));
    }

    @Override
    public TlsSecret generateRSAPreMasterSecret(ProtocolVersion version) {
        byte[] data = new byte[48];
        this.getSecureRandom().nextBytes(data);
        TlsUtils.writeVersion(version, data, 0);
        return this.adoptLocalSecret(data);
    }

    @Override
    public TlsHash createHash(short algorithm) {
        try {
            return this.createHash(this.getDigestName(algorithm));
        }
        catch (GeneralSecurityException e) {
            throw Exceptions.illegalArgumentException("unable to create message digest:" + e.getMessage(), e);
        }
    }

    @Override
    public TlsEncryptor createEncryptor(TlsCertificate certificate) throws IOException {
        JcaTlsCertificate jcaCert = JcaTlsCertificate.convert(this, certificate);
        jcaCert.validateKeyUsage(32);
        PublicKey pubKey = jcaCert.getPublicKey();
        if (pubKey instanceof ECPublicKey) {
            final ECPublicKey pubKeySM2 = jcaCert.getPubKeyEC();
            return new TlsEncryptor(){

                @Override
                public byte[] encrypt(byte[] input, int inOff, int length) throws IOException {
                    try {
                        Cipher c = JcaTlsCrypto.this.createSM2EncryptionCipher();
                        try {
                            c.init(3, (Key)pubKeySM2, JcaTlsCrypto.this.getSecureRandom());
                            byte[] opaqueCipherText = c.wrap(new SecretKeySpec(input, inOff, length, "TLS"));
                            SM2CipherText sm2CipherText = SM2Util.getSM2CipherStructure(opaqueCipherText);
                            return sm2CipherText.getEncoded();
                        }
                        catch (Exception e) {
                            try {
                                c.init(1, (Key)pubKeySM2, JcaTlsCrypto.this.getSecureRandom());
                                byte[] opaqueCipherText = c.doFinal(input, inOff, length);
                                SM2CipherText sm2CipherText = SM2Util.getSM2CipherStructure(opaqueCipherText);
                                return sm2CipherText.getEncoded();
                            }
                            catch (Exception ex) {
                                throw new TlsFatalAlert(80, (Throwable)e);
                            }
                        }
                    }
                    catch (GeneralSecurityException e) {
                        throw new TlsFatalAlert(80, (Throwable)e);
                    }
                }
            };
        }
        final RSAPublicKey pubKeyRSA = jcaCert.getPubKeyRSA();
        return new TlsEncryptor(){

            @Override
            public byte[] encrypt(byte[] input, int inOff, int length) throws IOException {
                try {
                    Cipher c = JcaTlsCrypto.this.createRSAEncryptionCipher();
                    try {
                        c.init(3, (Key)pubKeyRSA, JcaTlsCrypto.this.getSecureRandom());
                        return c.wrap(new SecretKeySpec(input, inOff, length, "TLS"));
                    }
                    catch (Exception e) {
                        try {
                            c.init(1, (Key)pubKeyRSA, JcaTlsCrypto.this.getSecureRandom());
                            return c.doFinal(input, inOff, length);
                        }
                        catch (Exception ex) {
                            throw new TlsFatalAlert(80, (Throwable)e);
                        }
                    }
                }
                catch (GeneralSecurityException e) {
                    throw new TlsFatalAlert(80, (Throwable)e);
                }
            }
        };
    }

    @Override
    public TlsSecret hkdfInit(short hashAlgorithm) {
        return this.adoptLocalSecret(new byte[HashAlgorithm.getOutputSize(hashAlgorithm)]);
    }

    protected TlsAEADCipherImpl createAEADCipher(String cipherName, String algorithm, int keySize, boolean isEncrypting) throws GeneralSecurityException {
        return new JceAEADCipherImpl(this.helper, cipherName, algorithm, keySize, isEncrypting);
    }

    protected TlsBlockCipherImpl createBlockCipher(String cipherName, String algorithm, int keySize, boolean isEncrypting) throws GeneralSecurityException {
        return new JceBlockCipherImpl(this.helper.createCipher(cipherName), algorithm, keySize, isEncrypting);
    }

    protected TlsBlockCipherImpl createBlockCipherWithCBCImplicitIV(String cipherName, String algorithm, int keySize, boolean isEncrypting) throws GeneralSecurityException {
        return new JceBlockCipherWithCBCImplicitIVImpl(this.helper.createCipher(cipherName), algorithm, isEncrypting);
    }

    protected TlsHMAC createHMAC(String hmacName) {
        try {
            return new JceTlsHMAC(this.helper.createMac(hmacName), hmacName);
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException("cannot create HMAC: " + hmacName, e);
        }
    }

    protected TlsHash createHash(String digestName) throws GeneralSecurityException {
        return new JcaTlsHash(this.helper.createDigest(digestName));
    }

    protected TlsNullCipher createNullCipher(TlsCryptoParameters cryptoParams, int macAlgorithm) throws IOException, GeneralSecurityException {
        return new TlsNullCipher(cryptoParams, this.createMAC(macAlgorithm), this.createMAC(macAlgorithm));
    }

    protected boolean isCurveSupported(String curveName) {
        return ECUtil.isCurveSupported(curveName, this.getHelper());
    }

    public JcaJceHelper getHelper() {
        return this.helper;
    }

    private TlsBlockCipher createSM4Cipher(TlsCryptoParameters cryptoParams, int cipherKeySize, int macAlgorithm) throws IOException, GeneralSecurityException {
        return new TlsBlockCipher(this, cryptoParams, this.createCBCBlockOperator(cryptoParams, "SM4", true, cipherKeySize), this.createCBCBlockOperator(cryptoParams, "SM4", false, cipherKeySize), this.createMAC(macAlgorithm), this.createMAC(macAlgorithm), cipherKeySize);
    }

    protected TlsAEADCipher createSM4GCMCipher(TlsCryptoParameters cryptoParams, int cipherKeySize, int macSize) throws IOException, GeneralSecurityException {
        return new TlsAEADCipher(cryptoParams, this.createAEADCipher("SM4/GCM/NoPadding", "SM4", cipherKeySize, true), this.createAEADCipher("SM4/GCM/NoPadding", "SM4", cipherKeySize, false), cipherKeySize, macSize);
    }

    private TlsBlockCipherImpl createCBCBlockOperator(TlsCryptoParameters cryptoParams, String algorithm, boolean forEncryption, int keySize) throws GeneralSecurityException {
        String cipherName = algorithm + "/CBC/NoPadding";
        return this.createBlockCipher(cipherName, algorithm, keySize, forEncryption);
    }

    private TlsHMAC createMAC(int macAlgorithm) throws IOException {
        return this.createHMAC(macAlgorithm);
    }

    String getDigestName(short hashAlgorithm) {
        String digestName;
        switch (hashAlgorithm) {
            case 1: {
                digestName = "MD5";
                break;
            }
            case 2: {
                digestName = "SHA-1";
                break;
            }
            case 3: {
                digestName = "SHA-224";
                break;
            }
            case 4: {
                digestName = "SHA-256";
                break;
            }
            case 5: {
                digestName = "SHA-384";
                break;
            }
            case 6: {
                digestName = "SHA-512";
                break;
            }
            case 7: {
                digestName = "SM3";
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid HashAlgorithm: " + HashAlgorithm.getText(hashAlgorithm));
            }
        }
        return digestName;
    }

    private class HMacOperator
    implements TlsHMAC {
        private final HMac hmac;

        HMacOperator(Digest digest) {
            this.hmac = new HMac(digest);
        }

        @Override
        public void setKey(byte[] key, int keyOff, int keyLen) {
            this.hmac.init((CipherParameters)new KeyParameter(key, keyOff, keyLen));
        }

        @Override
        public void update(byte[] input, int inOff, int length) {
            this.hmac.update(input, inOff, length);
        }

        @Override
        public byte[] calculateMAC() {
            byte[] rv = new byte[this.hmac.getMacSize()];
            this.hmac.doFinal(rv, 0);
            return rv;
        }

        @Override
        public void calculateMAC(byte[] output, int outOff) {
            this.hmac.doFinal(output, outOff);
        }

        @Override
        public int getInternalBlockSize() {
            return ((ExtendedDigest)this.hmac.getUnderlyingDigest()).getByteLength();
        }

        @Override
        public int getMacLength() {
            return this.hmac.getMacSize();
        }

        @Override
        public void reset() {
            this.hmac.reset();
        }
    }
}

