/*
 * Decompiled with CFR 0.152.
 */
package kl.ssl.gmvpn.crypto;

import java.math.BigInteger;
import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.util.Arrays;

public class SM2CipherText
extends ASN1Object {
    private BigInteger xCoordinate;
    private BigInteger yCoordinate;
    private byte[] hash;
    private byte[] cipherText;

    public static SM2CipherText getInstance(ASN1TaggedObject obj, boolean explicit) {
        return SM2CipherText.getInstance(ASN1Sequence.getInstance((ASN1TaggedObject)obj, (boolean)explicit));
    }

    public static SM2CipherText getInstance(Object obj) {
        if (obj instanceof SM2CipherText) {
            return (SM2CipherText)((Object)obj);
        }
        if (obj != null) {
            return new SM2CipherText(ASN1Sequence.getInstance((Object)obj));
        }
        return null;
    }

    public SM2CipherText(BigInteger x, BigInteger y, byte[] hash, byte[] cipherText) {
        this.xCoordinate = x;
        this.yCoordinate = y;
        this.hash = Arrays.clone((byte[])hash);
        this.cipherText = Arrays.clone((byte[])cipherText);
    }

    public SM2CipherText(ASN1Sequence seq) {
        if (seq.size() != 4) {
            throw new IllegalArgumentException("Bad sequence size: " + seq.size());
        }
        Enumeration e = seq.getObjects();
        this.xCoordinate = ASN1Integer.getInstance(e.nextElement()).getPositiveValue();
        this.yCoordinate = ASN1Integer.getInstance(e.nextElement()).getPositiveValue();
        this.hash = ASN1OctetString.getInstance(e.nextElement()).getOctets();
        this.cipherText = ASN1OctetString.getInstance(e.nextElement()).getOctets();
    }

    public BigInteger getXCoordinate() {
        return this.xCoordinate;
    }

    public BigInteger getYCoordinate() {
        return this.yCoordinate;
    }

    public byte[] getHash() {
        return Arrays.clone((byte[])this.hash);
    }

    public byte[] getCipherText() {
        return Arrays.clone((byte[])this.cipherText);
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)new ASN1Integer(this.getXCoordinate()));
        v.add((ASN1Encodable)new ASN1Integer(this.getYCoordinate()));
        v.add((ASN1Encodable)new DEROctetString(this.hash));
        v.add((ASN1Encodable)new DEROctetString(this.cipherText));
        return new DERSequence(v);
    }
}

