/*
 * Decompiled with CFR 0.152.
 */
package kl.ssl.gmvpn.crypto.impl.jcajce;

import java.security.Provider;
import java.security.Security;
import kl.ssl.gmvpn.HashAlgorithm;
import kl.ssl.gmvpn.SignatureAlgorithm;
import kl.ssl.gmvpn.SignatureAndHashAlgorithm;

class JcaUtils {
    JcaUtils() {
    }

    static String getJcaAlgorithmName(SignatureAndHashAlgorithm algorithm) {
        return (HashAlgorithm.getName(algorithm.getHash()) + "WITH" + SignatureAlgorithm.getName(algorithm.getSignature())).toUpperCase();
    }

    static boolean isSunMSCAPIProviderActive() {
        return null != Security.getProvider("SunMSCAPI");
    }

    static boolean isBCProviderActive() {
        return null != Security.getProvider("BC");
    }

    static boolean isSunMSCAPIProvider(Provider provider) {
        return null != provider && JcaUtils.isSunMSCAPIProviderName(provider.getName());
    }

    static boolean isSunMSCAPIProviderName(String providerName) {
        return "SunMSCAPI".equals(providerName);
    }
}

