/*
 * Decompiled with CFR 0.152.
 */
package com.koal.kms.config;

import com.koal.kms.config.Sm4Util;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class ConfigUtil {
    private static final String READ = "r";
    private static final String WRITE = "rws";
    private static final int READ_BUFFER_SIZE = 0x400000;

    private ConfigUtil() {
    }

    public static void encryptFile(String path, String newName) throws Exception {
        File file = new File(path);
        if (!file.exists() || !file.canRead()) {
            throw new RuntimeException("[" + file.getName() + "] not exist or can't read.");
        }
        if (null == newName || newName.trim().length() == 0 || file.getName().equals(newName)) {
            throw new RuntimeException("Illegal encrypted file name.");
        }
        String folder = file.getParentFile().getAbsolutePath();
        File newFile = new File(folder + File.separator + newName);
        ConfigUtil.prepareNewFile(newFile);
        try (RandomAccessFile src = new RandomAccessFile(file, READ);
             FileChannel fc = src.getChannel();
             RandomAccessFile dest = new RandomAccessFile(newFile, WRITE);
             FileChannel fcw = dest.getChannel();){
            int len;
            ByteBuffer reader = ByteBuffer.allocateDirect(0x400000);
            while ((len = fc.read(reader)) != -1) {
                if (len <= 0) continue;
                byte[] data = new byte[len];
                reader.rewind();
                reader.get(data);
                fcw.write(ByteBuffer.wrap(Sm4Util.encrypt(data)));
                reader.clear();
            }
        }
    }

    private static void prepareNewFile(File newFile) throws IOException {
        if (newFile.exists() && !newFile.delete()) {
            throw new RuntimeException("[" + newFile.getName() + "] already exist, but delete fail.");
        }
        if (!newFile.createNewFile()) {
            throw new RuntimeException("create [" + newFile.getName() + "] failure.");
        }
    }

    public static void decryptFile(String path, String newName) throws Exception {
        File file = new File(path);
        if (!file.exists() || !file.canRead()) {
            throw new RuntimeException("[" + file.getName() + "] not exist or can't read.");
        }
        if (null == newName || newName.trim().length() == 0 || file.getName().equals(newName)) {
            throw new RuntimeException("Illegal decrypted file name.");
        }
        String folder = file.getParentFile().getAbsolutePath();
        File newFile = new File(folder + File.separator + newName);
        ConfigUtil.prepareNewFile(newFile);
        try (RandomAccessFile src = new RandomAccessFile(file, READ);
             FileChannel fc = src.getChannel();
             RandomAccessFile dest = new RandomAccessFile(newFile, WRITE);
             FileChannel fcw = dest.getChannel();){
            int len;
            ByteBuffer reader = ByteBuffer.allocateDirect(0x400000);
            while ((len = fc.read(reader)) != -1) {
                if (len <= 0) continue;
                byte[] data = new byte[len];
                reader.rewind();
                reader.get(data);
                fcw.write(ByteBuffer.wrap(Sm4Util.decrypt(data)));
                reader.clear();
            }
        }
    }

    public static byte[] decryptInputStream(InputStream inputStream) throws Exception {
        return Sm4Util.decrypt(ConfigUtil.toByteArray(inputStream));
    }

    private static byte[] toByteArray(InputStream input) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
        }
        return output.toByteArray();
    }
}

