/*
 * Decompiled with CFR 0.152.
 */
package com.idealista.fpe.builder.validate;

public class BuildValidator {
    private static final String OUT_OF_RANGE_RADIX = "radix not in: [ 2 .. 2 ^ 16 ]";
    private static final String OUT_OF_RANGE_MIN_LENGTH = "minLength not in: [ 2 .. %d )";
    private static final String RADIX_TO_MIN_LENGTH_LOWER_THAN_LIMIT = "radix ^ minLength is lower than 100";
    private static final int TEXT_VALID_MIN_LENGTH = 2;
    private final int radix;
    private final int minLength;
    private final int maxLength;

    public BuildValidator(int radix, int minLength, int maxLength) {
        this.radix = radix;
        this.minLength = minLength;
        this.maxLength = maxLength;
    }

    public void validate() {
        this.radix();
        this.radixToMinLength();
        this.textSizeLimits();
    }

    void radix() {
        if (this.radix < 2 || (double)this.radix > Math.pow(2.0, 16.0)) {
            throw new IllegalArgumentException(OUT_OF_RANGE_RADIX);
        }
    }

    void textSizeLimits() {
        if (this.minLength < 1 || this.minLength >= this.maxLength) {
            throw new IllegalArgumentException(String.format("minLength not in: [ 1 .. %d )", this.maxLength));
        }
    }

    void radixToMinLength() {
        if (Math.pow(this.radix, this.minLength) < 100.0) {
            // empty if block
        }
    }
}

