/*
 * Decompiled with CFR 0.152.
 */
package com.ghca.kms.thrift.api;

import com.ghca.kms.thrift.api.EncMode;
import com.ghca.kms.thrift.api.SymmetricAlgo;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.annotation.Nullable;
import org.apache.thrift.meta_data.EnumMetaData;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;

public class ExportSymmetricKeyRequest
implements TBase<ExportSymmetricKeyRequest, _Fields>,
Serializable,
Cloneable,
Comparable<ExportSymmetricKeyRequest> {
    private static final TStruct STRUCT_DESC = new TStruct("ExportSymmetricKeyRequest");
    private static final TField ACCESS_TOKEN_FIELD_DESC = new TField("accessToken", 11, 1);
    private static final TField EXPORT_KEY_ID_FIELD_DESC = new TField("exportKeyId", 11, 2);
    private static final TField PROTECTION_KEY_ID_FIELD_DESC = new TField("protectionKeyId", 11, 3);
    private static final TField ENVELOPE_BYTE_LENGTH_FIELD_DESC = new TField("envelopeByteLength", 8, 4);
    private static final TField ENVELOPE_ENC_ALGO_FIELD_DESC = new TField("envelopeEncAlgo", 8, 5);
    private static final TField ENVELOPE_ENC_MODE_FIELD_DESC = new TField("envelopeEncMode", 8, 6);
    private static final TField ENVELOPE_ENC_IV_FIELD_DESC = new TField("envelopeEncIv", 11, 7);
    private static final TField ENVELOPE_ENC_AAD_FIELD_DESC = new TField("envelopeEncAad", 11, 8);
    private static final SchemeFactory STANDARD_SCHEME_FACTORY = new ExportSymmetricKeyRequestStandardSchemeFactory();
    private static final SchemeFactory TUPLE_SCHEME_FACTORY = new ExportSymmetricKeyRequestTupleSchemeFactory();
    @Nullable
    public String accessToken;
    @Nullable
    public String exportKeyId;
    @Nullable
    public String protectionKeyId;
    public int envelopeByteLength;
    @Nullable
    public SymmetricAlgo envelopeEncAlgo;
    @Nullable
    public EncMode envelopeEncMode;
    @Nullable
    public ByteBuffer envelopeEncIv;
    @Nullable
    public ByteBuffer envelopeEncAad;
    private static final int __ENVELOPEBYTELENGTH_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public ExportSymmetricKeyRequest() {
        this.envelopeByteLength = 32;
        this.envelopeEncAlgo = SymmetricAlgo.AES;
        this.envelopeEncMode = EncMode.CBC;
    }

    public ExportSymmetricKeyRequest(String accessToken, String exportKeyId, String protectionKeyId, int envelopeByteLength, SymmetricAlgo envelopeEncAlgo, EncMode envelopeEncMode, ByteBuffer envelopeEncIv, ByteBuffer envelopeEncAad) {
        this();
        this.accessToken = accessToken;
        this.exportKeyId = exportKeyId;
        this.protectionKeyId = protectionKeyId;
        this.envelopeByteLength = envelopeByteLength;
        this.setEnvelopeByteLengthIsSet(true);
        this.envelopeEncAlgo = envelopeEncAlgo;
        this.envelopeEncMode = envelopeEncMode;
        this.envelopeEncIv = TBaseHelper.copyBinary(envelopeEncIv);
        this.envelopeEncAad = TBaseHelper.copyBinary(envelopeEncAad);
    }

    public ExportSymmetricKeyRequest(ExportSymmetricKeyRequest other) {
        this.__isset_bitfield = other.__isset_bitfield;
        if (other.isSetAccessToken()) {
            this.accessToken = other.accessToken;
        }
        if (other.isSetExportKeyId()) {
            this.exportKeyId = other.exportKeyId;
        }
        if (other.isSetProtectionKeyId()) {
            this.protectionKeyId = other.protectionKeyId;
        }
        this.envelopeByteLength = other.envelopeByteLength;
        if (other.isSetEnvelopeEncAlgo()) {
            this.envelopeEncAlgo = other.envelopeEncAlgo;
        }
        if (other.isSetEnvelopeEncMode()) {
            this.envelopeEncMode = other.envelopeEncMode;
        }
        if (other.isSetEnvelopeEncIv()) {
            this.envelopeEncIv = TBaseHelper.copyBinary(other.envelopeEncIv);
        }
        if (other.isSetEnvelopeEncAad()) {
            this.envelopeEncAad = TBaseHelper.copyBinary(other.envelopeEncAad);
        }
    }

    @Override
    public ExportSymmetricKeyRequest deepCopy() {
        return new ExportSymmetricKeyRequest(this);
    }

    @Override
    public void clear() {
        this.accessToken = null;
        this.exportKeyId = null;
        this.protectionKeyId = null;
        this.envelopeByteLength = 32;
        this.envelopeEncAlgo = SymmetricAlgo.AES;
        this.envelopeEncMode = EncMode.CBC;
        this.envelopeEncIv = null;
        this.envelopeEncAad = null;
    }

    @Nullable
    public String getAccessToken() {
        return this.accessToken;
    }

    public ExportSymmetricKeyRequest setAccessToken(@Nullable String accessToken) {
        this.accessToken = accessToken;
        return this;
    }

    public void unsetAccessToken() {
        this.accessToken = null;
    }

    public boolean isSetAccessToken() {
        return this.accessToken != null;
    }

    public void setAccessTokenIsSet(boolean value) {
        if (!value) {
            this.accessToken = null;
        }
    }

    @Nullable
    public String getExportKeyId() {
        return this.exportKeyId;
    }

    public ExportSymmetricKeyRequest setExportKeyId(@Nullable String exportKeyId) {
        this.exportKeyId = exportKeyId;
        return this;
    }

    public void unsetExportKeyId() {
        this.exportKeyId = null;
    }

    public boolean isSetExportKeyId() {
        return this.exportKeyId != null;
    }

    public void setExportKeyIdIsSet(boolean value) {
        if (!value) {
            this.exportKeyId = null;
        }
    }

    @Nullable
    public String getProtectionKeyId() {
        return this.protectionKeyId;
    }

    public ExportSymmetricKeyRequest setProtectionKeyId(@Nullable String protectionKeyId) {
        this.protectionKeyId = protectionKeyId;
        return this;
    }

    public void unsetProtectionKeyId() {
        this.protectionKeyId = null;
    }

    public boolean isSetProtectionKeyId() {
        return this.protectionKeyId != null;
    }

    public void setProtectionKeyIdIsSet(boolean value) {
        if (!value) {
            this.protectionKeyId = null;
        }
    }

    public int getEnvelopeByteLength() {
        return this.envelopeByteLength;
    }

    public ExportSymmetricKeyRequest setEnvelopeByteLength(int envelopeByteLength) {
        this.envelopeByteLength = envelopeByteLength;
        this.setEnvelopeByteLengthIsSet(true);
        return this;
    }

    public void unsetEnvelopeByteLength() {
        this.__isset_bitfield = EncodingUtils.clearBit(this.__isset_bitfield, 0);
    }

    public boolean isSetEnvelopeByteLength() {
        return EncodingUtils.testBit(this.__isset_bitfield, 0);
    }

    public void setEnvelopeByteLengthIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit(this.__isset_bitfield, 0, value);
    }

    @Nullable
    public SymmetricAlgo getEnvelopeEncAlgo() {
        return this.envelopeEncAlgo;
    }

    public ExportSymmetricKeyRequest setEnvelopeEncAlgo(@Nullable SymmetricAlgo envelopeEncAlgo) {
        this.envelopeEncAlgo = envelopeEncAlgo;
        return this;
    }

    public void unsetEnvelopeEncAlgo() {
        this.envelopeEncAlgo = null;
    }

    public boolean isSetEnvelopeEncAlgo() {
        return this.envelopeEncAlgo != null;
    }

    public void setEnvelopeEncAlgoIsSet(boolean value) {
        if (!value) {
            this.envelopeEncAlgo = null;
        }
    }

    @Nullable
    public EncMode getEnvelopeEncMode() {
        return this.envelopeEncMode;
    }

    public ExportSymmetricKeyRequest setEnvelopeEncMode(@Nullable EncMode envelopeEncMode) {
        this.envelopeEncMode = envelopeEncMode;
        return this;
    }

    public void unsetEnvelopeEncMode() {
        this.envelopeEncMode = null;
    }

    public boolean isSetEnvelopeEncMode() {
        return this.envelopeEncMode != null;
    }

    public void setEnvelopeEncModeIsSet(boolean value) {
        if (!value) {
            this.envelopeEncMode = null;
        }
    }

    public byte[] getEnvelopeEncIv() {
        this.setEnvelopeEncIv(TBaseHelper.rightSize(this.envelopeEncIv));
        return this.envelopeEncIv == null ? null : this.envelopeEncIv.array();
    }

    public ByteBuffer bufferForEnvelopeEncIv() {
        return TBaseHelper.copyBinary(this.envelopeEncIv);
    }

    public ExportSymmetricKeyRequest setEnvelopeEncIv(byte[] envelopeEncIv) {
        this.envelopeEncIv = envelopeEncIv == null ? (ByteBuffer)null : ByteBuffer.wrap((byte[])envelopeEncIv.clone());
        return this;
    }

    public ExportSymmetricKeyRequest setEnvelopeEncIv(@Nullable ByteBuffer envelopeEncIv) {
        this.envelopeEncIv = TBaseHelper.copyBinary(envelopeEncIv);
        return this;
    }

    public void unsetEnvelopeEncIv() {
        this.envelopeEncIv = null;
    }

    public boolean isSetEnvelopeEncIv() {
        return this.envelopeEncIv != null;
    }

    public void setEnvelopeEncIvIsSet(boolean value) {
        if (!value) {
            this.envelopeEncIv = null;
        }
    }

    public byte[] getEnvelopeEncAad() {
        this.setEnvelopeEncAad(TBaseHelper.rightSize(this.envelopeEncAad));
        return this.envelopeEncAad == null ? null : this.envelopeEncAad.array();
    }

    public ByteBuffer bufferForEnvelopeEncAad() {
        return TBaseHelper.copyBinary(this.envelopeEncAad);
    }

    public ExportSymmetricKeyRequest setEnvelopeEncAad(byte[] envelopeEncAad) {
        this.envelopeEncAad = envelopeEncAad == null ? (ByteBuffer)null : ByteBuffer.wrap((byte[])envelopeEncAad.clone());
        return this;
    }

    public ExportSymmetricKeyRequest setEnvelopeEncAad(@Nullable ByteBuffer envelopeEncAad) {
        this.envelopeEncAad = TBaseHelper.copyBinary(envelopeEncAad);
        return this;
    }

    public void unsetEnvelopeEncAad() {
        this.envelopeEncAad = null;
    }

    public boolean isSetEnvelopeEncAad() {
        return this.envelopeEncAad != null;
    }

    public void setEnvelopeEncAadIsSet(boolean value) {
        if (!value) {
            this.envelopeEncAad = null;
        }
    }

    @Override
    public void setFieldValue(_Fields field, @Nullable Object value) {
        switch (field) {
            case ACCESS_TOKEN: {
                if (value == null) {
                    this.unsetAccessToken();
                    break;
                }
                this.setAccessToken((String)value);
                break;
            }
            case EXPORT_KEY_ID: {
                if (value == null) {
                    this.unsetExportKeyId();
                    break;
                }
                this.setExportKeyId((String)value);
                break;
            }
            case PROTECTION_KEY_ID: {
                if (value == null) {
                    this.unsetProtectionKeyId();
                    break;
                }
                this.setProtectionKeyId((String)value);
                break;
            }
            case ENVELOPE_BYTE_LENGTH: {
                if (value == null) {
                    this.unsetEnvelopeByteLength();
                    break;
                }
                this.setEnvelopeByteLength((Integer)value);
                break;
            }
            case ENVELOPE_ENC_ALGO: {
                if (value == null) {
                    this.unsetEnvelopeEncAlgo();
                    break;
                }
                this.setEnvelopeEncAlgo((SymmetricAlgo)value);
                break;
            }
            case ENVELOPE_ENC_MODE: {
                if (value == null) {
                    this.unsetEnvelopeEncMode();
                    break;
                }
                this.setEnvelopeEncMode((EncMode)value);
                break;
            }
            case ENVELOPE_ENC_IV: {
                if (value == null) {
                    this.unsetEnvelopeEncIv();
                    break;
                }
                if (value instanceof byte[]) {
                    this.setEnvelopeEncIv((byte[])value);
                    break;
                }
                this.setEnvelopeEncIv((ByteBuffer)value);
                break;
            }
            case ENVELOPE_ENC_AAD: {
                if (value == null) {
                    this.unsetEnvelopeEncAad();
                    break;
                }
                if (value instanceof byte[]) {
                    this.setEnvelopeEncAad((byte[])value);
                    break;
                }
                this.setEnvelopeEncAad((ByteBuffer)value);
            }
        }
    }

    @Override
    @Nullable
    public Object getFieldValue(_Fields field) {
        switch (field) {
            case ACCESS_TOKEN: {
                return this.getAccessToken();
            }
            case EXPORT_KEY_ID: {
                return this.getExportKeyId();
            }
            case PROTECTION_KEY_ID: {
                return this.getProtectionKeyId();
            }
            case ENVELOPE_BYTE_LENGTH: {
                return this.getEnvelopeByteLength();
            }
            case ENVELOPE_ENC_ALGO: {
                return this.getEnvelopeEncAlgo();
            }
            case ENVELOPE_ENC_MODE: {
                return this.getEnvelopeEncMode();
            }
            case ENVELOPE_ENC_IV: {
                return this.getEnvelopeEncIv();
            }
            case ENVELOPE_ENC_AAD: {
                return this.getEnvelopeEncAad();
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case ACCESS_TOKEN: {
                return this.isSetAccessToken();
            }
            case EXPORT_KEY_ID: {
                return this.isSetExportKeyId();
            }
            case PROTECTION_KEY_ID: {
                return this.isSetProtectionKeyId();
            }
            case ENVELOPE_BYTE_LENGTH: {
                return this.isSetEnvelopeByteLength();
            }
            case ENVELOPE_ENC_ALGO: {
                return this.isSetEnvelopeEncAlgo();
            }
            case ENVELOPE_ENC_MODE: {
                return this.isSetEnvelopeEncMode();
            }
            case ENVELOPE_ENC_IV: {
                return this.isSetEnvelopeEncIv();
            }
            case ENVELOPE_ENC_AAD: {
                return this.isSetEnvelopeEncAad();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that instanceof ExportSymmetricKeyRequest) {
            return this.equals((ExportSymmetricKeyRequest)that);
        }
        return false;
    }

    public boolean equals(ExportSymmetricKeyRequest that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        boolean this_present_accessToken = this.isSetAccessToken();
        boolean that_present_accessToken = that.isSetAccessToken();
        if (this_present_accessToken || that_present_accessToken) {
            if (!this_present_accessToken || !that_present_accessToken) {
                return false;
            }
            if (!this.accessToken.equals(that.accessToken)) {
                return false;
            }
        }
        boolean this_present_exportKeyId = this.isSetExportKeyId();
        boolean that_present_exportKeyId = that.isSetExportKeyId();
        if (this_present_exportKeyId || that_present_exportKeyId) {
            if (!this_present_exportKeyId || !that_present_exportKeyId) {
                return false;
            }
            if (!this.exportKeyId.equals(that.exportKeyId)) {
                return false;
            }
        }
        boolean this_present_protectionKeyId = this.isSetProtectionKeyId();
        boolean that_present_protectionKeyId = that.isSetProtectionKeyId();
        if (this_present_protectionKeyId || that_present_protectionKeyId) {
            if (!this_present_protectionKeyId || !that_present_protectionKeyId) {
                return false;
            }
            if (!this.protectionKeyId.equals(that.protectionKeyId)) {
                return false;
            }
        }
        boolean this_present_envelopeByteLength = true;
        boolean that_present_envelopeByteLength = true;
        if (this_present_envelopeByteLength || that_present_envelopeByteLength) {
            if (!this_present_envelopeByteLength || !that_present_envelopeByteLength) {
                return false;
            }
            if (this.envelopeByteLength != that.envelopeByteLength) {
                return false;
            }
        }
        boolean this_present_envelopeEncAlgo = this.isSetEnvelopeEncAlgo();
        boolean that_present_envelopeEncAlgo = that.isSetEnvelopeEncAlgo();
        if (this_present_envelopeEncAlgo || that_present_envelopeEncAlgo) {
            if (!this_present_envelopeEncAlgo || !that_present_envelopeEncAlgo) {
                return false;
            }
            if (!this.envelopeEncAlgo.equals(that.envelopeEncAlgo)) {
                return false;
            }
        }
        boolean this_present_envelopeEncMode = this.isSetEnvelopeEncMode();
        boolean that_present_envelopeEncMode = that.isSetEnvelopeEncMode();
        if (this_present_envelopeEncMode || that_present_envelopeEncMode) {
            if (!this_present_envelopeEncMode || !that_present_envelopeEncMode) {
                return false;
            }
            if (!this.envelopeEncMode.equals(that.envelopeEncMode)) {
                return false;
            }
        }
        boolean this_present_envelopeEncIv = this.isSetEnvelopeEncIv();
        boolean that_present_envelopeEncIv = that.isSetEnvelopeEncIv();
        if (this_present_envelopeEncIv || that_present_envelopeEncIv) {
            if (!this_present_envelopeEncIv || !that_present_envelopeEncIv) {
                return false;
            }
            if (!this.envelopeEncIv.equals(that.envelopeEncIv)) {
                return false;
            }
        }
        boolean this_present_envelopeEncAad = this.isSetEnvelopeEncAad();
        boolean that_present_envelopeEncAad = that.isSetEnvelopeEncAad();
        if (this_present_envelopeEncAad || that_present_envelopeEncAad) {
            if (!this_present_envelopeEncAad || !that_present_envelopeEncAad) {
                return false;
            }
            if (!this.envelopeEncAad.equals(that.envelopeEncAad)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = hashCode * 8191 + (this.isSetAccessToken() ? 131071 : 524287);
        if (this.isSetAccessToken()) {
            hashCode = hashCode * 8191 + this.accessToken.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetExportKeyId() ? 131071 : 524287);
        if (this.isSetExportKeyId()) {
            hashCode = hashCode * 8191 + this.exportKeyId.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetProtectionKeyId() ? 131071 : 524287);
        if (this.isSetProtectionKeyId()) {
            hashCode = hashCode * 8191 + this.protectionKeyId.hashCode();
        }
        hashCode = hashCode * 8191 + this.envelopeByteLength;
        hashCode = hashCode * 8191 + (this.isSetEnvelopeEncAlgo() ? 131071 : 524287);
        if (this.isSetEnvelopeEncAlgo()) {
            hashCode = hashCode * 8191 + this.envelopeEncAlgo.getValue();
        }
        hashCode = hashCode * 8191 + (this.isSetEnvelopeEncMode() ? 131071 : 524287);
        if (this.isSetEnvelopeEncMode()) {
            hashCode = hashCode * 8191 + this.envelopeEncMode.getValue();
        }
        hashCode = hashCode * 8191 + (this.isSetEnvelopeEncIv() ? 131071 : 524287);
        if (this.isSetEnvelopeEncIv()) {
            hashCode = hashCode * 8191 + this.envelopeEncIv.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetEnvelopeEncAad() ? 131071 : 524287);
        if (this.isSetEnvelopeEncAad()) {
            hashCode = hashCode * 8191 + this.envelopeEncAad.hashCode();
        }
        return hashCode;
    }

    @Override
    public int compareTo(ExportSymmetricKeyRequest other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.compare(this.isSetAccessToken(), other.isSetAccessToken());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetAccessToken() && (lastComparison = TBaseHelper.compareTo(this.accessToken, other.accessToken)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetExportKeyId(), other.isSetExportKeyId());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetExportKeyId() && (lastComparison = TBaseHelper.compareTo(this.exportKeyId, other.exportKeyId)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetProtectionKeyId(), other.isSetProtectionKeyId());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetProtectionKeyId() && (lastComparison = TBaseHelper.compareTo(this.protectionKeyId, other.protectionKeyId)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetEnvelopeByteLength(), other.isSetEnvelopeByteLength());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetEnvelopeByteLength() && (lastComparison = TBaseHelper.compareTo(this.envelopeByteLength, other.envelopeByteLength)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetEnvelopeEncAlgo(), other.isSetEnvelopeEncAlgo());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetEnvelopeEncAlgo() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.envelopeEncAlgo), (Comparable)((Object)other.envelopeEncAlgo))) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetEnvelopeEncMode(), other.isSetEnvelopeEncMode());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetEnvelopeEncMode() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.envelopeEncMode), (Comparable)((Object)other.envelopeEncMode))) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetEnvelopeEncIv(), other.isSetEnvelopeEncIv());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetEnvelopeEncIv() && (lastComparison = TBaseHelper.compareTo(this.envelopeEncIv, other.envelopeEncIv)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetEnvelopeEncAad(), other.isSetEnvelopeEncAad());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetEnvelopeEncAad() && (lastComparison = TBaseHelper.compareTo(this.envelopeEncAad, other.envelopeEncAad)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Override
    @Nullable
    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        ExportSymmetricKeyRequest.scheme(iprot).read(iprot, (ExportSymmetricKeyRequest)this);
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        ExportSymmetricKeyRequest.scheme(oprot).write(oprot, (ExportSymmetricKeyRequest)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ExportSymmetricKeyRequest(");
        boolean first = true;
        sb.append("accessToken:");
        if (this.accessToken == null) {
            sb.append("null");
        } else {
            sb.append(this.accessToken);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("exportKeyId:");
        if (this.exportKeyId == null) {
            sb.append("null");
        } else {
            sb.append(this.exportKeyId);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("protectionKeyId:");
        if (this.protectionKeyId == null) {
            sb.append("null");
        } else {
            sb.append(this.protectionKeyId);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("envelopeByteLength:");
        sb.append(this.envelopeByteLength);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("envelopeEncAlgo:");
        if (this.envelopeEncAlgo == null) {
            sb.append("null");
        } else {
            sb.append(this.envelopeEncAlgo);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("envelopeEncMode:");
        if (this.envelopeEncMode == null) {
            sb.append("null");
        } else {
            sb.append(this.envelopeEncMode);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("envelopeEncIv:");
        if (this.envelopeEncIv == null) {
            sb.append("null");
        } else {
            TBaseHelper.toString(this.envelopeEncIv, sb);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("envelopeEncAad:");
        if (this.envelopeEncAad == null) {
            sb.append("null");
        } else {
            TBaseHelper.toString(this.envelopeEncAad, sb);
        }
        first = false;
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.accessToken == null) {
            throw new TProtocolException("Required field 'accessToken' was not present! Struct: " + this.toString());
        }
        if (this.exportKeyId == null) {
            throw new TProtocolException("Required field 'exportKeyId' was not present! Struct: " + this.toString());
        }
        if (this.protectionKeyId == null) {
            throw new TProtocolException("Required field 'protectionKeyId' was not present! Struct: " + this.toString());
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write(new TCompactProtocol(new TIOStreamTransport(out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.__isset_bitfield = 0;
            this.read(new TCompactProtocol(new TIOStreamTransport(in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private static <S extends IScheme> S scheme(TProtocol proto) {
        return (StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }

    static {
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.ACCESS_TOKEN, new FieldMetaData("accessToken", 1, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.EXPORT_KEY_ID, new FieldMetaData("exportKeyId", 1, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.PROTECTION_KEY_ID, new FieldMetaData("protectionKeyId", 1, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.ENVELOPE_BYTE_LENGTH, new FieldMetaData("envelopeByteLength", 3, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.ENVELOPE_ENC_ALGO, new FieldMetaData("envelopeEncAlgo", 3, new EnumMetaData(16, SymmetricAlgo.class)));
        tmpMap.put(_Fields.ENVELOPE_ENC_MODE, new FieldMetaData("envelopeEncMode", 3, new EnumMetaData(16, EncMode.class)));
        tmpMap.put(_Fields.ENVELOPE_ENC_IV, new FieldMetaData("envelopeEncIv", 3, new FieldValueMetaData(11, true)));
        tmpMap.put(_Fields.ENVELOPE_ENC_AAD, new FieldMetaData("envelopeEncAad", 3, new FieldValueMetaData(11, true)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(ExportSymmetricKeyRequest.class, metaDataMap);
    }

    private static class ExportSymmetricKeyRequestTupleScheme
    extends TupleScheme<ExportSymmetricKeyRequest> {
        private ExportSymmetricKeyRequestTupleScheme() {
        }

        @Override
        public void write(TProtocol prot, ExportSymmetricKeyRequest struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            oprot.writeString(struct.accessToken);
            oprot.writeString(struct.exportKeyId);
            oprot.writeString(struct.protectionKeyId);
            BitSet optionals = new BitSet();
            if (struct.isSetEnvelopeByteLength()) {
                optionals.set(0);
            }
            if (struct.isSetEnvelopeEncAlgo()) {
                optionals.set(1);
            }
            if (struct.isSetEnvelopeEncMode()) {
                optionals.set(2);
            }
            if (struct.isSetEnvelopeEncIv()) {
                optionals.set(3);
            }
            if (struct.isSetEnvelopeEncAad()) {
                optionals.set(4);
            }
            oprot.writeBitSet(optionals, 5);
            if (struct.isSetEnvelopeByteLength()) {
                oprot.writeI32(struct.envelopeByteLength);
            }
            if (struct.isSetEnvelopeEncAlgo()) {
                oprot.writeI32(struct.envelopeEncAlgo.getValue());
            }
            if (struct.isSetEnvelopeEncMode()) {
                oprot.writeI32(struct.envelopeEncMode.getValue());
            }
            if (struct.isSetEnvelopeEncIv()) {
                oprot.writeBinary(struct.envelopeEncIv);
            }
            if (struct.isSetEnvelopeEncAad()) {
                oprot.writeBinary(struct.envelopeEncAad);
            }
        }

        @Override
        public void read(TProtocol prot, ExportSymmetricKeyRequest struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            struct.accessToken = iprot.readString();
            struct.setAccessTokenIsSet(true);
            struct.exportKeyId = iprot.readString();
            struct.setExportKeyIdIsSet(true);
            struct.protectionKeyId = iprot.readString();
            struct.setProtectionKeyIdIsSet(true);
            BitSet incoming = iprot.readBitSet(5);
            if (incoming.get(0)) {
                struct.envelopeByteLength = iprot.readI32();
                struct.setEnvelopeByteLengthIsSet(true);
            }
            if (incoming.get(1)) {
                struct.envelopeEncAlgo = SymmetricAlgo.findByValue(iprot.readI32());
                struct.setEnvelopeEncAlgoIsSet(true);
            }
            if (incoming.get(2)) {
                struct.envelopeEncMode = EncMode.findByValue(iprot.readI32());
                struct.setEnvelopeEncModeIsSet(true);
            }
            if (incoming.get(3)) {
                struct.envelopeEncIv = iprot.readBinary();
                struct.setEnvelopeEncIvIsSet(true);
            }
            if (incoming.get(4)) {
                struct.envelopeEncAad = iprot.readBinary();
                struct.setEnvelopeEncAadIsSet(true);
            }
        }
    }

    private static class ExportSymmetricKeyRequestTupleSchemeFactory
    implements SchemeFactory {
        private ExportSymmetricKeyRequestTupleSchemeFactory() {
        }

        public ExportSymmetricKeyRequestTupleScheme getScheme() {
            return new ExportSymmetricKeyRequestTupleScheme();
        }
    }

    private static class ExportSymmetricKeyRequestStandardScheme
    extends StandardScheme<ExportSymmetricKeyRequest> {
        private ExportSymmetricKeyRequestStandardScheme() {
        }

        @Override
        public void read(TProtocol iprot, ExportSymmetricKeyRequest struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 11) {
                            struct.accessToken = iprot.readString();
                            struct.setAccessTokenIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 11) {
                            struct.exportKeyId = iprot.readString();
                            struct.setExportKeyIdIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 11) {
                            struct.protectionKeyId = iprot.readString();
                            struct.setProtectionKeyIdIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 8) {
                            struct.envelopeByteLength = iprot.readI32();
                            struct.setEnvelopeByteLengthIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 5: {
                        if (schemeField.type == 8) {
                            struct.envelopeEncAlgo = SymmetricAlgo.findByValue(iprot.readI32());
                            struct.setEnvelopeEncAlgoIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 6: {
                        if (schemeField.type == 8) {
                            struct.envelopeEncMode = EncMode.findByValue(iprot.readI32());
                            struct.setEnvelopeEncModeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 7: {
                        if (schemeField.type == 11) {
                            struct.envelopeEncIv = iprot.readBinary();
                            struct.setEnvelopeEncIvIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 8: {
                        if (schemeField.type == 11) {
                            struct.envelopeEncAad = iprot.readBinary();
                            struct.setEnvelopeEncAadIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        @Override
        public void write(TProtocol oprot, ExportSymmetricKeyRequest struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.accessToken != null) {
                oprot.writeFieldBegin(ACCESS_TOKEN_FIELD_DESC);
                oprot.writeString(struct.accessToken);
                oprot.writeFieldEnd();
            }
            if (struct.exportKeyId != null) {
                oprot.writeFieldBegin(EXPORT_KEY_ID_FIELD_DESC);
                oprot.writeString(struct.exportKeyId);
                oprot.writeFieldEnd();
            }
            if (struct.protectionKeyId != null) {
                oprot.writeFieldBegin(PROTECTION_KEY_ID_FIELD_DESC);
                oprot.writeString(struct.protectionKeyId);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldBegin(ENVELOPE_BYTE_LENGTH_FIELD_DESC);
            oprot.writeI32(struct.envelopeByteLength);
            oprot.writeFieldEnd();
            if (struct.envelopeEncAlgo != null) {
                oprot.writeFieldBegin(ENVELOPE_ENC_ALGO_FIELD_DESC);
                oprot.writeI32(struct.envelopeEncAlgo.getValue());
                oprot.writeFieldEnd();
            }
            if (struct.envelopeEncMode != null) {
                oprot.writeFieldBegin(ENVELOPE_ENC_MODE_FIELD_DESC);
                oprot.writeI32(struct.envelopeEncMode.getValue());
                oprot.writeFieldEnd();
            }
            if (struct.envelopeEncIv != null) {
                oprot.writeFieldBegin(ENVELOPE_ENC_IV_FIELD_DESC);
                oprot.writeBinary(struct.envelopeEncIv);
                oprot.writeFieldEnd();
            }
            if (struct.envelopeEncAad != null) {
                oprot.writeFieldBegin(ENVELOPE_ENC_AAD_FIELD_DESC);
                oprot.writeBinary(struct.envelopeEncAad);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class ExportSymmetricKeyRequestStandardSchemeFactory
    implements SchemeFactory {
        private ExportSymmetricKeyRequestStandardSchemeFactory() {
        }

        public ExportSymmetricKeyRequestStandardScheme getScheme() {
            return new ExportSymmetricKeyRequestStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        ACCESS_TOKEN(1, "accessToken"),
        EXPORT_KEY_ID(2, "exportKeyId"),
        PROTECTION_KEY_ID(3, "protectionKeyId"),
        ENVELOPE_BYTE_LENGTH(4, "envelopeByteLength"),
        ENVELOPE_ENC_ALGO(5, "envelopeEncAlgo"),
        ENVELOPE_ENC_MODE(6, "envelopeEncMode"),
        ENVELOPE_ENC_IV(7, "envelopeEncIv"),
        ENVELOPE_ENC_AAD(8, "envelopeEncAad");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        @Nullable
        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return ACCESS_TOKEN;
                }
                case 2: {
                    return EXPORT_KEY_ID;
                }
                case 3: {
                    return PROTECTION_KEY_ID;
                }
                case 4: {
                    return ENVELOPE_BYTE_LENGTH;
                }
                case 5: {
                    return ENVELOPE_ENC_ALGO;
                }
                case 6: {
                    return ENVELOPE_ENC_MODE;
                }
                case 7: {
                    return ENVELOPE_ENC_IV;
                }
                case 8: {
                    return ENVELOPE_ENC_AAD;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        @Nullable
        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        @Override
        public short getThriftFieldId() {
            return this._thriftId;
        }

        @Override
        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

