/*
 * Decompiled with CFR 0.152.
 */
package kl.ssl.gmvpn;

import java.io.IOException;
import java.io.InputStream;
import kl.ssl.gmvpn.Certificate;
import kl.ssl.gmvpn.TlsContext;
import kl.ssl.gmvpn.TlsFatalAlert;
import kl.ssl.gmvpn.TlsKeyExchange;

public abstract class AbstractTlsKeyExchange
implements TlsKeyExchange {
    protected int keyExchange;
    protected TlsContext context;

    protected AbstractTlsKeyExchange(int keyExchange) {
        this.keyExchange = keyExchange;
    }

    @Override
    public void init(TlsContext context) {
        this.context = context;
    }

    @Override
    public void processServerCertificate(Certificate serverCertificate) throws IOException {
        throw new TlsFatalAlert(80);
    }

    @Override
    public boolean requiresServerKeyExchange() {
        return true;
    }

    @Override
    public byte[] generateServerKeyExchange() throws IOException {
        if (this.requiresServerKeyExchange()) {
            throw new TlsFatalAlert(80);
        }
        return null;
    }

    @Override
    public void skipServerKeyExchange() throws IOException {
        if (this.requiresServerKeyExchange()) {
            throw new TlsFatalAlert(10);
        }
    }

    @Override
    public void processServerKeyExchange(InputStream input) throws IOException {
        if (!this.requiresServerKeyExchange()) {
            throw new TlsFatalAlert(10);
        }
    }

    @Override
    public short[] getClientCertificateTypes() {
        return null;
    }

    @Override
    public void skipClientCredentials() throws IOException {
    }

    @Override
    public void processClientCertificate(Certificate clientCertificate) throws IOException {
    }

    @Override
    public void processClientKeyExchange(InputStream input) throws IOException {
        throw new TlsFatalAlert(80);
    }

    @Override
    public boolean requiresCertificateVerify() {
        return true;
    }
}

