/*
 * Decompiled with CFR 0.152.
 */
package kl.ssl.jsse.provider;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.Socket;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import kl.ssl.jsse.BCExtendedSSLSession;
import kl.ssl.jsse.BCSSLParameters;
import kl.ssl.jsse.BCSSLSocket;
import kl.ssl.jsse.provider.ContextData;
import kl.ssl.jsse.provider.ProvSSLContextSpi;
import kl.ssl.jsse.provider.ProvSSLParameters;
import kl.ssl.jsse.provider.ProvSSLSocketDirect;
import kl.ssl.jsse.provider.ProvSSLSocketWrap;
import kl.ssl.jsse.provider.ReflectionUtil;
import kl.ssl.jsse.provider.SSLParametersUtil;
import kl.ssl.jsse.provider.SSLSessionUtil;

abstract class SSLSocketUtil {
    private static final Method getHandshakeSession;
    private static final Method getSSLParameters;

    SSLSocketUtil() {
    }

    static ProvSSLSocketDirect create(ProvSSLContextSpi context, ContextData contextData, boolean enableSessionCreation, boolean useClientMode, ProvSSLParameters sslParameters) {
        return new ProvSSLSocketDirect(context, contextData, enableSessionCreation, useClientMode, sslParameters);
    }

    static ProvSSLSocketDirect create(ProvSSLContextSpi context, ContextData contextData) {
        return new ProvSSLSocketDirect(context, contextData);
    }

    static ProvSSLSocketDirect create(ProvSSLContextSpi context, ContextData contextData, InetAddress address, int port, InetAddress clientAddress, int clientPort) throws IOException {
        return new ProvSSLSocketDirect(context, contextData, address, port, clientAddress, clientPort);
    }

    static ProvSSLSocketDirect create(ProvSSLContextSpi context, ContextData contextData, InetAddress address, int port) throws IOException {
        return new ProvSSLSocketDirect(context, contextData, address, port);
    }

    static ProvSSLSocketDirect create(ProvSSLContextSpi context, ContextData contextData, String host, int port, InetAddress clientAddress, int clientPort) throws IOException {
        return new ProvSSLSocketDirect(context, contextData, host, port, clientAddress, clientPort);
    }

    static ProvSSLSocketDirect create(ProvSSLContextSpi context, ContextData contextData, String host, int port) throws IOException {
        return new ProvSSLSocketDirect(context, contextData, host, port);
    }

    static ProvSSLSocketWrap create(ProvSSLContextSpi context, ContextData contextData, Socket s, InputStream consumed, boolean autoClose) throws IOException {
        return new ProvSSLSocketWrap(context, contextData, s, consumed, autoClose);
    }

    static ProvSSLSocketWrap create(ProvSSLContextSpi context, ContextData contextData, Socket s, String host, int port, boolean autoClose) throws IOException {
        return new ProvSSLSocketWrap(context, contextData, s, host, port, autoClose);
    }

    static BCExtendedSSLSession importHandshakeSession(SSLSocket sslSocket) {
        if (sslSocket instanceof BCSSLSocket) {
            return ((BCSSLSocket)((Object)sslSocket)).getBCHandshakeSession();
        }
        if (null != sslSocket && null != getHandshakeSession) {
            try {
                SSLSession sslSession = (SSLSession)ReflectionUtil.invokeGetter(sslSocket, getHandshakeSession);
                if (null != sslSession) {
                    return SSLSessionUtil.importSSLSession(sslSession);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    static BCSSLParameters importSSLParameters(SSLSocket sslSocket) {
        if (sslSocket instanceof BCSSLSocket) {
            return ((BCSSLSocket)((Object)sslSocket)).getParameters();
        }
        if (null != sslSocket && null != getSSLParameters) {
            try {
                SSLParameters sslParameters = (SSLParameters)ReflectionUtil.invokeGetter(sslSocket, getSSLParameters);
                if (null != sslParameters) {
                    return SSLParametersUtil.importSSLParameters(sslParameters);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    static {
        Method[] methods = ReflectionUtil.getMethods("javax.net.ssl.SSLSocket");
        getHandshakeSession = ReflectionUtil.findMethod(methods, "getHandshakeSession");
        getSSLParameters = ReflectionUtil.findMethod(methods, "getSSLParameters");
    }
}

