/*
 * Decompiled with CFR 0.152.
 */
package com.koal.kms.sdk.ed;

import cn.hutool.core.util.ReflectUtil;
import com.ghca.kms.thrift.api.KmsException;
import com.koal.kms.sdk.ed.AbstractKmsClient;
import com.koal.kms.sdk.ed.KmsClient;
import com.koal.kms.sdk.ed.KmsClientConfig;
import com.koal.kms.sdk.ed.KmsClientHttpImpl;
import com.koal.kms.sdk.ed.KmsClientThriftImpl;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientBuilder {
    private static final Logger logger = LoggerFactory.getLogger(ClientBuilder.class);
    private static final KmsClientConfig KMS_CLIENT_CONFIG = KmsClientConfig.getInstance();

    ClientBuilder() {
    }

    public static KmsClient getInstance() throws KmsException {
        AbstractKmsClient kmsClient = null;
        kmsClient = KMS_CLIENT_CONFIG.getKcspKid() != null && !"".equals(KMS_CLIENT_CONFIG.getKcspKid()) ? new KmsClientHttpImpl() : KmsClientThriftImpl.getInstance();
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.setFactory(kmsClient);
        return (KmsClient)Proxy.newProxyInstance(kmsClient.getClass().getClassLoader(), new Class[]{KmsClient.class}, (InvocationHandler)proxyFactory);
    }

    static class ProxyFactory
    implements InvocationHandler {
        private Object factory;

        ProxyFactory() {
        }

        public void setFactory(Object factory) {
            this.factory = factory;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                return method.invoke(this.factory, args);
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() instanceof KmsException && ((KmsException)e.getTargetException()).getErrCode() == 100001) {
                    ReflectUtil.invoke((Object)this.factory, (String)"generateToken", (Object[])new Object[0]);
                    return method.invoke(this.factory, args);
                }
                if (e.getTargetException() instanceof TException) {
                    int retryNumber;
                    for (retryNumber = KMS_CLIENT_CONFIG.getRetryCount() - 1; retryNumber > 0; --retryNumber) {
                        try {
                            logger.warn("\u5f00\u59cb\u91cd\u8bd5\uff0c\u5f02\u5e38\u6d88\u606f\uff1a{}, \u5269\u4f59\u5c1d\u8bd5\u6b21\u6570\uff1a{}", (Object)(e.getTargetException() instanceof KmsException ? ((KmsException)e.getTargetException()).getErr() : e.getTargetException().getMessage()), (Object)retryNumber);
                            return method.invoke(this.factory, args);
                        }
                        catch (Exception exception) {
                            continue;
                        }
                    }
                    logger.warn("\u5f00\u59cb\u91cd\u8bd5\uff0c\u5f02\u5e38\u6d88\u606f\uff1a{}, \u5269\u4f59\u5c1d\u8bd5\u6b21\u6570\uff1a{}", (Object)(e.getTargetException() instanceof KmsException ? ((KmsException)e.getTargetException()).getErr() : e.getTargetException().getMessage()), (Object)retryNumber);
                    return method.invoke(this.factory, args);
                }
                throw e.getTargetException();
            }
        }
    }
}

