/*
 * Decompiled with CFR 0.152.
 */
package kl.ssl.gmvpn.crypto.impl.bc;

import java.io.IOException;
import kl.ssl.gmvpn.SignatureAndHashAlgorithm;
import kl.ssl.gmvpn.TlsFatalAlert;
import kl.ssl.gmvpn.crypto.impl.bc.BcTlsCrypto;
import kl.ssl.gmvpn.crypto.impl.bc.BcTlsSigner;
import org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.signers.RSADigestSigner;

public class BcTlsRSASigner
extends BcTlsSigner {
    public BcTlsRSASigner(BcTlsCrypto crypto, RSAKeyParameters privateKey) {
        super(crypto, (AsymmetricKeyParameter)privateKey);
    }

    @Override
    public byte[] generateRawSignature(SignatureAndHashAlgorithm algorithm, byte[] hash) throws IOException {
        Digest sm3Digest = this.crypto.createDigest((short)7);
        RSADigestSigner signer = new RSADigestSigner(sm3Digest, GMObjectIdentifiers.sm2sign_with_sha512);
        signer.init(true, (CipherParameters)new ParametersWithRandom((CipherParameters)this.privateKey, this.crypto.getSecureRandom()));
        signer.update(hash, 0, hash.length);
        try {
            return signer.generateSignature();
        }
        catch (CryptoException e) {
            throw new TlsFatalAlert(80, (Throwable)e);
        }
    }
}

