/*
 * Decompiled with CFR 0.152.
 */
package kl.ssl.gmvpn.crypto.impl.jcajce;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.Signature;
import kl.ssl.gmvpn.SignatureAndHashAlgorithm;
import kl.ssl.gmvpn.TlsFatalAlert;
import kl.ssl.gmvpn.crypto.TlsSigner;
import kl.ssl.gmvpn.crypto.TlsStreamSigner;
import kl.ssl.gmvpn.crypto.impl.jcajce.JcaTlsCrypto;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.DigestInfo;

public class JcaTlsRSASigner
implements TlsSigner {
    private final JcaTlsCrypto crypto;
    private final PrivateKey privateKey;
    private Signature rawSigner = null;
    private MessageDigest rawDigest = null;

    public JcaTlsRSASigner(JcaTlsCrypto crypto, PrivateKey privateKey) {
        if (null == crypto) {
            throw new NullPointerException("crypto");
        }
        if (null == privateKey) {
            throw new NullPointerException("privateKey");
        }
        this.crypto = crypto;
        this.privateKey = privateKey;
    }

    @Override
    public byte[] generateRawSignature(SignatureAndHashAlgorithm algorithm, byte[] hash) throws IOException {
        try {
            Signature signer = this.getRawSigner();
            MessageDigest digest = this.getRawDigest();
            byte[] hash2times = digest.digest(hash);
            AlgorithmIdentifier algID = new AlgorithmIdentifier(GMObjectIdentifiers.sm2sign_with_sha512, (ASN1Encodable)DERNull.INSTANCE);
            byte[] digestInfo = new DigestInfo(algID, hash2times).getEncoded();
            signer.update(digestInfo, 0, digestInfo.length);
            return signer.sign();
        }
        catch (GeneralSecurityException e) {
            throw new TlsFatalAlert(80, (Throwable)e);
        }
    }

    @Override
    public TlsStreamSigner getStreamSigner(SignatureAndHashAlgorithm algorithm) throws IOException {
        return null;
    }

    protected Signature getRawSigner() throws GeneralSecurityException {
        if (this.rawSigner == null) {
            this.rawSigner = this.crypto.getHelper().createSignature("NoneWithRSA");
            this.rawSigner.initSign(this.privateKey, this.crypto.getSecureRandom());
        }
        return this.rawSigner;
    }

    protected MessageDigest getRawDigest() throws GeneralSecurityException {
        if (this.rawDigest == null) {
            this.rawDigest = this.crypto.getHelper().createDigest("SM3");
        }
        return this.rawDigest;
    }
}

