/*
 * Decompiled with CFR 0.152.
 */
package org.apache.thrift.transport;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyStore;
import java.util.Arrays;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MyTSSLTransportFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(MyTSSLTransportFactory.class);

    public static TServerSocket getServerSocket(int port) throws TTransportException {
        return MyTSSLTransportFactory.getServerSocket(port, 0);
    }

    public static TServerSocket getServerSocket(int port, int clientTimeout) throws TTransportException {
        return MyTSSLTransportFactory.getServerSocket(port, clientTimeout, false, null);
    }

    public static TServerSocket getServerSocket(int port, int clientTimeout, boolean clientAuth, InetAddress ifAddress) throws TTransportException {
        SSLServerSocketFactory factory = (SSLServerSocketFactory)SSLServerSocketFactory.getDefault();
        return MyTSSLTransportFactory.createServer(factory, port, clientTimeout, clientAuth, ifAddress, null);
    }

    public static TServerSocket getServerSocket(int port, int clientTimeout, InetAddress ifAddress, TSSLTransportParameters params) throws TTransportException {
        if (params == null || !params.isKeyStoreSet && !params.isTrustStoreSet) {
            throw new TTransportException("Either one of the KeyStore or TrustStore must be set for SSLTransportParameters");
        }
        SSLContext ctx = MyTSSLTransportFactory.createSSLContext(params);
        return MyTSSLTransportFactory.createServer(ctx.getServerSocketFactory(), port, clientTimeout, params.clientAuth, ifAddress, params);
    }

    private static TServerSocket createServer(SSLServerSocketFactory factory, int port, int timeout, boolean clientAuth, InetAddress ifAddress, TSSLTransportParameters params) throws TTransportException {
        try {
            TServerSocket.ServerSocketTransportArgs args = new TServerSocket.ServerSocketTransportArgs().serverSocket(factory.createServerSocket(port, 100, ifAddress));
            SSLServerSocket serverSocket = (SSLServerSocket)args.serverSocket;
            serverSocket.setSoTimeout(timeout);
            serverSocket.setNeedClientAuth(clientAuth);
            if (params != null && params.cipherSuites != null) {
                serverSocket.setEnabledCipherSuites(params.cipherSuites);
            }
            return new TServerSocket((TServerSocket.ServerSocketTransportArgs)args.clientTimeout(timeout));
        }
        catch (Exception e) {
            throw new TTransportException("Could not bind to port " + port, (Throwable)e);
        }
    }

    public static TSocket getClientSocket(String host, int port, int timeout) throws TTransportException {
        SSLSocketFactory factory = (SSLSocketFactory)SSLSocketFactory.getDefault();
        return MyTSSLTransportFactory.createClient(factory, host, port, timeout);
    }

    public static TSocket getClientSocket(String host, int port) throws TTransportException {
        return MyTSSLTransportFactory.getClientSocket(host, port, 0);
    }

    public static TSocket getClientSocket(String host, int port, int timeout, TSSLTransportParameters params) throws TTransportException {
        if (params == null || !params.isKeyStoreSet && !params.isTrustStoreSet) {
            throw new TTransportException(1, "Either one of the KeyStore or TrustStore must be set for SSLTransportParameters");
        }
        SSLContext ctx = MyTSSLTransportFactory.createSSLContext(params);
        return MyTSSLTransportFactory.createClient(ctx.getSocketFactory(), host, port, timeout);
    }

    private static SSLContext createSSLContext(TSSLTransportParameters params) throws TTransportException {
        SSLContext ctx;
        InputStream in = null;
        InputStream is = null;
        try {
            ctx = SSLContext.getInstance("GMVPNv1.1", "KLGMJSSE");
            TrustManagerFactory tmf = null;
            KeyManagerFactory kmf = null;
            if (params.isTrustStoreSet) {
                tmf = TrustManagerFactory.getInstance("PKIX", "KLGMJSSE");
                KeyStore ts = KeyStore.getInstance(params.trustStoreType);
                in = params.trustStoreStream != null ? params.trustStoreStream : MyTSSLTransportFactory.getStoreAsStream(params.trustStore);
                ts.load(in, params.trustPass != null ? params.trustPass.toCharArray() : null);
                tmf.init(ts);
            }
            if (params.isKeyStoreSet) {
                kmf = KeyManagerFactory.getInstance("PKIX", "KLGMJSSE");
                KeyStore ks = KeyStore.getInstance(params.keyStoreType);
                is = params.keyStoreStream != null ? params.keyStoreStream : MyTSSLTransportFactory.getStoreAsStream(params.keyStore);
                ks.load(is, params.keyPass.toCharArray());
                kmf.init(ks, params.keyPass.toCharArray());
            }
            if (null != kmf && null != tmf && params.isKeyStoreSet && params.isTrustStoreSet) {
                ctx.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
            } else if (null != kmf && params.isKeyStoreSet) {
                ctx.init(kmf.getKeyManagers(), null, null);
            } else if (null != tmf) {
                ctx.init(null, tmf.getTrustManagers(), null);
            }
        }
        catch (Exception e) {
            throw new TTransportException(1, "Error creating the transport", e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    LOGGER.warn("Unable to close stream", (Throwable)e);
                }
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    LOGGER.warn("Unable to close stream", (Throwable)e);
                }
            }
        }
        return ctx;
    }

    private static InputStream getStoreAsStream(String store) throws IOException {
        try {
            return new FileInputStream(store);
        }
        catch (FileNotFoundException fileNotFoundException) {
            InputStream storeStream = null;
            try {
                storeStream = new URL(store).openStream();
                if (storeStream != null) {
                    return storeStream;
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            storeStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(store);
            if (storeStream != null) {
                return storeStream;
            }
            throw new IOException("Could not load file: " + store);
        }
    }

    private static TSocket createClient(SSLSocketFactory factory, String host, int port, int timeout) throws TTransportException {
        try {
            TSocket tSocket = new TSocket(factory.createSocket(host, port));
            tSocket.setTimeout(timeout);
            return tSocket;
        }
        catch (IOException e) {
            throw new TTransportException(1, "Could not connect to " + host + " on port " + port, e);
        }
    }

    public static class TSSLTransportParameters {
        protected String protocol = "TLS";
        protected String keyStore;
        protected InputStream keyStoreStream;
        protected String keyPass;
        protected String keyManagerType = KeyManagerFactory.getDefaultAlgorithm();
        protected String keyStoreType = "JKS";
        protected String trustStore;
        protected InputStream trustStoreStream;
        protected String trustPass;
        protected String trustManagerType = TrustManagerFactory.getDefaultAlgorithm();
        protected String trustStoreType = "JKS";
        protected String[] cipherSuites;
        protected boolean clientAuth = false;
        protected boolean isKeyStoreSet = false;
        protected boolean isTrustStoreSet = false;

        public TSSLTransportParameters() {
        }

        public TSSLTransportParameters(String protocol, String[] cipherSuites) {
            this(protocol, cipherSuites, false);
        }

        public TSSLTransportParameters(String protocol, String[] cipherSuites, boolean clientAuth) {
            if (protocol != null) {
                this.protocol = protocol;
            }
            this.cipherSuites = cipherSuites != null ? Arrays.copyOf(cipherSuites, cipherSuites.length) : null;
            this.clientAuth = clientAuth;
        }

        public void setKeyStore(String keyStore, String keyPass, String keyManagerType, String keyStoreType) {
            this.keyStore = keyStore;
            this.keyPass = keyPass;
            if (keyManagerType != null) {
                this.keyManagerType = keyManagerType;
            }
            if (keyStoreType != null) {
                this.keyStoreType = keyStoreType;
            }
            this.isKeyStoreSet = true;
        }

        public void setKeyStore(InputStream keyStoreStream, String keyPass, String keyManagerType, String keyStoreType) {
            this.keyStoreStream = keyStoreStream;
            this.setKeyStore("", keyPass, keyManagerType, keyStoreType);
        }

        public void setKeyStore(String keyStore, String keyPass) {
            this.setKeyStore(keyStore, keyPass, null, null);
        }

        public void setKeyStore(InputStream keyStoreStream, String keyPass) {
            this.setKeyStore(keyStoreStream, keyPass, null, null);
        }

        public void setTrustStore(String trustStore, String trustPass, String trustManagerType, String trustStoreType) {
            this.trustStore = trustStore;
            this.trustPass = trustPass;
            if (trustManagerType != null) {
                this.trustManagerType = trustManagerType;
            }
            if (trustStoreType != null) {
                this.trustStoreType = trustStoreType;
            }
            this.isTrustStoreSet = true;
        }

        public void setTrustStore(InputStream trustStoreStream, String trustPass, String trustManagerType, String trustStoreType) {
            this.trustStoreStream = trustStoreStream;
            this.setTrustStore("", trustPass, trustManagerType, trustStoreType);
        }

        public void setTrustStore(String trustStore, String trustPass) {
            this.setTrustStore(trustStore, trustPass, null, null);
        }

        public void setTrustStore(InputStream trustStoreStream, String trustPass) {
            this.setTrustStore(trustStoreStream, trustPass, null, null);
        }

        public void requireClientAuth(boolean clientAuth) {
            this.clientAuth = clientAuth;
        }
    }
}

