/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.collection;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.geotools.data.DataUtilities;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.opengis.feature.Feature;
import org.opengis.feature.type.FeatureType;

public class DelegateFeatureIterator<F extends Feature>
implements FeatureIterator<F> {
    Iterator<F> delegate;

    public DelegateFeatureIterator(Iterator<F> iterator) {
        this.delegate = iterator;
    }

    public DelegateFeatureIterator(FeatureCollection<? extends FeatureType, F> collection, Iterator<F> iterator) {
        this.delegate = iterator;
    }

    public boolean hasNext() {
        return this.delegate != null && this.delegate.hasNext();
    }

    public F next() throws NoSuchElementException {
        if (this.delegate == null) {
            throw new NoSuchElementException();
        }
        return (F)((Feature)this.delegate.next());
    }

    public void close() {
        DataUtilities.close(this.delegate);
        this.delegate = null;
    }
}

