/*
 * Decompiled with CFR 0.152.
 */
package kl.ssl.gmvpn.crypto.impl.bc;

import java.io.IOException;
import java.io.OutputStream;
import kl.ssl.gmvpn.DigitallySigned;
import kl.ssl.gmvpn.crypto.TlsStreamVerifier;
import kl.ssl.gmvpn.crypto.impl.bc.BcTlsCrypto;
import kl.ssl.gmvpn.crypto.impl.bc.BcTlsVerifier;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Signer;
import org.bouncycastle.crypto.io.SignerOutputStream;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.signers.SM2Signer;

public class BcTlsSM2Verifier
extends BcTlsVerifier {
    public BcTlsSM2Verifier(BcTlsCrypto crypto, ECPublicKeyParameters publicKey) {
        super(crypto, (AsymmetricKeyParameter)publicKey);
    }

    @Override
    public boolean verifyRawSignature(DigitallySigned signature, byte[] hash) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public TlsStreamVerifier getStreamVerifier(DigitallySigned signature) {
        SM2Signer signer = new SM2Signer();
        signer.init(false, (CipherParameters)this.publicKey);
        final byte[] sig = signature.getSignature();
        final SignerOutputStream sigOut = new SignerOutputStream((Signer)signer);
        return new TlsStreamVerifier(){

            @Override
            public OutputStream getOutputStream() {
                return sigOut;
            }

            @Override
            public boolean isVerified() throws IOException {
                return sigOut.getSigner().verifySignature(sig);
            }
        };
    }
}

