/*
 * Decompiled with CFR 0.152.
 */
package kl.ssl.jsse.provider;

import java.io.IOException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.security.auth.x500.X500Principal;
import kl.ssl.gmvpn.AlertDescription;
import kl.ssl.gmvpn.AlertLevel;
import kl.ssl.gmvpn.ProtocolName;
import kl.ssl.gmvpn.SecurityParameters;
import kl.ssl.gmvpn.ServerName;
import kl.ssl.gmvpn.SignatureAndHashAlgorithm;
import kl.ssl.gmvpn.TlsFatalAlert;
import kl.ssl.gmvpn.TlsUtils;
import kl.ssl.gmvpn.crypto.TlsCertificate;
import kl.ssl.gmvpn.crypto.TlsCrypto;
import kl.ssl.gmvpn.crypto.impl.jcajce.JcaTlsCertificate;
import kl.ssl.gmvpn.crypto.impl.jcajce.JcaTlsCrypto;
import kl.ssl.jsse.BCSNIHostName;
import kl.ssl.jsse.BCSNIMatcher;
import kl.ssl.jsse.BCSNIServerName;
import org.bouncycastle.asn1.x500.X500Name;

abstract class JsseUtils {
    protected static X509Certificate[] EMPTY_CHAIN = new X509Certificate[0];

    JsseUtils() {
    }

    static boolean contains(String[] values, String value) {
        for (int i = 0; i < values.length; ++i) {
            if (!value.equals(values[i])) continue;
            return true;
        }
        return false;
    }

    public static String[] copyOf(String[] data, int newLength) {
        String[] tmp = new String[newLength];
        System.arraycopy(data, 0, tmp, 0, Math.min(data.length, newLength));
        return tmp;
    }

    static String getApplicationProtocol(SecurityParameters securityParameters) {
        if (null == securityParameters || !securityParameters.isApplicationProtocolSet()) {
            return null;
        }
        ProtocolName applicationProtocol = securityParameters.getApplicationProtocol();
        if (null == applicationProtocol) {
            return "";
        }
        return applicationProtocol.getUtf8Decoding();
    }

    static String getAuthStringClient(short signatureAlgorithm) throws IOException {
        switch (signatureAlgorithm) {
            case 1: {
                return "RSA";
            }
            case 2: {
                return "DSA";
            }
            case 3: {
                return "EC";
            }
            case 12: {
                return "SM2";
            }
        }
        throw new TlsFatalAlert(80);
    }

    public static String getAuthTypeClient(short clientCertificateType) throws IOException {
        switch (clientCertificateType) {
            case 0: {
                return "EC";
            }
            case 2: {
                return "DSA";
            }
            case 64: {
                return "EC";
            }
            case 1: {
                return "RSA";
            }
        }
        throw new TlsFatalAlert(80);
    }

    public static String getAuthTypeServer(int keyExchangeAlgorithm) throws IOException {
        switch (keyExchangeAlgorithm) {
            case 1: {
                return "RSA";
            }
            case 2: {
                return "SM2";
            }
        }
        throw new TlsFatalAlert(80);
    }

    public static kl.ssl.gmvpn.Certificate getCertificateMessage(TlsCrypto crypto, X509Certificate[] chain) throws IOException {
        if (chain == null || chain.length < 1) {
            return kl.ssl.gmvpn.Certificate.EMPTY_CHAIN;
        }
        TlsCertificate[] certificateList = new TlsCertificate[chain.length];
        try {
            for (int i = 0; i < chain.length; ++i) {
                certificateList[i] = crypto.createCertificate(chain[i].getEncoded());
            }
        }
        catch (CertificateEncodingException e) {
            throw new TlsFatalAlert(80, (Throwable)e);
        }
        return new kl.ssl.gmvpn.Certificate(certificateList);
    }

    public static Vector getProtocolNames(String[] applicationProtocols) {
        if (null == applicationProtocols || applicationProtocols.length < 1) {
            return null;
        }
        Vector<ProtocolName> protocolNames = new Vector<ProtocolName>(applicationProtocols.length);
        for (String applicationProtocol : applicationProtocols) {
            protocolNames.addElement(ProtocolName.asUtf8Encoding(applicationProtocol));
        }
        return protocolNames;
    }

    public static List<String> getProtocolNames(Vector applicationProtocols) {
        if (null == applicationProtocols || applicationProtocols.isEmpty()) {
            return null;
        }
        ArrayList<String> protocolNames = new ArrayList<String>(applicationProtocols.size());
        for (int i = 0; i < applicationProtocols.size(); ++i) {
            ProtocolName protocolName = (ProtocolName)applicationProtocols.elementAt(i);
            protocolNames.add(protocolName.getUtf8Decoding());
        }
        return protocolNames;
    }

    public static X509Certificate[] getX509CertificateChain(TlsCrypto crypto, kl.ssl.gmvpn.Certificate certificateMessage) {
        if (certificateMessage == null || certificateMessage.isEmpty()) {
            return EMPTY_CHAIN;
        }
        try {
            X509Certificate[] chain = new X509Certificate[certificateMessage.getLength()];
            for (int i = 0; i < chain.length; ++i) {
                chain[i] = JcaTlsCertificate.convert((JcaTlsCrypto)crypto, certificateMessage.getCertificateAt(i)).getX509Certificate();
            }
            return chain;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static X509Certificate[] getX509CertificateChain(Certificate[] chain) {
        if (chain == null) {
            return null;
        }
        if (chain instanceof X509Certificate[]) {
            return (X509Certificate[])chain;
        }
        X509Certificate[] x509Chain = new X509Certificate[chain.length];
        for (int i = 0; i < chain.length; ++i) {
            Certificate c = chain[i];
            if (!(c instanceof X509Certificate)) {
                return null;
            }
            x509Chain[i] = (X509Certificate)c;
        }
        return x509Chain;
    }

    public static X500Principal getSubject(TlsCrypto crypto, kl.ssl.gmvpn.Certificate certificateMessage) {
        if (certificateMessage == null || certificateMessage.isEmpty()) {
            return null;
        }
        try {
            return JcaTlsCertificate.convert((JcaTlsCrypto)crypto, certificateMessage.getCertificateAt(0)).getX509Certificate().getSubjectX500Principal();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static String getAlertLogMessage(String root, short alertLevel, short alertDescription) {
        return root + " " + AlertLevel.getText(alertLevel) + " " + AlertDescription.getText(alertDescription) + " alert";
    }

    static Vector getSupportedSignatureAlgorithms(TlsCrypto crypto) {
        short[] hashAlgorithms = new short[]{2, 3, 4, 5, 6, 7};
        short[] signatureAlgorithms = new short[]{1, 3};
        Vector result = new Vector();
        for (int i = 0; i < signatureAlgorithms.length; ++i) {
            for (int j = 0; j < hashAlgorithms.length; ++j) {
                TlsUtils.addIfSupported(result, crypto, new SignatureAndHashAlgorithm(hashAlgorithms[j], signatureAlgorithms[i]));
            }
        }
        TlsUtils.addIfSupported(result, crypto, new SignatureAndHashAlgorithm(2, 2));
        return result;
    }

    public static boolean isUsableKeyForServer(int keyExchangeAlgorithm, PrivateKey privateKey) throws IOException {
        if (privateKey == null) {
            return false;
        }
        String algorithm = privateKey.getAlgorithm();
        switch (keyExchangeAlgorithm) {
            case 2: {
                return privateKey instanceof ECPrivateKey || "EC".equals(algorithm);
            }
            case 1: {
                return privateKey instanceof RSAPrivateKey || "RSA".equals(algorithm);
            }
        }
        return false;
    }

    static Set<X500Principal> toX500Principals(X500Name[] names) throws IOException {
        if (names == null || names.length == 0) {
            return Collections.emptySet();
        }
        HashSet<X500Principal> principals = new HashSet<X500Principal>(names.length);
        for (int i = 0; i < names.length; ++i) {
            X500Name name = names[i];
            if (name == null) continue;
            principals.add(new X500Principal(name.getEncoded("DER")));
        }
        return principals;
    }

    static X500Name toX500Name(Principal principal) {
        if (principal == null) {
            return null;
        }
        if (principal instanceof X500Principal) {
            return X500Name.getInstance((Object)((X500Principal)principal).getEncoded());
        }
        return new X500Name(principal.getName());
    }

    static Set<X500Name> toX500Names(Principal[] principals) {
        if (principals == null || principals.length == 0) {
            return Collections.emptySet();
        }
        HashSet<X500Name> names = new HashSet<X500Name>(principals.length);
        for (int i = 0; i != principals.length; ++i) {
            X500Name name = JsseUtils.toX500Name(principals[i]);
            if (name == null) continue;
            names.add(name);
        }
        return names;
    }

    static BCSNIServerName convertSNIServerName(ServerName serverName) {
        short nameType = serverName.getNameType();
        byte[] nameData = serverName.getNameData();
        switch (nameType) {
            case 0: {
                return new BCSNIHostName(nameData);
            }
        }
        return new BCUnknownServerName(nameType, nameData);
    }

    static List<BCSNIServerName> convertSNIServerNames(Vector serverNameList) {
        if (null == serverNameList || serverNameList.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<BCSNIServerName> result = new ArrayList<BCSNIServerName>(serverNameList.size());
        Enumeration serverNames = serverNameList.elements();
        while (serverNames.hasMoreElements()) {
            result.add(JsseUtils.convertSNIServerName((ServerName)serverNames.nextElement()));
        }
        return Collections.unmodifiableList(result);
    }

    static BCSNIServerName findMatchingSNIServerName(Vector serverNameList, Collection<BCSNIMatcher> sniMatchers) {
        if (!serverNameList.isEmpty()) {
            List<BCSNIServerName> sniServerNames = JsseUtils.convertSNIServerNames(serverNameList);
            block0: for (BCSNIMatcher sniMatcher : sniMatchers) {
                if (null == sniMatcher) continue;
                int nameType = sniMatcher.getType();
                for (BCSNIServerName sniServerName : sniServerNames) {
                    if (null == sniServerName || sniServerName.getType() != nameType) continue;
                    if (!sniMatcher.matches(sniServerName)) continue block0;
                    return sniServerName;
                }
            }
        }
        return null;
    }

    static String stripDoubleQuotes(String s) {
        return JsseUtils.stripOuterChars(s, '\"', '\"');
    }

    static String stripSquareBrackets(String s) {
        return JsseUtils.stripOuterChars(s, '[', ']');
    }

    private static String stripOuterChars(String s, char openChar, char closeChar) {
        int sLast;
        if (s != null && (sLast = s.length() - 1) > 0 && s.charAt(0) == openChar && s.charAt(sLast) == closeChar) {
            return s.substring(1, sLast);
        }
        return s;
    }

    static class BCUnknownServerName
    extends BCSNIServerName {
        BCUnknownServerName(int nameType, byte[] encoded) {
            super(nameType, encoded);
        }
    }
}

