/*
 * Decompiled with CFR 0.152.
 */
package kl.ssl.gmvpn;

import kl.ssl.gmvpn.TlsContext;
import kl.ssl.gmvpn.crypto.TlsCrypto;
import kl.ssl.gmvpn.crypto.TlsHash;
import org.bouncycastle.util.Arrays;

public class CombinedHash
implements TlsHash {
    protected TlsContext context;
    protected TlsCrypto crypto;
    protected TlsHash md5;
    protected TlsHash sha1;

    CombinedHash(TlsContext context, TlsHash md5, TlsHash sha1) {
        this.context = context;
        this.crypto = context.getCrypto();
        this.md5 = md5;
        this.sha1 = sha1;
    }

    public CombinedHash(TlsCrypto crypto) {
        this.crypto = crypto;
        this.md5 = crypto.createHash((short)1);
        this.sha1 = crypto.createHash((short)2);
    }

    public CombinedHash(CombinedHash t) {
        this.context = t.context;
        this.crypto = t.crypto;
        this.md5 = (TlsHash)t.md5.clone();
        this.sha1 = (TlsHash)t.sha1.clone();
    }

    @Override
    public void update(byte[] input, int inOff, int len) {
        this.md5.update(input, inOff, len);
        this.sha1.update(input, inOff, len);
    }

    @Override
    public byte[] calculateHash() {
        return Arrays.concatenate((byte[])this.md5.calculateHash(), (byte[])this.sha1.calculateHash());
    }

    @Override
    public Object clone() {
        return new CombinedHash(this);
    }

    @Override
    public void reset() {
        this.md5.reset();
        this.sha1.reset();
    }
}

