/*
 * Decompiled with CFR 0.152.
 */
package kl.ssl.gmvpn;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import kl.ssl.gmvpn.AbstractTlsKeyExchange;
import kl.ssl.gmvpn.Certificate;
import kl.ssl.gmvpn.DigestInputBuffer;
import kl.ssl.gmvpn.SecurityParameters;
import kl.ssl.gmvpn.TlsCredentialedSignerAndDecryptor;
import kl.ssl.gmvpn.TlsCredentials;
import kl.ssl.gmvpn.TlsFatalAlert;
import kl.ssl.gmvpn.TlsSM2Utils;
import kl.ssl.gmvpn.TlsUtils;
import kl.ssl.gmvpn.crypto.SM2CipherText;
import kl.ssl.gmvpn.crypto.TlsCertificate;
import kl.ssl.gmvpn.crypto.TlsCryptoParameters;
import kl.ssl.gmvpn.crypto.TlsSecret;
import org.bouncycastle.asn1.ASN1Primitive;

public class TlsSM2KeyExchange
extends AbstractTlsKeyExchange {
    protected TlsCredentialedSignerAndDecryptor serverCredentials = null;
    protected TlsCertificate serverCertificate;
    protected TlsCertificate serverCertificateEnc;
    protected TlsSecret preMasterSecret;

    private static int checkKeyExchange(int keyExchange) {
        switch (keyExchange) {
            case 2: {
                return keyExchange;
            }
        }
        throw new IllegalArgumentException("unsupported key exchange algorithm");
    }

    @Override
    public boolean requiresServerKeyExchange() {
        return true;
    }

    public TlsSM2KeyExchange(int keyExchange) {
        super(TlsSM2KeyExchange.checkKeyExchange(keyExchange));
    }

    @Override
    public void skipServerCredentials() throws IOException {
        throw new TlsFatalAlert(80);
    }

    @Override
    public void processServerCredentials(TlsCredentials serverCredentials) throws IOException {
        this.serverCredentials = TlsUtils.requireSignerAndDecryptorCredentials(serverCredentials);
    }

    @Override
    public void processServerCertificate(Certificate serverCertificate) throws IOException {
        this.serverCertificate = serverCertificate.getCertificateAt(0).useInRole(0, 2);
        this.serverCertificateEnc = serverCertificate.getCertificateAt(1).useInRole(0, 2);
    }

    @Override
    public byte[] generateServerKeyExchange() throws IOException {
        if (!this.requiresServerKeyExchange()) {
            return null;
        }
        SecurityParameters securityParameters = this.context.getSecurityParameters();
        DigestInputBuffer digestBuffer = new DigestInputBuffer();
        TlsUtils.generateServerKeyExchangeSignature(this.context, this.serverCredentials, digestBuffer);
        return digestBuffer.toByteArray();
    }

    @Override
    public short[] getClientCertificateTypes() {
        return new short[]{1, 64};
    }

    @Override
    public void processClientCredentials(TlsCredentials clientCredentials) throws IOException {
        TlsUtils.requireSignerCredentials(clientCredentials);
    }

    @Override
    public void generateClientKeyExchange(OutputStream output) throws IOException {
        this.preMasterSecret = TlsSM2Utils.generateEncryptedPreMasterSecret(this.context, this.serverCertificateEnc, output);
    }

    @Override
    public void processClientKeyExchange(InputStream input) throws IOException {
        byte[] encryptedPreMasterSecret = TlsUtils.readOpaque16(input);
        SM2CipherText sm2CipherText = SM2CipherText.getInstance(ASN1Primitive.fromByteArray((byte[])encryptedPreMasterSecret));
        byte[] tmp = new byte[97 + sm2CipherText.getCipherText().length];
        byte[] x = sm2CipherText.getXCoordinate().toByteArray();
        byte[] y = sm2CipherText.getYCoordinate().toByteArray();
        byte[] c3 = sm2CipherText.getHash();
        byte[] c2 = sm2CipherText.getCipherText();
        tmp[0] = 4;
        if (x.length < 32) {
            System.arraycopy(x, 0, tmp, 32 - x.length + 1, x.length);
        } else {
            System.arraycopy(x, x.length - 32, tmp, 1, 32);
        }
        if (y.length < 32) {
            System.arraycopy(y, 0, tmp, 64 - y.length + 1, y.length);
        } else {
            System.arraycopy(y, y.length - 32, tmp, 33, 32);
        }
        System.arraycopy(c2, 0, tmp, 65, c2.length);
        System.arraycopy(c3, 0, tmp, 65 + c2.length, c3.length);
        this.preMasterSecret = this.serverCredentials.decrypt(new TlsCryptoParameters(this.context), tmp);
    }

    @Override
    public TlsSecret generatePreMasterSecret() throws IOException {
        TlsSecret tmp = this.preMasterSecret;
        this.preMasterSecret = null;
        return tmp;
    }

    @Override
    public void processServerKeyExchange(InputStream input) throws IOException {
        DigestInputBuffer digestBuffer = new DigestInputBuffer();
        byte[] der = this.serverCertificateEnc.getEncoded();
        TlsUtils.writeUint24(der.length, digestBuffer);
        digestBuffer.write(der);
        TlsUtils.verifyServerKeyExchangeSignature(this.context, input, this.serverCertificate, digestBuffer);
    }
}

