/*
 * Decompiled with CFR 0.152.
 */
package kl.ssl.jsse.provider;

import kl.ssl.gmvpn.Certificate;
import kl.ssl.gmvpn.ProtocolVersion;
import kl.ssl.gmvpn.SecurityParameters;
import kl.ssl.gmvpn.SessionParameters;
import kl.ssl.gmvpn.TlsSession;
import kl.ssl.jsse.provider.JsseSessionParameters;
import kl.ssl.jsse.provider.ProvSSLSessionContext;
import kl.ssl.jsse.provider.ProvSSLSessionHandshake;

class ProvSSLSessionResumed
extends ProvSSLSessionHandshake {
    protected final TlsSession tlsSession;
    protected final SessionParameters sessionParameters;
    protected final JsseSessionParameters jsseSessionParameters;

    ProvSSLSessionResumed(ProvSSLSessionContext sslSessionContext, String peerHost, int peerPort, SecurityParameters securityParameters, TlsSession tlsSession, JsseSessionParameters jsseSessionParameters) {
        super(sslSessionContext, peerHost, peerPort, securityParameters);
        this.tlsSession = tlsSession;
        this.sessionParameters = tlsSession.exportSessionParameters();
        this.jsseSessionParameters = jsseSessionParameters;
    }

    @Override
    protected int getCipherSuiteTLS() {
        return this.sessionParameters.getCipherSuite();
    }

    @Override
    protected byte[] getIDArray() {
        return this.tlsSession.getSessionID();
    }

    @Override
    protected JsseSessionParameters getJsseSessionParameters() {
        return this.jsseSessionParameters;
    }

    @Override
    protected Certificate getLocalCertificateTLS() {
        return this.sessionParameters.getLocalCertificate();
    }

    @Override
    protected Certificate getPeerCertificateTLS() {
        return this.sessionParameters.getPeerCertificate();
    }

    @Override
    protected ProtocolVersion getProtocolTLS() {
        return this.sessionParameters.getNegotiatedVersion();
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.tlsSession.invalidate();
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.tlsSession.isResumable();
    }
}

