/*
 * Decompiled with CFR 0.152.
 */
package com.koal.kms.sdk.ed.actor;

import com.koal.kms.sdk.ed.KmsSdkException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public abstract class AbstractEncryptor {
    public abstract String getTransformation();

    public String getAlgorithm() {
        String transformation = this.getTransformation();
        String[] splitTransformation = transformation.split("/");
        if (splitTransformation.length < 1) {
            throw new IllegalArgumentException("Illegal transformation,could not find algorithm in transformation :" + this.getTransformation());
        }
        return splitTransformation[0];
    }

    public byte[] encrypt(byte[] key, byte[] iv, byte[] plain) throws InvalidKeyException, InvalidAlgorithmParameterException, KmsSdkException {
        try {
            Cipher cipher = Cipher.getInstance(this.getTransformation());
            cipher.init(1, (Key)new SecretKeySpec(key, this.getAlgorithm()), new IvParameterSpec(iv));
            return cipher.doFinal(plain);
        }
        catch (NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new KmsSdkException("Catch an error when encrypt:", e);
        }
    }
}

