/*
 * Decompiled with CFR 0.152.
 */
package com.koal.kms.sdk.ed;

import com.koal.kms.sdk.ed.KmsCache;
import com.koal.kms.sdk.ed.KmsCtr;
import java.security.Key;
import java.security.Provider;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class KmsCfb {
    private static final byte[] IV = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final int MAX_COUNTER = 255;

    public static byte[] encrypt(byte[] plain, byte[] iv) {
        iv = iv == null ? IV : iv;
        try {
            Cipher cipher = Cipher.getInstance("SM4/CFB/NoPadding", "BC");
            SecretKeySpec key = new SecretKeySpec(KmsCache.CACHE.getCtrKey().getPlainKey(), "SM4");
            cipher.init(1, (Key)key, new IvParameterSpec(iv));
            return cipher.doFinal(plain);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static byte[] decrypt(byte[] cipher) {
        return KmsCfb.decrypt(cipher, IV);
    }

    static byte[] decrypt(byte[] cipher, byte[] iv) {
        iv = iv == null ? IV : iv;
        try {
            Cipher ci = Cipher.getInstance("SM4/CFB/NoPadding", "BC");
            SecretKeySpec key = new SecretKeySpec(KmsCache.CACHE.getCtrKey().getPlainKey(), "SM4");
            ci.init(2, (Key)key, new IvParameterSpec(iv));
            return ci.doFinal(cipher);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static byte[] convertCtrCipher2Cfb(byte[] cipher, byte[] iv) {
        return KmsCfb.encrypt(KmsCtr.decrypt(cipher), iv);
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

