/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.styling.GraphicImpl;
import org.geotools.styling.Stroke;
import org.geotools.styling.StyleVisitor;
import org.geotools.util.Utilities;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;
import org.opengis.style.Graphic;
import org.opengis.util.Cloneable;

public class StrokeImpl
implements Stroke,
Cloneable {
    private FilterFactory filterFactory;
    private Expression color;
    private List<Expression> dashArray;
    private Expression dashOffset;
    private GraphicImpl fillGraphic;
    private GraphicImpl strokeGraphic;
    private Expression lineCap;
    private Expression lineJoin;
    private Expression opacity;
    private Expression width;

    protected StrokeImpl() {
        this(CommonFactoryFinder.getFilterFactory((Hints)GeoTools.getDefaultHints()));
    }

    protected StrokeImpl(FilterFactory factory) {
        this.filterFactory = factory;
    }

    public void setFilterFactory(FilterFactory factory) {
        this.filterFactory = factory;
    }

    public Expression getColor() {
        return this.color;
    }

    public void setColor(Expression color) {
        if (this.color == color) {
            return;
        }
        this.color = color;
    }

    public void setColor(String color) {
        this.setColor((Expression)this.filterFactory.literal((Object)color));
    }

    public float[] getDashArray() {
        if (this.dashArray == null) {
            return Stroke.DEFAULT.getDashArray();
        }
        float[] values = new float[this.dashArray.size()];
        int index = 0;
        for (Expression expression : this.dashArray) {
            if (!(expression instanceof Literal)) {
                throw new RuntimeException("Dash array is not literal: '" + expression + "'.");
            }
            Literal literal = (Literal)expression;
            values[index] = ((Float)literal.evaluate(null, Float.class)).floatValue();
            ++index;
        }
        return values;
    }

    public void setDashArray(float[] literalDashArray) {
        if (literalDashArray != null) {
            this.dashArray = new ArrayList<Expression>(literalDashArray.length);
            for (float value : literalDashArray) {
                this.dashArray.add((Expression)this.filterFactory.literal(value));
            }
        }
    }

    public List<Expression> dashArray() {
        if (this.dashArray == null) {
            return Stroke.DEFAULT.dashArray();
        }
        return this.dashArray;
    }

    public void setDashArray(List<Expression> dashArray) {
        this.dashArray = dashArray;
    }

    public Expression getDashOffset() {
        if (this.dashOffset == null) {
            return Stroke.DEFAULT.getDashOffset();
        }
        return this.dashOffset;
    }

    public void setDashOffset(Expression dashOffset) {
        if (dashOffset == null) {
            return;
        }
        this.dashOffset = dashOffset;
    }

    public GraphicImpl getGraphicFill() {
        return this.fillGraphic;
    }

    public void setGraphicFill(Graphic fillGraphic) {
        if (this.fillGraphic == fillGraphic) {
            return;
        }
        this.fillGraphic = GraphicImpl.cast(fillGraphic);
    }

    public GraphicImpl getGraphicStroke() {
        return this.strokeGraphic;
    }

    public void setGraphicStroke(Graphic strokeGraphic) {
        if (this.strokeGraphic == strokeGraphic) {
            return;
        }
        this.strokeGraphic = GraphicImpl.cast(strokeGraphic);
    }

    public Expression getLineCap() {
        if (this.lineCap == null) {
            return Stroke.DEFAULT.getLineCap();
        }
        return this.lineCap;
    }

    public void setLineCap(Expression lineCap) {
        if (lineCap == null) {
            return;
        }
        this.lineCap = lineCap;
    }

    public Expression getLineJoin() {
        if (this.lineCap == null) {
            return Stroke.DEFAULT.getLineJoin();
        }
        return this.lineJoin;
    }

    public void setLineJoin(Expression lineJoin) {
        if (lineJoin == null) {
            return;
        }
        this.lineJoin = lineJoin;
    }

    public Expression getOpacity() {
        if (this.lineCap == null) {
            return Stroke.DEFAULT.getOpacity();
        }
        return this.opacity;
    }

    public void setOpacity(Expression opacity) {
        if (opacity == null) {
            return;
        }
        this.opacity = opacity;
    }

    public Expression getWidth() {
        if (this.width == null) {
            return this.filterFactory.literal(1.0);
        }
        return this.width;
    }

    public void setWidth(Expression width) {
        this.width = width;
    }

    public String toString() {
        StringBuffer out = new StringBuffer("org.geotools.styling.StrokeImpl:\n");
        out.append("\tColor " + this.color + "\n");
        out.append("\tWidth " + this.width + "\n");
        out.append("\tOpacity " + this.opacity + "\n");
        out.append("\tLineCap " + this.lineCap + "\n");
        out.append("\tLineJoin " + this.lineJoin + "\n");
        out.append("\tDash Array " + this.dashArray + "\n");
        out.append("\tDash Offset " + this.dashOffset + "\n");
        out.append("\tFill Graphic " + this.fillGraphic + "\n");
        out.append("\tStroke Graphic " + this.strokeGraphic);
        return out.toString();
    }

    public Color getColor(SimpleFeature feature) {
        return Color.decode((String)this.getColor().evaluate((Object)feature));
    }

    public Object accept(org.opengis.style.StyleVisitor visitor, Object data) {
        return visitor.visit((org.opengis.style.Stroke)this, data);
    }

    public void accept(StyleVisitor visitor) {
        visitor.visit((Stroke)this);
    }

    public Object clone() {
        try {
            StrokeImpl clone = (StrokeImpl)super.clone();
            if (this.dashArray != null) {
                clone.setDashArray(new ArrayList<Expression>(this.dashArray));
            }
            if (this.fillGraphic != null && this.fillGraphic instanceof Cloneable) {
                clone.fillGraphic = (GraphicImpl)this.fillGraphic.clone();
            }
            if (this.strokeGraphic != null && this.fillGraphic instanceof Cloneable) {
                clone.strokeGraphic = (GraphicImpl)this.strokeGraphic.clone();
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Failed to clone StrokeImpl");
        }
    }

    public int hashCode() {
        int PRIME = 1000003;
        int result = 0;
        if (this.color != null) {
            result = 1000003 * result + this.color.hashCode();
        }
        if (this.dashOffset != null) {
            result = 1000003 * result + this.dashOffset.hashCode();
        }
        if (this.fillGraphic != null) {
            result = 1000003 * result + this.fillGraphic.hashCode();
        }
        if (this.strokeGraphic != null) {
            result = 1000003 * result + this.strokeGraphic.hashCode();
        }
        if (this.lineCap != null) {
            result = 1000003 * result + this.lineCap.hashCode();
        }
        if (this.lineJoin != null) {
            result = 1000003 * result + this.lineJoin.hashCode();
        }
        if (this.opacity != null) {
            result = 1000003 * result + this.opacity.hashCode();
        }
        if (this.width != null) {
            result = 1000003 * result + this.width.hashCode();
        }
        if (this.dashArray != null) {
            result = 1000003 * result + this.dashArray.hashCode();
        }
        return result;
    }

    private int hashCodeDashArray(float[] a) {
        int PRIME = 1000003;
        if (a == null) {
            return 0;
        }
        int result = 0;
        for (int i = 0; i < a.length; ++i) {
            result = 1000003 * result + Float.floatToIntBits(a[i]);
        }
        return result;
    }

    public boolean equals(Object oth) {
        if (this == oth) {
            return true;
        }
        if (oth == null) {
            return false;
        }
        if (oth.getClass() != this.getClass()) {
            return false;
        }
        StrokeImpl other = (StrokeImpl)oth;
        if (!Utilities.equals((Object)this.getColor(), (Object)other.getColor())) {
            return false;
        }
        if (!Utilities.equals((Object)this.getWidth(), (Object)other.getWidth())) {
            return false;
        }
        if (!Utilities.equals((Object)this.getLineCap(), (Object)other.getLineCap())) {
            return false;
        }
        if (!Utilities.equals((Object)this.getLineJoin(), (Object)other.getLineJoin())) {
            return false;
        }
        if (!Utilities.equals((Object)this.getOpacity(), (Object)other.getOpacity())) {
            return false;
        }
        if (!Utilities.equals((Object)this.getGraphicFill(), (Object)other.getGraphicFill())) {
            return false;
        }
        if (!Utilities.equals((Object)this.getGraphicStroke(), (Object)other.getGraphicStroke())) {
            return false;
        }
        return Utilities.equals(this.dashArray(), other.dashArray());
    }

    static StrokeImpl cast(org.opengis.style.Stroke stroke) {
        if (stroke == null) {
            return null;
        }
        if (stroke instanceof StrokeImpl) {
            return (StrokeImpl)stroke;
        }
        StrokeImpl copy = new StrokeImpl();
        copy.setColor(stroke.getColor());
        copy.setDashArray(stroke.getDashArray());
        copy.setDashOffset(stroke.getDashOffset());
        copy.setGraphicFill((Graphic)GraphicImpl.cast((Graphic)stroke.getGraphicFill()));
        copy.setGraphicStroke((Graphic)GraphicImpl.cast((Graphic)stroke.getGraphicStroke()));
        copy.setLineCap(stroke.getLineCap());
        copy.setLineJoin(stroke.getLineJoin());
        copy.setOpacity(stroke.getOpacity());
        copy.setWidth(stroke.getWidth());
        return copy;
    }
}

