/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile.index.quadtree.fs;

import com.vividsolutions.jts.geom.Envelope;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.shapefile.index.quadtree.IndexStore;
import org.geotools.data.shapefile.index.quadtree.Node;
import org.geotools.data.shapefile.index.quadtree.QuadTree;
import org.geotools.data.shapefile.index.quadtree.StoreException;
import org.geotools.data.shapefile.index.quadtree.fs.FileSystemNode;
import org.geotools.data.shapefile.index.quadtree.fs.IndexHeader;
import org.geotools.data.shapefile.shp.IndexFile;
import org.geotools.util.logging.Logging;

public class FileSystemIndexStore
implements IndexStore {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.index.quadtree");
    private File file;
    private byte byteOrder;

    public FileSystemIndexStore(File file) {
        this.file = file;
        this.byteOrder = (byte)2;
    }

    public FileSystemIndexStore(File file, byte byteOrder) {
        this.file = file;
        this.byteOrder = byteOrder;
    }

    @Override
    public void store(QuadTree tree) throws StoreException {
        tree.trim();
        FileOutputStream fos = null;
        AbstractInterruptibleChannel channel = null;
        try {
            fos = new FileOutputStream(this.file);
            channel = fos.getChannel();
            ByteBuffer buf = ByteBuffer.allocate(8);
            if (this.byteOrder > 0) {
                LOGGER.finest("Writing file header");
                IndexHeader header = new IndexHeader(this.byteOrder);
                header.writeTo(buf);
                buf.flip();
                ((FileChannel)channel).write(buf);
            }
            ByteOrder order = FileSystemIndexStore.byteToOrder(this.byteOrder);
            buf.clear();
            buf.order(order);
            buf.putInt(tree.getNumShapes());
            buf.putInt(tree.getMaxDepth());
            buf.flip();
            ((FileChannel)channel).write(buf);
            this.writeNode(tree.getRoot(), (FileChannel)channel, order);
        }
        catch (IOException e) {
            throw new StoreException(e);
        }
        finally {
            try {
                channel.close();
            }
            catch (Exception exception) {}
            try {
                fos.close();
            }
            catch (Exception exception) {}
        }
    }

    private void writeNode(Node node, FileChannel channel, ByteOrder order) throws IOException, StoreException {
        int i;
        int offset = this.getSubNodeOffset(node);
        ByteBuffer buf = ByteBuffer.allocate(44 + node.getNumShapeIds() * 4);
        buf.order(order);
        buf.putInt(offset);
        Envelope env = node.getBounds();
        buf.putDouble(env.getMinX());
        buf.putDouble(env.getMinY());
        buf.putDouble(env.getMaxX());
        buf.putDouble(env.getMaxY());
        buf.putInt(node.getNumShapeIds());
        for (i = 0; i < node.getNumShapeIds(); ++i) {
            buf.putInt(node.getShapeId(i));
        }
        buf.putInt(node.getNumSubNodes());
        buf.flip();
        channel.write(buf);
        for (i = 0; i < node.getNumSubNodes(); ++i) {
            this.writeNode(node.getSubNode(i), channel, order);
        }
    }

    private int getSubNodeOffset(Node node) throws StoreException {
        int offset = 0;
        Node tmp = null;
        for (int i = 0; i < node.getNumSubNodes(); ++i) {
            tmp = node.getSubNode(i);
            offset += 32;
            offset += (tmp.getNumShapeIds() + 3) * 4;
            offset += this.getSubNodeOffset(tmp);
        }
        return offset;
    }

    @Override
    public QuadTree load(IndexFile indexfile, boolean useMemoryMapping) throws StoreException {
        QuadTree tree = null;
        try {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("Opening QuadTree " + this.file.getCanonicalPath());
            }
            final FileInputStream fis = new FileInputStream(this.file);
            final FileChannel channel = fis.getChannel();
            IndexHeader header = new IndexHeader(channel);
            ByteOrder order = FileSystemIndexStore.byteToOrder(header.getByteOrder());
            ByteBuffer buf = ByteBuffer.allocate(8);
            buf.order(order);
            channel.read(buf);
            buf.flip();
            tree = new QuadTree(buf.getInt(), buf.getInt(), indexfile){

                @Override
                public void insert(int recno, Envelope bounds) {
                    throw new UnsupportedOperationException("File quadtrees are immutable");
                }

                @Override
                public boolean trim() {
                    return false;
                }

                @Override
                public void close() throws StoreException {
                    super.close();
                    try {
                        channel.close();
                        fis.close();
                    }
                    catch (IOException e) {
                        throw new StoreException(e);
                    }
                }
            };
            tree.setRoot(FileSystemNode.readNode(0, null, channel, order, useMemoryMapping));
            LOGGER.finest("QuadTree opened");
        }
        catch (IOException e) {
            throw new StoreException(e);
        }
        return tree;
    }

    private static ByteOrder byteToOrder(byte order) {
        ByteOrder ret = null;
        switch (order) {
            case 0: {
                ret = ByteOrder.nativeOrder();
                break;
            }
            case -1: 
            case 1: {
                ret = ByteOrder.LITTLE_ENDIAN;
                break;
            }
            case -2: 
            case 2: {
                ret = ByteOrder.BIG_ENDIAN;
            }
        }
        return ret;
    }

    public int getByteOrder() {
        return this.byteOrder;
    }

    public void setByteOrder(byte byteOrder) {
        this.byteOrder = byteOrder;
    }
}

