/*
 * Decompiled with CFR 0.152.
 */
package kl.ssl.jsse.provider;

import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.Provider;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.X509TrustManager;
import kl.ssl.jsse.BCExtendedSSLSession;
import kl.ssl.jsse.BCSNIHostName;
import kl.ssl.jsse.BCSNIServerName;
import kl.ssl.jsse.BCSSLParameters;
import kl.ssl.jsse.BCX509ExtendedTrustManager;
import kl.ssl.jsse.provider.HostnameUtil;
import kl.ssl.jsse.provider.JsseUtils;
import kl.ssl.jsse.provider.PropertyUtils;
import kl.ssl.jsse.provider.SSLEngineUtil;
import kl.ssl.jsse.provider.SSLSocketUtil;
import kl.ssl.jsse.provider.X509TrustManagerUtil;
import org.bouncycastle.jcajce.util.JcaJceHelper;

public class ProvX509TrustManager
extends BCX509ExtendedTrustManager {
    private static final Logger LOG = Logger.getLogger(ProvX509TrustManager.class.getName());
    private static final boolean provCheckRevocation = PropertyUtils.getBooleanSystemProperty("com.sun.net.ssl.checkRevocation", false);
    public static boolean validateCertChain = true;
    public static boolean validateFullCertChain = false;
    private final JcaJceHelper helper;
    private final Set<X509Certificate> trustedCerts;
    private final PKIXParameters baseParameters;
    private final X509TrustManager exportX509TrustManager;

    ProvX509TrustManager(JcaJceHelper helper, Set<TrustAnchor> trustAnchors) throws InvalidAlgorithmParameterException {
        this.helper = helper;
        this.trustedCerts = ProvX509TrustManager.getTrustedCerts(trustAnchors);
        this.baseParameters = new PKIXBuilderParameters(trustAnchors, null);
        this.baseParameters.setRevocationEnabled(provCheckRevocation);
        this.exportX509TrustManager = X509TrustManagerUtil.exportX509TrustManager(this);
    }

    ProvX509TrustManager(JcaJceHelper helper, PKIXParameters baseParameters) throws InvalidAlgorithmParameterException {
        this.helper = helper;
        this.trustedCerts = ProvX509TrustManager.getTrustedCerts(baseParameters.getTrustAnchors());
        if (baseParameters instanceof PKIXBuilderParameters) {
            this.baseParameters = (PKIXBuilderParameters)baseParameters.clone();
            this.baseParameters.setTargetCertConstraints(null);
        } else {
            this.baseParameters = new PKIXBuilderParameters(baseParameters.getTrustAnchors(), null);
            this.baseParameters.setAnyPolicyInhibited(baseParameters.isAnyPolicyInhibited());
            this.baseParameters.setCertPathCheckers(baseParameters.getCertPathCheckers());
            this.baseParameters.setCertStores(baseParameters.getCertStores());
            this.baseParameters.setDate(baseParameters.getDate());
            this.baseParameters.setExplicitPolicyRequired(baseParameters.isExplicitPolicyRequired());
            this.baseParameters.setInitialPolicies(baseParameters.getInitialPolicies());
            this.baseParameters.setPolicyMappingInhibited(baseParameters.isPolicyMappingInhibited());
            this.baseParameters.setPolicyQualifiersRejected(baseParameters.getPolicyQualifiersRejected());
            this.baseParameters.setRevocationEnabled(baseParameters.isRevocationEnabled());
            this.baseParameters.setSigProvider(baseParameters.getSigProvider());
        }
        this.exportX509TrustManager = X509TrustManagerUtil.exportX509TrustManager(this);
    }

    X509TrustManager getExportX509TrustManager() {
        return this.exportX509TrustManager;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.checkTrusted(chain, authType, (Socket)null, false);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        this.checkTrusted(chain, authType, socket, false);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
        this.checkTrusted(chain, authType, engine, false);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.checkTrusted(chain, authType, (Socket)null, true);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        this.checkTrusted(chain, authType, socket, true);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
        this.checkTrusted(chain, authType, engine, true);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.trustedCerts.toArray(new X509Certificate[this.trustedCerts.size()]);
    }

    private void checkTrusted(X509Certificate[] chain, String authType, Socket socket, boolean isServer) throws CertificateException {
        if (validateCertChain) {
            this.validateChain(chain, authType, isServer);
        }
    }

    private void checkTrusted(X509Certificate[] chain, String authType, SSLEngine engine, boolean isServer) throws CertificateException {
        if (validateCertChain) {
            this.validateChain(chain, authType, isServer);
        }
    }

    private CertStoreParameters getCertStoreParameters(X509Certificate[] chain) {
        ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>(chain.length);
        certs.add(chain[0]);
        for (int i = 1; i < chain.length; ++i) {
            if (this.trustedCerts.contains(chain[i])) continue;
            certs.add(chain[i]);
        }
        return new CollectionCertStoreParameters(certs);
    }

    private X509Certificate[] validateChain(X509Certificate[] chain, String authType, boolean isServer) throws CertificateException {
        if (null == chain || chain.length < 1) {
            throw new IllegalArgumentException("'chain' must be a chain of at least one certificate");
        }
        if (null == authType || authType.length() < 1) {
            throw new IllegalArgumentException("'authType' must be a non-null, non-empty string");
        }
        for (X509Certificate certificate : chain) {
            try {
                certificate.checkValidity();
            }
            catch (Exception e) {
                throw new RuntimeException("server certificate['" + certificate.getSubjectDN().getName() + "'] date invalid", e);
            }
        }
        X509Certificate eeCert = chain[0];
        if (this.trustedCerts.contains(eeCert)) {
            return new X509Certificate[]{eeCert};
        }
        if (validateFullCertChain) {
            HashSet certificates = (HashSet)((HashSet)this.trustedCerts).clone();
            ProvX509TrustManager.findRootCA(certificates, eeCert);
        }
        try {
            CertificateFactory certificateFactory = this.helper.createCertificateFactory("X.509");
            Provider pkixProvider = certificateFactory.getProvider();
            CertStore certStore = CertStore.getInstance("Collection", this.getCertStoreParameters(chain), pkixProvider);
            X509CertSelector certSelector = new X509CertSelector();
            certSelector.setCertificate(eeCert);
            PKIXBuilderParameters certPathParameters = (PKIXBuilderParameters)this.baseParameters.clone();
            certPathParameters.addCertStore(certStore);
            certPathParameters.setTargetCertConstraints(certSelector);
            CertPathBuilder builder = CertPathBuilder.getInstance("PKIX", pkixProvider);
            PKIXCertPathBuilderResult result = (PKIXCertPathBuilderResult)builder.build(certPathParameters);
            return ProvX509TrustManager.getTrustedChain(result.getCertPath(), result.getTrustAnchor());
        }
        catch (GeneralSecurityException e) {
            throw new CertificateException("unable to process certificates: " + e.getMessage(), e);
        }
    }

    static void findRootCA(Set<X509Certificate> certSet, X509Certificate currentCert) {
        Certificate superCa = null;
        for (X509Certificate x509Certificate : certSet) {
            try {
                currentCert.verify(x509Certificate.getPublicKey());
                superCa = x509Certificate;
                break;
            }
            catch (Exception exception) {
            }
        }
        if (superCa == null) {
            throw new RuntimeException("client path error");
        }
        try {
            superCa.verify(superCa.getPublicKey());
            return;
        }
        catch (Exception exception) {
            certSet.remove(superCa);
            ProvX509TrustManager.findRootCA(certSet, (X509Certificate)superCa);
            return;
        }
    }

    static void checkExtendedTrust(X509Certificate[] trustedChain, String authType, Socket socket, boolean isServer) throws CertificateException {
        if (socket instanceof SSLSocket && socket.isConnected()) {
            SSLSocket sslSocket = (SSLSocket)socket;
            BCExtendedSSLSession sslSession = ProvX509TrustManager.getHandshakeSession(sslSocket);
            BCSSLParameters sslParameters = ProvX509TrustManager.getSSLParameters(sslSocket);
            ProvX509TrustManager.checkExtendedTrust(trustedChain, authType, isServer, sslSession, sslParameters);
        }
    }

    static void checkExtendedTrust(X509Certificate[] trustedChain, String authType, SSLEngine engine, boolean isServer) throws CertificateException {
        if (null != engine) {
            BCExtendedSSLSession sslSession = ProvX509TrustManager.getHandshakeSession(engine);
            BCSSLParameters sslParameters = ProvX509TrustManager.getSSLParameters(engine);
            ProvX509TrustManager.checkExtendedTrust(trustedChain, authType, isServer, sslSession, sslParameters);
        }
    }

    private static void checkExtendedTrust(X509Certificate[] trustedChain, String authType, boolean isServer, BCExtendedSSLSession sslSession, BCSSLParameters sslParameters) throws CertificateException {
        String endpointIDAlg = sslParameters.getEndpointIdentificationAlgorithm();
        if (null != endpointIDAlg && endpointIDAlg.length() > 0) {
            ProvX509TrustManager.checkEndpointID(trustedChain[0], endpointIDAlg, isServer, sslSession);
        }
    }

    private static void checkEndpointID(X509Certificate certificate, String endpointIDAlg, boolean isServer, BCExtendedSSLSession sslSession) throws CertificateException {
        String hostname;
        BCSNIHostName sniHostName;
        String peerHost = sslSession.getPeerHost();
        if (isServer && null != (sniHostName = ProvX509TrustManager.getSNIHostName(sslSession)) && !(hostname = sniHostName.getAsciiName()).equalsIgnoreCase(peerHost)) {
            try {
                ProvX509TrustManager.checkEndpointID(hostname, certificate, endpointIDAlg);
                return;
            }
            catch (CertificateException e) {
                LOG.log(Level.FINE, "Server's endpoint ID did not match the SNI host_name: " + hostname, e);
            }
        }
        ProvX509TrustManager.checkEndpointID(peerHost, certificate, endpointIDAlg);
    }

    private static void checkEndpointID(String hostname, X509Certificate certificate, String endpointIDAlg) throws CertificateException {
        hostname = JsseUtils.stripSquareBrackets(hostname);
        if (endpointIDAlg.equalsIgnoreCase("HTTPS")) {
            HostnameUtil.checkHostname(hostname, certificate, true);
        } else if (endpointIDAlg.equalsIgnoreCase("LDAP") || endpointIDAlg.equalsIgnoreCase("LDAPS")) {
            HostnameUtil.checkHostname(hostname, certificate, false);
        } else {
            throw new CertificateException("Unknown endpoint ID algorithm: " + endpointIDAlg);
        }
    }

    private static BCSNIHostName getSNIHostName(BCExtendedSSLSession sslSession) {
        List<BCSNIServerName> serverNames = sslSession.getRequestedServerNames();
        if (null != serverNames) {
            for (BCSNIServerName serverName : serverNames) {
                if (null == serverName || 0 != serverName.getType()) continue;
                if (serverName instanceof BCSNIHostName) {
                    return (BCSNIHostName)serverName;
                }
                try {
                    return new BCSNIHostName(serverName.getEncoded());
                }
                catch (RuntimeException e) {
                    return null;
                }
            }
        }
        return null;
    }

    private static BCExtendedSSLSession getHandshakeSession(SSLEngine sslEngine) throws CertificateException {
        BCExtendedSSLSession handshakeSession = SSLEngineUtil.importHandshakeSession(sslEngine);
        if (null == handshakeSession) {
            throw new CertificateException("No handshake session for engine");
        }
        return handshakeSession;
    }

    private static BCExtendedSSLSession getHandshakeSession(SSLSocket sslSocket) throws CertificateException {
        BCExtendedSSLSession handshakeSession = SSLSocketUtil.importHandshakeSession(sslSocket);
        if (null == handshakeSession) {
            throw new CertificateException("No handshake session for socket");
        }
        return handshakeSession;
    }

    private static BCSSLParameters getSSLParameters(SSLEngine sslEngine) throws CertificateException {
        BCSSLParameters sslParameters = SSLEngineUtil.importSSLParameters(sslEngine);
        if (null == sslParameters) {
            throw new CertificateException("No SSL parameters for engine");
        }
        return sslParameters;
    }

    private static BCSSLParameters getSSLParameters(SSLSocket sslSocket) throws CertificateException {
        BCSSLParameters sslParameters = SSLSocketUtil.importSSLParameters(sslSocket);
        if (null == sslParameters) {
            throw new CertificateException("No SSL parameters for socket");
        }
        return sslParameters;
    }

    private static X509Certificate getTrustedCert(TrustAnchor trustAnchor) throws CertificateException {
        X509Certificate trustedCert = trustAnchor.getTrustedCert();
        if (null == trustedCert) {
            throw new CertificateException("No certificate for TrustAnchor");
        }
        return trustedCert;
    }

    private static Set<X509Certificate> getTrustedCerts(Set<TrustAnchor> trustAnchors) {
        HashSet<X509Certificate> result = new HashSet<X509Certificate>(trustAnchors.size());
        for (TrustAnchor trustAnchor : trustAnchors) {
            X509Certificate trustedCert;
            if (null == trustAnchor || null == (trustedCert = trustAnchor.getTrustedCert())) continue;
            result.add(trustedCert);
        }
        return result;
    }

    private static X509Certificate[] getTrustedChain(CertPath certPath, TrustAnchor trustAnchor) throws CertificateException {
        List<? extends Certificate> certificates = certPath.getCertificates();
        X509Certificate[] result = new X509Certificate[certificates.size() + 1];
        certificates.toArray(result);
        result[result.length - 1] = ProvX509TrustManager.getTrustedCert(trustAnchor);
        return result;
    }
}

