/*
 * Decompiled with CFR 0.152.
 */
package kl.ssl.gmvpn;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import kl.ssl.gmvpn.IdentifierType;
import kl.ssl.gmvpn.TlsFatalAlert;
import kl.ssl.gmvpn.TlsUtils;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.util.Arrays;

public class TrustedAuthority {
    protected short identifierType;
    protected Object identifier;

    public TrustedAuthority(short identifierType, Object identifier) {
        if (!TrustedAuthority.isCorrectType(identifierType, identifier)) {
            throw new IllegalArgumentException("'identifier' is not an instance of the correct type");
        }
        this.identifierType = identifierType;
        this.identifier = identifier;
    }

    public short getIdentifierType() {
        return this.identifierType;
    }

    public Object getIdentifier() {
        return this.identifier;
    }

    public byte[] getCertSHA1Hash() {
        return Arrays.clone((byte[])((byte[])this.identifier));
    }

    public byte[] getKeySHA1Hash() {
        return Arrays.clone((byte[])((byte[])this.identifier));
    }

    public X500Name getX509Name() {
        this.checkCorrectType((short)2);
        return (X500Name)this.identifier;
    }

    public void encode(OutputStream output) throws IOException {
        TlsUtils.writeUint8(this.identifierType, output);
        switch (this.identifierType) {
            case 1: 
            case 3: {
                byte[] sha1Hash = (byte[])this.identifier;
                output.write(sha1Hash);
                break;
            }
            case 0: {
                break;
            }
            case 2: {
                X500Name dn = (X500Name)this.identifier;
                byte[] derEncoding = dn.getEncoded("DER");
                TlsUtils.writeOpaque16(derEncoding, output);
                break;
            }
            default: {
                throw new TlsFatalAlert(80);
            }
        }
    }

    public static TrustedAuthority parse(InputStream input) throws IOException {
        byte[] identifier2;
        short identifier_type = TlsUtils.readUint8(input);
        switch (identifier_type) {
            case 1: 
            case 3: {
                identifier2 = TlsUtils.readFully(20, input);
                break;
            }
            case 0: {
                identifier2 = null;
                break;
            }
            case 2: {
                byte[] derEncoding = TlsUtils.readOpaque16(input, 1);
                ASN1Primitive asn1 = TlsUtils.readDERObject(derEncoding);
                X500Name identifier2 = X500Name.getInstance((Object)asn1);
            }
            default: {
                throw new TlsFatalAlert(50);
            }
        }
        return new TrustedAuthority(identifier_type, identifier2);
    }

    protected void checkCorrectType(short expectedIdentifierType) {
        if (this.identifierType != expectedIdentifierType || !TrustedAuthority.isCorrectType(expectedIdentifierType, this.identifier)) {
            throw new IllegalStateException("TrustedAuthority is not of type " + IdentifierType.getName(expectedIdentifierType));
        }
    }

    protected static boolean isCorrectType(short identifierType, Object identifier) {
        switch (identifierType) {
            case 1: 
            case 3: {
                return TrustedAuthority.isSHA1Hash(identifier);
            }
            case 0: {
                return identifier == null;
            }
            case 2: {
                return identifier instanceof X500Name;
            }
        }
        throw new IllegalArgumentException("'identifierType' is an unsupported IdentifierType");
    }

    protected static boolean isSHA1Hash(Object identifier) {
        return identifier instanceof byte[] && ((byte[])identifier).length == 20;
    }
}

