/*
 * Decompiled with CFR 0.152.
 */
package kl.ssl.gmvpn.crypto.impl.jcajce;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.interfaces.ECPrivateKey;
import kl.ssl.gmvpn.SignatureAndHashAlgorithm;
import kl.ssl.gmvpn.TlsFatalAlert;
import kl.ssl.gmvpn.crypto.TlsSigner;
import kl.ssl.gmvpn.crypto.TlsStreamSigner;
import kl.ssl.gmvpn.crypto.impl.jcajce.JcaTlsCrypto;

public class JcaTlsSM2Signer
implements TlsSigner {
    private final JcaTlsCrypto crypto;
    private final PrivateKey privateKey;

    public JcaTlsSM2Signer(JcaTlsCrypto crypto, ECPrivateKey privateKey) {
        if (null == crypto) {
            throw new NullPointerException("crypto");
        }
        if (null == privateKey) {
            throw new NullPointerException("privateKey");
        }
        this.crypto = crypto;
        this.privateKey = privateKey;
    }

    @Override
    public byte[] generateRawSignature(SignatureAndHashAlgorithm algorithm, byte[] hash) throws IOException {
        try {
            Signature signer = this.crypto.getHelper().createSignature("SM3WITHSM2");
            signer.initSign(this.privateKey, this.crypto.getSecureRandom());
            signer.update(hash, 0, hash.length);
            byte[] tmp = signer.sign();
            return tmp;
        }
        catch (GeneralSecurityException e) {
            throw new TlsFatalAlert(80, (Throwable)e);
        }
    }

    @Override
    public TlsStreamSigner getStreamSigner(SignatureAndHashAlgorithm algorithm) throws IOException {
        return null;
    }
}

