/*
 * Decompiled with CFR 0.152.
 */
package com.koal.kms.sdk.ed;

import com.ghca.kms.thrift.api.ChallengeRequest;
import com.ghca.kms.thrift.api.KmsApi;
import com.ghca.kms.thrift.api.PingRequest;
import com.koal.kms.sdk.ed.AbstractKmsClient;
import com.koal.kms.sdk.ed.KmsClientConfig;
import com.koal.kms.sdk.ed.thrift.ThriftClient;
import com.koal.kms.sdk.ed.thrift.constants.ServiceLevel;
import com.koal.kms.sdk.ed.thrift.failover.ConnectionValidator;
import com.koal.kms.sdk.ed.thrift.failover.FailoverStrategy;
import com.koal.kms.sdk.ed.thrift.pool.ThriftServer;
import java.util.concurrent.TimeUnit;
import org.apache.commons.pool2.impl.GenericKeyedObjectPoolConfig;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.transport.TTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KmsClientThriftImpl
extends AbstractKmsClient {
    private static final Logger logger = LoggerFactory.getLogger(KmsClientThriftImpl.class);
    private final KmsClientConfig kmsClientConfig = KmsClientConfig.getInstance();
    private static volatile KmsClientThriftImpl instance;
    private final ThriftClient thriftClient;

    private KmsClientThriftImpl() {
        KmsClientConfig kmsClientConfig = KmsClientConfig.getInstance();
        KmsClientConfig.Pooling pool = kmsClientConfig.getPooling();
        GenericKeyedObjectPoolConfig poolConfig = new GenericKeyedObjectPoolConfig();
        poolConfig.setMaxIdlePerKey(pool.getMaxTotal());
        poolConfig.setMinIdlePerKey(pool.getMinIdle());
        poolConfig.setTestOnBorrow(pool.getTestOnBorrow());
        poolConfig.setTestOnReturn(pool.getTestOnReturn());
        poolConfig.setTestWhileIdle(pool.getTestWhileIdle());
        ConnectionValidator validator = object -> {
            TBinaryProtocol tBinaryProtocol = new TBinaryProtocol(object);
            KmsApi.Client client = new KmsApi.Client(tBinaryProtocol);
            if (this.ping(client)) {
                return true;
            }
            return this.getChallenge(client);
        };
        FailoverStrategy<ThriftServer> failoverStrategy = new FailoverStrategy<ThriftServer>(pool.getFailCount(), TimeUnit.SECONDS.toMillis(pool.getFailDuration()), TimeUnit.SECONDS.toMillis(pool.getRecoverDuration()));
        this.thriftClient = new ThriftClient();
        this.thriftClient.servers(kmsClientConfig.getAddress()).loadBalance(kmsClientConfig.getLoadBalance()).connectionValidator(validator).poolConfig((GenericKeyedObjectPoolConfig<TTransport>)poolConfig).failoverStrategy(failoverStrategy).transportCreator(kmsClientConfig).connTimeout(pool.getTestConnTime()).backupServers("").serviceLevel(ServiceLevel.SERVERS_ONLY).start();
        Runtime.getRuntime().addShutdownHook(new Thread(this.thriftClient::close));
    }

    private boolean ping(KmsApi.Client client) {
        try {
            client.ping(new PingRequest("ping"));
            return true;
        }
        catch (TException e) {
            return false;
        }
    }

    private boolean getChallenge(KmsApi.Client client) {
        try {
            ChallengeRequest request = new ChallengeRequest();
            request.setAccessKey(this.kmsClientConfig.getAccessKey());
            client.getChallenge(request);
            return true;
        }
        catch (TException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static KmsClientThriftImpl getInstance() {
        if (instance != null) return instance;
        Class<KmsClientThriftImpl> clazz = KmsClientThriftImpl.class;
        synchronized (KmsClientThriftImpl.class) {
            if (instance != null) return instance;
            instance = new KmsClientThriftImpl();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    protected KmsApi.Client getKmsApiClient() throws TException {
        return this.thriftClient.iface(KmsApi.Client.class);
    }

    @Override
    protected void returnKmsApiClient(KmsApi.Client client) throws TException {
    }

    @Override
    public KmsApi.Client getApiClient() throws TException {
        return this.getKmsApiClient();
    }

    @Override
    public void closeKmsClient(KmsApi.Client client) throws TException {
        this.returnKmsApiClient(client);
    }
}

