/*
 * Decompiled with CFR 0.152.
 */
package kl.ssl.jsse.provider;

import java.io.IOException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Logger;
import javax.net.ssl.SSLException;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.security.auth.x500.X500Principal;
import kl.ssl.gmvpn.Certificate;
import kl.ssl.gmvpn.CertificateRequest;
import kl.ssl.gmvpn.DefaultTlsServer;
import kl.ssl.gmvpn.TlsCredentials;
import kl.ssl.gmvpn.TlsFatalAlert;
import kl.ssl.gmvpn.TlsSession;
import kl.ssl.gmvpn.TlsUtils;
import kl.ssl.gmvpn.crypto.TlsCertificate;
import kl.ssl.gmvpn.crypto.TlsCrypto;
import kl.ssl.gmvpn.crypto.TlsCryptoParameters;
import kl.ssl.gmvpn.crypto.impl.jcajce.JcaDefaultTlsCredentialedSignerAndDecryptor;
import kl.ssl.gmvpn.crypto.impl.jcajce.JcaTlsCrypto;
import kl.ssl.jsse.BCX509ExtendedTrustManager;
import kl.ssl.jsse.provider.JsseSessionParameters;
import kl.ssl.jsse.provider.JsseUtils;
import kl.ssl.jsse.provider.PropertyUtils;
import kl.ssl.jsse.provider.ProvSSLConnection;
import kl.ssl.jsse.provider.ProvSSLParameters;
import kl.ssl.jsse.provider.ProvSSLSession;
import kl.ssl.jsse.provider.ProvSSLSessionContext;
import kl.ssl.jsse.provider.ProvTlsManager;
import kl.ssl.jsse.provider.ProvTlsPeer;
import org.bouncycastle.asn1.x500.X500Name;

class ProvTlsServer
extends DefaultTlsServer
implements ProvTlsPeer {
    private static final Logger LOG = Logger.getLogger(ProvTlsServer.class.getName());
    private static final int provEphemeralDHKeySize = PropertyUtils.getIntegerSystemProperty("jdk.tls.ephemeralDHKeySize", 2048, 1024, 8192);
    protected final ProvTlsManager manager;
    protected final ProvSSLParameters sslParameters;
    protected ProvSSLSession sslSession = null;
    protected Set<String> keyManagerMissCache = null;
    protected TlsCredentials credentials = null;
    protected boolean handshakeComplete = false;

    ProvTlsServer(ProvTlsManager manager, ProvSSLParameters sslParameters) throws SSLException {
        super(manager.getContextData().getCrypto());
        this.manager = manager;
        this.sslParameters = sslParameters.copy();
        if (!manager.getEnableSessionCreation()) {
            throw new SSLException("Session resumption not implemented yet and session creation is disabled");
        }
    }

    @Override
    public synchronized boolean isHandshakeComplete() {
        return this.handshakeComplete;
    }

    @Override
    public CertificateRequest getCertificateRequest() throws IOException {
        boolean shouldRequest;
        boolean bl = shouldRequest = this.sslParameters.getNeedClientAuth() || this.sslParameters.getWantClientAuth();
        if (!shouldRequest) {
            return null;
        }
        short[] certificateTypes = new short[]{64};
        Vector serverSigAlgs = null;
        if (TlsUtils.isSignatureAlgorithmsExtensionAllowed(this.context.getServerVersion())) {
            serverSigAlgs = JsseUtils.getSupportedSignatureAlgorithms(this.getCrypto());
        }
        Vector<X500Name> certificateAuthorities = null;
        HashSet<X500Principal> caSubjects = new HashSet<X500Principal>();
        BCX509ExtendedTrustManager x509TrustManager = this.manager.getContextData().getX509TrustManager();
        for (X509Certificate caCert : x509TrustManager.getAcceptedIssuers()) {
            caSubjects.add(caCert.getSubjectX500Principal());
        }
        if (!caSubjects.isEmpty()) {
            certificateAuthorities = new Vector<X500Name>(caSubjects.size());
            for (X500Principal caSubject : caSubjects) {
                certificateAuthorities.addElement(X500Name.getInstance((Object)caSubject.getEncoded()));
            }
        }
        return new CertificateRequest(certificateTypes, serverSigAlgs, certificateAuthorities);
    }

    @Override
    public void notifyClientCertificate(Certificate clientCertificate) throws IOException {
        if (!this.sslParameters.getNeedClientAuth() && !this.sslParameters.getWantClientAuth()) {
            throw new TlsFatalAlert(80);
        }
        if (null == clientCertificate || clientCertificate.isEmpty()) {
            if (this.sslParameters.getNeedClientAuth()) {
                short alertDescription = 40;
                throw new TlsFatalAlert(alertDescription);
            }
        } else {
            X509Certificate[] chain = JsseUtils.getX509CertificateChain(this.getCrypto(), clientCertificate);
            short signatureAlgorithm = clientCertificate.getCertificateAt(0).getLegacySignatureAlgorithm();
            String authType = JsseUtils.getAuthStringClient(signatureAlgorithm);
            this.manager.checkClientTrusted(chain, authType);
        }
    }

    @Override
    public synchronized void notifyHandshakeComplete() throws IOException {
        super.notifyHandshakeComplete();
        this.handshakeComplete = true;
        TlsSession connectionTlsSession = this.context.getSession();
        if (null == this.sslSession || this.sslSession.getTlsSession() != connectionTlsSession) {
            ProvSSLSessionContext sslSessionContext = this.manager.getContextData().getClientSessionContext();
            String peerHost = this.manager.getPeerHost();
            int peerPort = this.manager.getPeerPort();
            JsseSessionParameters jsseSessionParameters = new JsseSessionParameters(this.sslParameters.getEndpointIdentificationAlgorithm());
            this.sslSession = sslSessionContext.reportSession(peerHost, peerPort, connectionTlsSession, jsseSessionParameters);
        }
        this.manager.notifyHandshakeComplete(new ProvSSLConnection(this.context, this.sslSession));
    }

    @Override
    public TlsCredentials getCredentials() throws IOException {
        X509ExtendedKeyManager x509KeyManager = this.manager.getContextData().getX509KeyManager();
        PrivateKey sigPrivateKey = x509KeyManager.getPrivateKey(SIGN_CERT_PRIVATE_KEY_ALIAS);
        PrivateKey encPrivateKey = x509KeyManager.getPrivateKey(ENC_CERT_PRIVATE_KEY_ALIAS);
        TlsCrypto crypto = this.getCrypto();
        Certificate sigCert = JsseUtils.getCertificateMessage(crypto, x509KeyManager.getCertificateChain(SIGN_CERT_ALIAS));
        Certificate encCert = JsseUtils.getCertificateMessage(crypto, x509KeyManager.getCertificateChain(ENC_CERT_ALIAS));
        TlsCertificate[] list = new TlsCertificate[]{sigCert.getCertificateAt(0), encCert.getCertificateAt(0)};
        Certificate cert = new Certificate(list);
        PrivateKey[] privateKey = new PrivateKey[]{sigPrivateKey, encPrivateKey};
        TlsCryptoParameters cryptoParams = new TlsCryptoParameters(this.context);
        return new JcaDefaultTlsCredentialedSignerAndDecryptor(cryptoParams, (JcaTlsCrypto)this.context.getCrypto(), cert, privateKey, null);
    }
}

