/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.io.IOException;
import java.util.NoSuchElementException;
import org.geotools.data.FeatureWriter;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;

public class FilteringFeatureWriter
implements FeatureWriter<SimpleFeatureType, SimpleFeature> {
    FeatureWriter<SimpleFeatureType, SimpleFeature> writer;
    Filter filter;
    SimpleFeature next = null;
    SimpleFeature current = null;

    public FilteringFeatureWriter(FeatureWriter<SimpleFeatureType, SimpleFeature> writer, Filter filter) {
        this.writer = writer;
        this.filter = filter;
    }

    public SimpleFeatureType getFeatureType() {
        return (SimpleFeatureType)this.writer.getFeatureType();
    }

    public SimpleFeature next() throws IOException {
        if (this.hasNext()) {
            this.current = this.next;
            this.next = null;
            return this.current;
        }
        if (this.writer == null) {
            throw new IOException("FeatureWriter has been closed");
        }
        throw new NoSuchElementException("FeatureWriter does not have additional content");
    }

    public void remove() throws IOException {
        if (this.writer == null) {
            throw new IOException("FeatureWriter has been closed");
        }
        if (this.current == null) {
            throw new IOException("No feature available to remove");
        }
        this.current = null;
        this.writer.remove();
    }

    public void write() throws IOException {
        if (this.writer == null) {
            throw new IOException("FeatureWriter has been closed");
        }
        if (this.current == null) {
            throw new IOException("No feature available to write");
        }
        this.writer.write();
        this.current = null;
    }

    public boolean hasNext() throws IOException {
        if (this.next != null) {
            return true;
        }
        if (this.writer == null) {
            return false;
        }
        if (this.current != null) {
            this.current = null;
        }
        while (this.writer.hasNext()) {
            SimpleFeature peek = (SimpleFeature)this.writer.next();
            if (!this.filter.evaluate((Object)peek)) continue;
            this.next = peek;
            return true;
        }
        return false;
    }

    public void close() throws IOException {
        if (this.writer != null) {
            this.writer.close();
            this.writer = null;
        }
        if (this.filter != null) {
            this.filter = null;
        }
        this.current = null;
        this.next = null;
    }
}

