/*
 * Decompiled with CFR 0.152.
 */
package kl.ssl.gmvpn.crypto.impl.jcajce;

import java.io.IOException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.RSAPrivateKey;
import kl.ssl.gmvpn.Certificate;
import kl.ssl.gmvpn.ProtocolVersion;
import kl.ssl.gmvpn.SignatureAndHashAlgorithm;
import kl.ssl.gmvpn.TlsCredentialedSignerAndDecryptor;
import kl.ssl.gmvpn.crypto.TlsCryptoParameters;
import kl.ssl.gmvpn.crypto.TlsSecret;
import kl.ssl.gmvpn.crypto.TlsSigner;
import kl.ssl.gmvpn.crypto.TlsStreamSigner;
import kl.ssl.gmvpn.crypto.impl.TlsImplUtils;
import kl.ssl.gmvpn.crypto.impl.jcajce.JcaTlsCrypto;
import kl.ssl.gmvpn.crypto.impl.jcajce.JcaTlsRSASigner;
import kl.ssl.gmvpn.crypto.impl.jcajce.JcaTlsSM2Signer;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.SM2Engine;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.util.PrivateKeyFactory;

public class JcaDefaultTlsCredentialedSignerAndDecryptor
implements TlsCredentialedSignerAndDecryptor {
    protected JcaTlsCrypto crypto;
    protected TlsCryptoParameters cryptoParams;
    protected Certificate certificate;
    protected PrivateKey[] privateKey;
    protected TlsSigner signer;
    protected SignatureAndHashAlgorithm signatureAndHashAlgorithm;

    public JcaDefaultTlsCredentialedSignerAndDecryptor(TlsCryptoParameters cryptoParams, JcaTlsCrypto crypto, Certificate certificate, PrivateKey[] privateKey, SignatureAndHashAlgorithm signatureAndHashAlgorithm) {
        this.crypto = crypto;
        this.certificate = certificate;
        this.privateKey = privateKey;
        this.signatureAndHashAlgorithm = signatureAndHashAlgorithm;
        this.signer = JcaDefaultTlsCredentialedSignerAndDecryptor.makeSigner(crypto, privateKey[0], certificate, signatureAndHashAlgorithm);
        this.cryptoParams = cryptoParams;
    }

    @Override
    public Certificate getCertificate() {
        return this.certificate;
    }

    @Override
    public TlsSecret decrypt(TlsCryptoParameters cryptoParams, byte[] ciphertext) throws IOException {
        AsymmetricKeyParameter key = PrivateKeyFactory.createKey((byte[])this.privateKey[1].getEncoded());
        return this.safeDecryptPreMasterSecret(cryptoParams, (ECPrivateKeyParameters)key, ciphertext);
    }

    protected TlsSecret safeDecryptPreMasterSecret(TlsCryptoParameters cryptoParams, ECPrivateKeyParameters sm2ServerPrivateKey, byte[] encryptedPreMasterSecret) {
        SecureRandom secureRandom = this.crypto.getSecureRandom();
        ProtocolVersion clientVersion = cryptoParams.getClientVersion();
        SM2Engine sm2Engine = new SM2Engine();
        sm2Engine.init(false, (CipherParameters)sm2ServerPrivateKey);
        byte[] tmp = null;
        try {
            tmp = sm2Engine.processBlock(encryptedPreMasterSecret, 0, encryptedPreMasterSecret.length);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.crypto.createSecret(tmp);
    }

    private static TlsSigner makeSigner(JcaTlsCrypto crypto, PrivateKey privateKey, Certificate certificate, SignatureAndHashAlgorithm signatureAndHashAlgorithm) {
        TlsSigner signer;
        if (privateKey instanceof RSAPrivateKey) {
            signer = new JcaTlsRSASigner(crypto, privateKey);
        } else if (privateKey instanceof ECPrivateKey) {
            signer = new JcaTlsSM2Signer(crypto, (ECPrivateKey)privateKey);
        } else {
            throw new IllegalArgumentException("'privateKey' type not supported: " + privateKey.getClass().getName());
        }
        return signer;
    }

    @Override
    public byte[] generateRawSignature(byte[] hash) throws IOException {
        return this.signer.generateRawSignature(this.getEffectiveAlgorithm(), hash);
    }

    @Override
    public SignatureAndHashAlgorithm getSignatureAndHashAlgorithm() {
        return this.signatureAndHashAlgorithm;
    }

    @Override
    public TlsStreamSigner getStreamSigner() throws IOException {
        return this.signer.getStreamSigner(this.getEffectiveAlgorithm());
    }

    protected SignatureAndHashAlgorithm getEffectiveAlgorithm() {
        SignatureAndHashAlgorithm algorithm = null;
        if (TlsImplUtils.isTLSv12(this.cryptoParams) && (algorithm = this.getSignatureAndHashAlgorithm()) == null) {
            throw new IllegalStateException("'signatureAndHashAlgorithm' cannot be null for (D)TLS 1.2+");
        }
        return algorithm;
    }
}

