/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.awt.geom.AffineTransform;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.DataSourceException;
import org.geotools.referencing.operation.matrix.GeneralMatrix;
import org.geotools.referencing.operation.transform.ProjectiveTransform;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.logging.Logging;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;

public class WorldFileReader {
    public static final int DEFAULT_BUFFER_SIZE = 4096;
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.data.data");
    private double xPixelSize = 0.0;
    private double rotationX = 0.0;
    private double rotationY = 0.0;
    private double yPixelSize = 0.0;
    private double xULC = 0.0;
    private double yULC = 0.0;
    private GeneralMatrix transform;

    public WorldFileReader(File inFile) throws IOException {
        this(inFile, 4096);
    }

    public WorldFileReader(File worldfile, int bufferSize) throws IOException {
        if (worldfile == null) {
            throw new IllegalArgumentException(Errors.format((int)143, (Object)"worldfile"));
        }
        if (!worldfile.isFile() || !worldfile.canRead()) {
            throw new IllegalArgumentException(Errors.format((int)50, (Object)worldfile));
        }
        if (bufferSize <= 0) {
            throw new IllegalArgumentException(Errors.format((int)58, (Object)"bufferSize", (Object)bufferSize));
        }
        this.parseWorldFile(new BufferedReader(new FileReader(worldfile)));
    }

    public WorldFileReader(URL worldfile, int bufferSize) throws IOException {
        if (worldfile == null) {
            throw new IllegalArgumentException(Errors.format((int)143, (Object)"inFile"));
        }
        if (bufferSize <= 0) {
            throw new IllegalArgumentException(Errors.format((int)58, (Object)"bufferSize", (Object)bufferSize));
        }
        this.parseWorldFile(new BufferedReader(new InputStreamReader(worldfile.openStream())));
    }

    public WorldFileReader(URL worldfile) throws IOException {
        this(worldfile, 4096);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseWorldFile(BufferedReader bufferedreader) throws IOException, DataSourceException {
        int index = 0;
        try {
            String str;
            while ((str = bufferedreader.readLine()) != null) {
                double value = 0.0;
                try {
                    value = Double.parseDouble(str.trim());
                }
                catch (Throwable t) {
                    if (!LOGGER.isLoggable(Level.FINE)) continue;
                    LOGGER.log(Level.FINE, t.getLocalizedMessage(), t);
                    continue;
                }
                switch (index) {
                    case 0: {
                        this.xPixelSize = value;
                        break;
                    }
                    case 1: {
                        this.rotationX = value;
                        break;
                    }
                    case 2: {
                        this.rotationY = value;
                        break;
                    }
                    case 3: {
                        this.yPixelSize = value;
                        break;
                    }
                    case 4: {
                        this.xULC = value;
                        break;
                    }
                    case 5: {
                        this.yULC = value;
                        break;
                    }
                }
                ++index;
            }
        }
        catch (Exception t) {
        }
        finally {
            block24: {
                try {
                    bufferedreader.close();
                }
                catch (Throwable t) {
                    if (!LOGGER.isLoggable(Level.FINE)) break block24;
                    LOGGER.log(Level.FINE, t.getLocalizedMessage(), t);
                }
            }
        }
        if (index < 5) {
            throw new DataSourceException("Not all the values were found for this world file!");
        }
    }

    public double getRotationX() {
        return this.rotationX;
    }

    public double getRotationY() {
        return this.rotationY;
    }

    public double getXPixelSize() {
        return this.xPixelSize;
    }

    public double getXULC() {
        return this.xULC;
    }

    public double getYPixelSize() {
        return this.yPixelSize;
    }

    public double getYULC() {
        return this.yULC;
    }

    public synchronized MathTransform getTransform() {
        this.initTransform();
        return ProjectiveTransform.create((Matrix)this.transform);
    }

    private void initTransform() {
        if (this.transform == null) {
            GeneralMatrix gm = new GeneralMatrix(3);
            gm.setElement(0, 0, this.xPixelSize);
            gm.setElement(1, 1, this.yPixelSize);
            gm.setElement(0, 1, this.rotationX);
            gm.setElement(1, 0, this.rotationY);
            gm.setElement(0, 2, this.xULC);
            gm.setElement(1, 2, this.yULC);
            this.transform = gm;
        }
    }

    public synchronized AffineTransform getAffineTransform() {
        this.initTransform();
        return this.transform.toAffineTransform2D();
    }
}

