/*
 * Decompiled with CFR 0.152.
 */
package kl.ssl.gmvpn.crypto.impl.jcajce;

import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.ECPublicKey;
import kl.ssl.gmvpn.DigitallySigned;
import kl.ssl.gmvpn.TlsFatalAlert;
import kl.ssl.gmvpn.crypto.TlsStreamVerifier;
import kl.ssl.gmvpn.crypto.TlsVerifier;
import kl.ssl.gmvpn.crypto.impl.jcajce.JcaTlsCrypto;
import kl.ssl.gmvpn.crypto.impl.jcajce.SignatureOutputStream;

public class JcaTlsSM2Verifier
implements TlsVerifier {
    private final JcaTlsCrypto crypto;
    private final PublicKey publicKey;

    public JcaTlsSM2Verifier(JcaTlsCrypto crypto, ECPublicKey publicKey) {
        if (null == crypto) {
            throw new NullPointerException("crypto");
        }
        if (null == publicKey) {
            throw new NullPointerException("publicKey");
        }
        this.crypto = crypto;
        this.publicKey = publicKey;
    }

    @Override
    public TlsStreamVerifier getStreamVerifier(final DigitallySigned signature) throws IOException {
        try {
            final Signature verifier = this.crypto.getHelper().createSignature("SM3WITHSM2");
            verifier.initVerify(this.publicKey);
            return new TlsStreamVerifier(){

                @Override
                public OutputStream getOutputStream() {
                    return new SignatureOutputStream(verifier);
                }

                @Override
                public boolean isVerified() throws IOException {
                    try {
                        return verifier.verify(signature.getSignature());
                    }
                    catch (SignatureException e) {
                        throw new TlsFatalAlert(80, (Throwable)e);
                    }
                }
            };
        }
        catch (GeneralSecurityException e) {
            throw new TlsFatalAlert(80, (Throwable)e);
        }
    }

    @Override
    public boolean verifyRawSignature(DigitallySigned signature, byte[] hash) throws IOException {
        throw new UnsupportedOperationException();
    }
}

