/*
 * Decompiled with CFR 0.152.
 */
package com.koal.kms.sdk.ed.thrift.transport;

import com.koal.kms.sdk.ed.KmsClientConfig;
import com.koal.kms.sdk.ed.thrift.transport.TransportCreator;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import kl.ssl.gmvpn.crypto.impl.jcajce.JcaTlsCryptoProvider;
import kl.ssl.jsse.provider.KlGMJsseProvider;
import org.apache.thrift.transport.MyTSSLTransportFactory;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class TransportCreatorSslGm
implements TransportCreator {
    private final KmsClientConfig kmsClientConfig;

    public TransportCreatorSslGm(KmsClientConfig kmsClientConfig) {
        this.kmsClientConfig = kmsClientConfig;
    }

    @Override
    public TTransport createTransport(String host, int port, int timeout) throws TTransportException {
        if (Security.getProvider("KLGMJSSE") == null) {
            Security.removeProvider("BC");
            Security.insertProviderAt((Provider)new BouncyCastleProvider(), 1);
            JcaTlsCryptoProvider cryptoProvider = new JcaTlsCryptoProvider();
            cryptoProvider.setProvider((Provider)new BouncyCastleProvider());
            cryptoProvider.create(new SecureRandom());
            Security.addProvider(new KlGMJsseProvider(cryptoProvider));
        }
        MyTSSLTransportFactory.TSSLTransportParameters params = new MyTSSLTransportFactory.TSSLTransportParameters();
        params.setKeyStore(this.kmsClientConfig.getKeyStorePath(), this.kmsClientConfig.getKeyStorePassword());
        params.setTrustStore(this.kmsClientConfig.getTrustStorePath(), this.kmsClientConfig.getTrustStorePassword());
        return MyTSSLTransportFactory.getClientSocket(host, port, timeout, params);
    }
}

