/*
 * Decompiled with CFR 0.152.
 */
package kl.ssl.gmvpn.crypto.impl.jcajce;

import java.security.GeneralSecurityException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import kl.ssl.gmvpn.crypto.impl.TlsBlockCipherImpl;
import kl.ssl.gmvpn.crypto.impl.jcajce.Exceptions;
import org.bouncycastle.util.Arrays;

public class JceBlockCipherWithCBCImplicitIVImpl
implements TlsBlockCipherImpl {
    private static final int BUF_SIZE = 32768;
    private final Cipher cipher;
    private final String algorithm;
    private final boolean isEncrypting;
    private SecretKey key;
    private byte[] nextIV;

    public JceBlockCipherWithCBCImplicitIVImpl(Cipher cipher, String algorithm, boolean isEncrypting) throws GeneralSecurityException {
        this.cipher = cipher;
        this.algorithm = algorithm;
        this.isEncrypting = isEncrypting;
    }

    @Override
    public void setKey(byte[] key, int keyOff, int keyLen) {
        this.key = new SecretKeySpec(key, keyOff, keyLen, this.algorithm);
    }

    @Override
    public void init(byte[] iv, int ivOff, int ivLen) {
        if (this.nextIV != null) {
            throw new IllegalStateException("unexpected reinitialization of an implicit-IV cipher");
        }
        this.nextIV = Arrays.copyOfRange((byte[])iv, (int)ivOff, (int)(ivOff + ivLen));
    }

    @Override
    public int doFinal(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset) {
        try {
            this.cipher.init(this.isEncrypting ? 1 : 2, (Key)this.key, new IvParameterSpec(this.nextIV));
            this.nextIV = null;
            if (!this.isEncrypting) {
                this.nextIV = Arrays.copyOfRange((byte[])input, (int)(inputOffset + inputLength - this.cipher.getBlockSize()), (int)(inputOffset + inputLength));
            }
            int totLen = 0;
            while (inputLength > 32768) {
                totLen += this.cipher.update(input, inputOffset, 32768, output, outputOffset + totLen);
                inputOffset += 32768;
                inputLength -= 32768;
            }
            totLen += this.cipher.update(input, inputOffset, inputLength, output, outputOffset + totLen);
            totLen += this.cipher.doFinal(output, outputOffset + totLen);
            if (this.isEncrypting) {
                this.nextIV = Arrays.copyOfRange((byte[])output, (int)(outputOffset + totLen - this.cipher.getBlockSize()), (int)(outputOffset + totLen));
            }
            return totLen;
        }
        catch (GeneralSecurityException e) {
            throw Exceptions.illegalStateException(e.getMessage(), e);
        }
    }

    @Override
    public int getBlockSize() {
        return this.cipher.getBlockSize();
    }
}

