/*
 * Decompiled with CFR 0.152.
 */
package kl.ssl.jsse.provider;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.security.Principal;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import kl.ssl.gmvpn.SecurityParameters;
import kl.ssl.gmvpn.TlsFatalAlert;
import kl.ssl.gmvpn.TlsProtocol;
import kl.ssl.gmvpn.TlsSession;
import kl.ssl.jsse.BCApplicationProtocolSelector;
import kl.ssl.jsse.BCExtendedSSLSession;
import kl.ssl.jsse.BCSSLConnection;
import kl.ssl.jsse.BCSSLParameters;
import kl.ssl.jsse.provider.ContextData;
import kl.ssl.jsse.provider.ProvSSLConnection;
import kl.ssl.jsse.provider.ProvSSLContextSpi;
import kl.ssl.jsse.provider.ProvSSLParameters;
import kl.ssl.jsse.provider.ProvSSLSession;
import kl.ssl.jsse.provider.ProvSSLSessionHandshake;
import kl.ssl.jsse.provider.ProvSSLSocketBase;
import kl.ssl.jsse.provider.ProvTlsClient;
import kl.ssl.jsse.provider.ProvTlsClientProtocol;
import kl.ssl.jsse.provider.ProvTlsManager;
import kl.ssl.jsse.provider.ProvTlsPeer;
import kl.ssl.jsse.provider.ProvTlsServer;
import kl.ssl.jsse.provider.ProvTlsServerProtocol;
import kl.ssl.jsse.provider.SSLParametersUtil;

class ProvSSLSocketDirect
extends ProvSSLSocketBase
implements ProvTlsManager {
    private static final Logger LOG = Logger.getLogger(ProvSSLSocketDirect.class.getName());
    protected final AppDataInput appDataIn = new AppDataInput();
    protected final AppDataOutput appDataOut = new AppDataOutput();
    protected final ProvSSLContextSpi context;
    protected final ContextData contextData;
    protected final ProvSSLParameters sslParameters;
    protected String peerHost = null;
    protected String peerHostSNI = null;
    protected boolean enableSessionCreation = true;
    protected boolean useClientMode = true;
    protected TlsProtocol protocol = null;
    protected ProvTlsPeer protocolPeer = null;
    protected ProvSSLConnection connection = null;
    protected ProvSSLSessionHandshake handshakeSession = null;

    ProvSSLSocketDirect(ProvSSLContextSpi context, ContextData contextData, boolean enableSessionCreation, boolean useClientMode, ProvSSLParameters sslParameters) {
        this.context = context;
        this.contextData = contextData;
        this.enableSessionCreation = enableSessionCreation;
        this.useClientMode = useClientMode;
        this.sslParameters = sslParameters;
    }

    protected ProvSSLSocketDirect(ProvSSLContextSpi context, ContextData contextData) {
        this.context = context;
        this.contextData = contextData;
        this.sslParameters = context.getDefaultParameters(!this.useClientMode);
    }

    protected ProvSSLSocketDirect(ProvSSLContextSpi context, ContextData contextData, InetAddress address, int port, InetAddress clientAddress, int clientPort) throws IOException {
        this.context = context;
        this.contextData = contextData;
        this.sslParameters = context.getDefaultParameters(!this.useClientMode);
        this.implBind(clientAddress, clientPort);
        this.implConnect(address, port);
    }

    protected ProvSSLSocketDirect(ProvSSLContextSpi context, ContextData contextData, InetAddress address, int port) throws IOException {
        this.context = context;
        this.contextData = contextData;
        this.sslParameters = context.getDefaultParameters(!this.useClientMode);
        this.implConnect(address, port);
    }

    protected ProvSSLSocketDirect(ProvSSLContextSpi context, ContextData contextData, String host, int port, InetAddress clientAddress, int clientPort) throws IOException {
        this.context = context;
        this.contextData = contextData;
        this.sslParameters = context.getDefaultParameters(!this.useClientMode);
        this.peerHost = host;
        this.implBind(clientAddress, clientPort);
        this.implConnect(host, port);
    }

    protected ProvSSLSocketDirect(ProvSSLContextSpi context, ContextData contextData, String host, int port) throws IOException {
        this.context = context;
        this.contextData = contextData;
        this.sslParameters = context.getDefaultParameters(!this.useClientMode);
        this.peerHost = host;
        this.implConnect(host, port);
    }

    @Override
    public ProvSSLContextSpi getContext() {
        return this.context;
    }

    @Override
    public ContextData getContextData() {
        return this.contextData;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws IOException {
        try {
            this.contextData.getX509TrustManager().checkClientTrusted(chain, authType, this);
        }
        catch (CertificateException e) {
            throw new TlsFatalAlert(46, (Throwable)e);
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws IOException {
        try {
            this.contextData.getX509TrustManager().checkServerTrusted(chain, authType, this);
        }
        catch (CertificateException e) {
            throw new TlsFatalAlert(46, (Throwable)e);
        }
    }

    @Override
    public String chooseClientAlias(String[] keyType, Principal[] issuers) {
        return this.contextData.getX509KeyManager().chooseClientAlias(keyType, issuers, this);
    }

    @Override
    public String chooseServerAlias(String keyType, Principal[] issuers) {
        return this.contextData.getX509KeyManager().chooseServerAlias(keyType, issuers, this);
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.protocol == null) {
            this.closeSocket();
        } else {
            this.protocol.close();
        }
    }

    @Override
    public void connect(SocketAddress endpoint, int timeout) throws IOException {
        if (!(endpoint instanceof InetSocketAddress)) {
            throw new SocketException("Only InetSocketAddress is supported.");
        }
        super.connect(endpoint, timeout);
        this.notifyConnected();
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        catch (IOException e1) {
            try {
                super.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public synchronized String getApplicationProtocol() {
        return null == this.connection ? null : this.connection.getApplicationProtocol();
    }

    @Override
    public synchronized BCApplicationProtocolSelector<SSLSocket> getBCHandshakeApplicationProtocolSelector() {
        return this.sslParameters.getSocketAPSelector();
    }

    @Override
    public synchronized BCExtendedSSLSession getBCHandshakeSession() {
        return this.handshakeSession;
    }

    @Override
    public synchronized BCSSLConnection getConnection() {
        try {
            this.handshakeIfNecessary(false);
        }
        catch (IOException e) {
            LOG.log(Level.FINE, "Failed to establish connection", e);
        }
        return this.connection;
    }

    @Override
    public synchronized String[] getEnabledCipherSuites() {
        return this.sslParameters.getCipherSuites();
    }

    @Override
    public synchronized String[] getEnabledProtocols() {
        return this.sslParameters.getProtocols();
    }

    @Override
    public synchronized boolean getEnableSessionCreation() {
        return this.enableSessionCreation;
    }

    @Override
    public synchronized String getHandshakeApplicationProtocol() {
        return null == this.handshakeSession ? null : this.handshakeSession.getApplicationProtocol();
    }

    @Override
    public synchronized SSLSession getHandshakeSession() {
        return null == this.handshakeSession ? null : this.handshakeSession.getExportSSLSession();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.appDataIn;
    }

    @Override
    public synchronized boolean getNeedClientAuth() {
        return this.sslParameters.getNeedClientAuth();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.appDataOut;
    }

    @Override
    public synchronized BCSSLParameters getParameters() {
        return SSLParametersUtil.getParameters(this.sslParameters);
    }

    @Override
    public synchronized SSLSession getSession() {
        this.getConnection();
        ProvSSLSession sslSession = null == this.connection ? ProvSSLSession.NULL_SESSION : this.connection.getSession();
        return sslSession.getExportSSLSession();
    }

    @Override
    public synchronized SSLParameters getSSLParameters() {
        return SSLParametersUtil.getSSLParameters(this.sslParameters);
    }

    @Override
    public synchronized String[] getSupportedCipherSuites() {
        return this.context.getSupportedCipherSuites();
    }

    @Override
    public synchronized String[] getSupportedProtocols() {
        return this.context.getSupportedProtocols();
    }

    @Override
    public synchronized boolean getUseClientMode() {
        return this.useClientMode;
    }

    @Override
    public synchronized boolean getWantClientAuth() {
        return this.sslParameters.getWantClientAuth();
    }

    @Override
    public synchronized void setBCHandshakeApplicationProtocolSelector(BCApplicationProtocolSelector<SSLSocket> selector) {
        this.sslParameters.setSocketAPSelector(selector);
    }

    @Override
    public synchronized void setEnabledCipherSuites(String[] suites) {
        this.sslParameters.setCipherSuites(suites);
    }

    @Override
    public synchronized void setEnabledProtocols(String[] protocols) {
        this.sslParameters.setProtocols(protocols);
    }

    @Override
    public synchronized void setEnableSessionCreation(boolean flag) {
        this.enableSessionCreation = flag;
    }

    @Override
    public synchronized void setHost(String host) {
        this.peerHost = host;
        this.peerHostSNI = host;
    }

    @Override
    public synchronized void setNeedClientAuth(boolean need) {
        this.sslParameters.setNeedClientAuth(need);
    }

    @Override
    public synchronized void setParameters(BCSSLParameters parameters) {
        SSLParametersUtil.setParameters(this.sslParameters, parameters);
    }

    @Override
    public synchronized void setSSLParameters(SSLParameters sslParameters) {
        SSLParametersUtil.setSSLParameters(this.sslParameters, sslParameters);
    }

    @Override
    public synchronized void setUseClientMode(boolean useClientMode) {
        if (null != this.protocol) {
            throw new IllegalArgumentException("Mode cannot be changed after the initial handshake has begun");
        }
        if (this.useClientMode != useClientMode) {
            this.context.updateDefaultProtocols(this.sslParameters, !useClientMode);
            this.useClientMode = useClientMode;
        }
    }

    @Override
    public synchronized void setWantClientAuth(boolean want) {
        this.sslParameters.setWantClientAuth(want);
    }

    @Override
    public synchronized void startHandshake() throws IOException {
        this.startHandshake(true);
    }

    protected void startHandshake(boolean resumable) throws IOException {
        if (this.protocol == null) {
            InputStream input = super.getInputStream();
            OutputStream output = super.getOutputStream();
            if (this.useClientMode) {
                ProvTlsClientProtocol clientProtocol = new ProvTlsClientProtocol(input, output, this.socketCloser);
                clientProtocol.setResumableHandshake(resumable);
                this.protocol = clientProtocol;
                ProvTlsClient client = SecurityParameters.sessionTicket ? new ProvTlsClient(this, this.sslParameters.copy()){

                    @Override
                    protected boolean isResumable(ProvSSLSession availableSSLSession) {
                        return true;
                    }

                    @Override
                    public TlsSession getSessionToResume() {
                        return this.sslParameters.session;
                    }
                } : new ProvTlsClient(this, this.sslParameters.copy());
                this.protocolPeer = client;
                clientProtocol.connect(client);
                String clientId = this.sslParameters.getClientId();
                if (clientId != null) {
                    TlsSession session = client.getSession();
                    TlsSession tlsSession = SecurityParameters.TLS_SESSION_MAP.get(clientId);
                    if (tlsSession == null || tlsSession.exportSessionParameters().ticket_expire_time != session.exportSessionParameters().ticket_expire_time) {
                        SecurityParameters.TLS_SESSION_MAP.put(clientId, session);
                    }
                }
            } else {
                ProvTlsServerProtocol serverProtocol = new ProvTlsServerProtocol(input, output, this.socketCloser);
                serverProtocol.setResumableHandshake(resumable);
                this.protocol = serverProtocol;
                ProvTlsServer server = new ProvTlsServer(this, this.sslParameters.copy());
                this.protocolPeer = server;
                serverProtocol.accept(server);
            }
        } else if (this.protocol.isHandshaking()) {
            this.protocol.setResumableHandshake(resumable);
            this.protocol.resumeHandshake();
        } else {
            throw new UnsupportedOperationException("Renegotiation not supported");
        }
    }

    @Override
    public synchronized String getPeerHost() {
        return this.peerHost;
    }

    @Override
    public synchronized String getPeerHostSNI() {
        return this.peerHostSNI;
    }

    @Override
    public int getPeerPort() {
        return this.getPort();
    }

    @Override
    public synchronized void notifyHandshakeComplete(ProvSSLConnection connection) {
        if (null != this.handshakeSession && !this.handshakeSession.isValid()) {
            connection.getSession().invalidate();
        }
        this.handshakeSession = null;
        this.connection = connection;
    }

    @Override
    public synchronized void notifyHandshakeSession(ProvSSLSessionHandshake handshakeSession) {
        this.handshakeSession = handshakeSession;
    }

    @Override
    public synchronized String selectApplicationProtocol(List<String> protocols) {
        return this.sslParameters.getSocketAPSelector().select(this, protocols);
    }

    synchronized void handshakeIfNecessary(boolean resumable) throws IOException {
        if (this.protocol == null || this.protocol.isHandshaking()) {
            this.startHandshake(resumable);
        }
    }

    synchronized void notifyConnected() {
        if (null != this.peerHost && this.peerHost.length() > 0) {
            this.peerHostSNI = this.peerHost;
            return;
        }
        InetAddress peerAddress = this.getInetAddress();
        if (null == peerAddress) {
            return;
        }
        this.peerHost = this.useClientMode && provJdkTlsTrustNameService ? peerAddress.getHostName() : peerAddress.getHostAddress();
        this.peerHostSNI = null;
    }

    class AppDataOutput
    extends OutputStream {
        AppDataOutput() {
        }

        @Override
        public void close() throws IOException {
            ProvSSLSocketDirect.this.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void flush() throws IOException {
            ProvSSLSocketDirect provSSLSocketDirect = ProvSSLSocketDirect.this;
            synchronized (provSSLSocketDirect) {
                if (ProvSSLSocketDirect.this.protocol != null) {
                    ProvSSLSocketDirect.this.protocol.flush();
                }
            }
        }

        @Override
        public void write(int b) throws IOException {
            ProvSSLSocketDirect.this.handshakeIfNecessary(true);
            byte[] buf = new byte[]{(byte)b};
            ProvSSLSocketDirect.this.protocol.writeApplicationData(buf, 0, 1);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (len > 0) {
                ProvSSLSocketDirect.this.handshakeIfNecessary(true);
                ProvSSLSocketDirect.this.protocol.writeApplicationData(b, off, len);
            }
        }
    }

    class AppDataInput
    extends InputStream {
        AppDataInput() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int available() throws IOException {
            ProvSSLSocketDirect provSSLSocketDirect = ProvSSLSocketDirect.this;
            synchronized (provSSLSocketDirect) {
                return ProvSSLSocketDirect.this.protocol == null ? 0 : ProvSSLSocketDirect.this.protocol.applicationDataAvailable();
            }
        }

        @Override
        public void close() throws IOException {
            ProvSSLSocketDirect.this.close();
        }

        @Override
        public int read() throws IOException {
            ProvSSLSocketDirect.this.handshakeIfNecessary(true);
            byte[] buf = new byte[1];
            int ret = ProvSSLSocketDirect.this.protocol.readApplicationData(buf, 0, 1);
            return ret < 0 ? -1 : buf[0] & 0xFF;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (len < 1) {
                return 0;
            }
            ProvSSLSocketDirect.this.handshakeIfNecessary(true);
            return ProvSSLSocketDirect.this.protocol.readApplicationData(b, off, len);
        }
    }
}

