/*
 * Decompiled with CFR 0.152.
 */
package com.koal.kms.sdk.ed;

import com.ghca.kms.thrift.api.KmsApi;
import java.io.Closeable;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.thrift.TException;

public class KmsApiClientPool
implements Closeable {
    private final GenericObjectPool<KmsApi.Client> internalPool;

    public KmsApiClientPool(PooledObjectFactory<KmsApi.Client> factory, GenericObjectPoolConfig<KmsApi.Client> poolConfig) {
        this.internalPool = new GenericObjectPool(factory, poolConfig);
    }

    public KmsApi.Client acquire() throws TException {
        try {
            return (KmsApi.Client)this.internalPool.borrowObject();
        }
        catch (Exception exception) {
            throw new TException("could not acquire client from the pool", exception);
        }
    }

    public void release(KmsApi.Client client) throws TException {
        try {
            this.internalPool.returnObject((Object)client);
        }
        catch (Exception exception) {
            throw new TException("could not return client to the pool", exception);
        }
    }

    @Override
    public void close() {
        this.internalPool.close();
    }
}

