/*
 * Decompiled with CFR 0.152.
 */
package com.koal.kms.sdk.ed.thrift.pool;

import com.koal.kms.sdk.ed.thrift.failover.ConnectionValidator;
import com.koal.kms.sdk.ed.thrift.failover.FailoverChecker;
import com.koal.kms.sdk.ed.thrift.pool.ThriftServer;
import com.koal.kms.sdk.ed.thrift.transport.TransportCreator;
import com.koal.kms.sdk.ed.thrift.transport.TransportCreatorTcp;
import org.apache.commons.pool2.BaseKeyedPooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.thrift.transport.TTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThriftConnectionFactory
extends BaseKeyedPooledObjectFactory<ThriftServer, TTransport> {
    private static final Logger logger = LoggerFactory.getLogger(ThriftConnectionFactory.class);
    private FailoverChecker failoverChecker;
    private TransportCreator transportCreator;
    private static final int TIMEOUT = 60000;

    public ThriftConnectionFactory(FailoverChecker failoverChecker, TransportCreator transportCreator) {
        this.failoverChecker = failoverChecker;
        this.transportCreator = transportCreator;
    }

    public TTransport create(ThriftServer thriftServer) throws Exception {
        if (this.transportCreator == null) {
            this.transportCreator = new TransportCreatorTcp();
        }
        TTransport transport = this.transportCreator.createTransport(thriftServer.getHost(), thriftServer.getPort(), 60000);
        logger.info("Make new thrift connection: {}:{}", (Object)thriftServer.getHost(), (Object)thriftServer.getPort());
        return transport;
    }

    public void destroyObject(ThriftServer thriftServer, PooledObject<TTransport> pooledObject) throws Exception {
        TTransport transport = (TTransport)pooledObject.getObject();
        if (transport != null) {
            transport.close();
        }
    }

    public boolean validateObject(ThriftServer thriftServer, PooledObject<TTransport> pooledObject) {
        boolean isValidate;
        try {
            TTransport transport = (TTransport)pooledObject.getObject();
            if (this.failoverChecker == null) {
                isValidate = transport.isOpen();
            } else {
                ConnectionValidator validator = this.failoverChecker.getConnectionValidator();
                isValidate = transport.isOpen() && (validator == null || validator.isValid(transport));
            }
        }
        catch (Exception e) {
            isValidate = false;
        }
        if (this.failoverChecker != null && !isValidate) {
            this.failoverChecker.getFailoverStrategy().fail(thriftServer);
        }
        logger.info("Check validate: {}", (Object)isValidate);
        return isValidate;
    }

    public PooledObject<TTransport> wrap(TTransport transport) {
        return new DefaultPooledObject((Object)transport);
    }
}

