/*
 * Decompiled with CFR 0.152.
 */
package com.koal.kms.sdk.ed.thrift.pool;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public final class ThriftServer {
    private static final String SERVER_SEPARATOR = ":";
    private static final String LIST_SEPARATOR = ",";
    private final String host;
    private final int port;
    private final int weight;

    public ThriftServer(String server) {
        String[] split = server.split(SERVER_SEPARATOR);
        this.host = split[0];
        this.port = Integer.parseInt(split[1]);
        this.weight = split.length > 2 ? Integer.parseInt(split[2]) : 1;
    }

    public static List<ThriftServer> parse(String servers) {
        return ThriftServer.parse(servers.split(LIST_SEPARATOR));
    }

    public static List<ThriftServer> parse(String[] servers) {
        return Arrays.stream(servers).map(ThriftServer::new).collect(Collectors.toList());
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public int getWeight() {
        return this.weight;
    }

    public String toString() {
        return "ThriftServer{host='" + this.host + '\'' + ", port=" + this.port + ", weight=" + this.weight + '}';
    }
}

