/*
 * Decompiled with CFR 0.152.
 */
package cn.com.goldenwater.common.plugin.controller;

import cn.com.goldenwater.common.plugin.SpringPluginManager;
import cn.com.goldenwater.common.plugin.autoconfigure.PluginProperties;
import com.ruoyi.common.core.domain.R;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.pf4j.PluginState;
import org.pf4j.PluginWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/cn/com/goldenwater/common/plugin"})
public class PluginController {
    private PluginProperties pluginProperties;
    @Autowired
    private SpringPluginManager pluginManager;

    @Autowired
    public void setPluginProperties(PluginProperties pluginProperties) {
        this.pluginProperties = pluginProperties;
    }

    @Autowired
    public void setPluginManager(SpringPluginManager pluginManager) {
        this.pluginManager = pluginManager;
    }

    @PostMapping(value={"upload"})
    public R<Void> uploadPlugin(@RequestParam(value="file") MultipartFile file) throws IOException {
        String path = this.pluginProperties.getPath().toString();
        String fileName = file.getOriginalFilename();
        String suffixName = fileName.substring(fileName.lastIndexOf(".") + 1);
        if (StringUtils.isEmpty((CharSequence)suffixName)) {
            return R.fail((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u683c\uff0c\u8bf7\u4e0a\u4f20jar\u6216zip\u6587\u4ef6");
        }
        if (!"jar".equalsIgnoreCase(suffixName) && !"zip".equalsIgnoreCase(suffixName)) {
            return R.fail((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u683c\uff0c\u8bf7\u4e0a\u4f20jar\u6216zip\u6587\u4ef6");
        }
        try {
            Files.copy(file.getInputStream(), Paths.get(path, new String[0]).resolve(file.getOriginalFilename()), new CopyOption[0]);
        }
        catch (IOException e) {
            return R.fail((String)e.getMessage());
        }
        return R.ok();
    }

    @GetMapping(value={"reload"})
    public void reloadPlugins() {
        System.out.println("Reloading plugins...");
        this.pluginManager.unloadPlugins();
        this.pluginManager.loadPlugins();
        this.pluginManager.startPlugins();
        System.out.println("Reloading plugins success.");
    }

    @GetMapping(value={"load/{pluginId}"})
    public String loadPlugin(@RequestParam String pluginId) {
        PluginWrapper plugin = this.pluginManager.getPlugin(pluginId);
        if (plugin != null) {
            return this.pluginManager.loadPlugin(plugin.getPluginPath());
        }
        return "Plugin not found";
    }

    @GetMapping(value={"unload/{pluginId}"})
    public boolean unloadPlugin(@PathVariable String pluginId) {
        return this.pluginManager.unloadPlugin(pluginId);
    }

    @GetMapping(value={"start/{pluginId}"})
    public PluginState startPlugin(@PathVariable String pluginId) {
        return this.pluginManager.startPlugin(pluginId);
    }

    @GetMapping(value={"stop/{pluginId}"})
    public PluginState stopPlugin(@PathVariable String pluginId) {
        return this.pluginManager.stopPlugin(pluginId);
    }

    @GetMapping(value={"disable/{pluginId}"})
    public boolean disablePlugin(@PathVariable String pluginId) {
        return this.pluginManager.disablePlugin(pluginId);
    }

    @GetMapping(value={"enable/{pluginId}"})
    public boolean enablePlugin(@PathVariable String pluginId) {
        return this.pluginManager.enablePlugin(pluginId);
    }

    @GetMapping(value={"delete/{pluginId}"})
    public boolean deletePlugin(@PathVariable String pluginId) {
        return this.pluginManager.deletePlugin(pluginId);
    }

    @GetMapping(value={"/list"})
    public List<Map<String, Object>> listPlugin() {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        List plugins = this.pluginManager.getPlugins();
        for (PluginWrapper plugin : plugins) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("id", plugin.getPluginId());
            map.put("version", plugin.getDescriptor().getVersion());
            map.put("path", plugin.getPluginPath().toString());
            map.put("state", plugin.getPluginState());
            map.put("class", plugin.getDescriptor().getPluginClass());
            map.put("requires", plugin.getDescriptor().getRequires());
            map.put("provider", plugin.getDescriptor().getProvider());
            map.put("license", plugin.getDescriptor().getLicense());
            map.put("dependencies", plugin.getDescriptor().getDependencies());
            list.add(map);
        }
        String path = this.pluginProperties.getPath().toString();
        System.out.println("plugin work path = " + path);
        return list;
    }

    @GetMapping(value={"/info/{pluginId}"})
    public R<Map> info(@PathVariable String pluginId) {
        System.out.println("pluginId = " + pluginId);
        PluginWrapper plugin = this.pluginManager.getPlugin(pluginId);
        if (plugin == null) {
            return R.ok((String)"\u672a\u83b7\u53d6\u5230\u63d2\u4ef6\u4fe1\u606f\u3002");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", plugin.getPluginId());
        map.put("version", plugin.getDescriptor().getVersion());
        map.put("path", plugin.getPluginPath().toString());
        map.put("state", plugin.getPluginState());
        map.put("class", plugin.getDescriptor().getPluginClass());
        map.put("requires", plugin.getDescriptor().getRequires());
        map.put("provider", plugin.getDescriptor().getProvider());
        map.put("license", plugin.getDescriptor().getLicense());
        map.put("dependencies", plugin.getDescriptor().getDependencies());
        return R.ok(map);
    }
}

