/*
 * Decompiled with CFR 0.152.
 */
package kl.ssl.gmvpn;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import kl.ssl.gmvpn.DeferredHash;
import kl.ssl.gmvpn.ProtocolVersion;
import kl.ssl.gmvpn.RecordPreview;
import kl.ssl.gmvpn.SimpleOutputStream;
import kl.ssl.gmvpn.TlsContext;
import kl.ssl.gmvpn.TlsFatalAlert;
import kl.ssl.gmvpn.TlsHandshakeHash;
import kl.ssl.gmvpn.TlsProtocol;
import kl.ssl.gmvpn.TlsUtils;
import kl.ssl.gmvpn.crypto.TlsCipher;
import kl.ssl.gmvpn.crypto.TlsNullNullCipher;

class RecordStream {
    private static int DEFAULT_PLAINTEXT_LIMIT = 16384;
    private final Record inputRecord = new Record();
    private TlsProtocol handler;
    private InputStream input;
    private OutputStream output;
    private TlsContext context = null;
    private TlsCipher pendingCipher = null;
    private TlsCipher readCipher = null;
    private TlsCipher writeCipher = null;
    private SequenceNumber readSeqNo = new SequenceNumber();
    private SequenceNumber writeSeqNo = new SequenceNumber();
    private TlsHandshakeHash handshakeHash = null;
    private SimpleOutputStream handshakeHashUpdater = new SimpleOutputStream(){

        @Override
        public void write(byte[] buf, int off, int len) throws IOException {
            RecordStream.this.handshakeHash.update(buf, off, len);
        }
    };
    private ProtocolVersion writeVersion = null;
    private int plaintextLimit;
    private int ciphertextLimit;

    RecordStream(TlsProtocol handler, InputStream input, OutputStream output) {
        this.handler = handler;
        this.input = input;
        this.output = output;
    }

    void init(TlsContext context) {
        this.context = context;
        this.writeCipher = this.readCipher = new TlsNullNullCipher();
        this.handshakeHash = new DeferredHash(context);
        this.setPlaintextLimit(DEFAULT_PLAINTEXT_LIMIT);
    }

    int getPlaintextLimit() {
        return this.plaintextLimit;
    }

    void setPlaintextLimit(int plaintextLimit) {
        this.plaintextLimit = plaintextLimit;
        this.ciphertextLimit = this.plaintextLimit + 1024;
    }

    void setWriteVersion(ProtocolVersion writeVersion) {
        this.writeVersion = writeVersion;
    }

    void setPendingConnectionState(TlsCipher tlsCipher) {
        this.pendingCipher = tlsCipher;
    }

    void sentWriteCipherSpec() throws IOException {
        if (this.pendingCipher == null) {
            throw new TlsFatalAlert(40);
        }
        this.writeCipher = this.pendingCipher;
        this.writeSeqNo = new SequenceNumber();
    }

    void receivedReadCipherSpec() throws IOException {
        if (this.pendingCipher == null) {
            throw new TlsFatalAlert(40);
        }
        this.readCipher = this.pendingCipher;
        this.readSeqNo = new SequenceNumber();
    }

    void finaliseHandshake() throws IOException {
        if (this.readCipher != this.pendingCipher || this.writeCipher != this.pendingCipher) {
            throw new TlsFatalAlert(40);
        }
        this.pendingCipher = null;
        this.handshakeHash = new DeferredHash(this.context);
    }

    RecordPreview previewRecordHeader(byte[] recordHeader, boolean appDataReady) throws IOException {
        short type = TlsUtils.readUint8(recordHeader, 0);
        if (!appDataReady && type == 23) {
            throw new TlsFatalAlert(10);
        }
        RecordStream.checkType(type, (short)10);
        int length = TlsUtils.readUint16(recordHeader, 3);
        RecordStream.checkLength(length, this.ciphertextLimit, (short)22);
        int recordSize = 5 + length;
        int applicationDataLimit = 0;
        if (type == 23) {
            applicationDataLimit = Math.min(this.getPlaintextLimit(), this.readCipher.getPlaintextLimit(length));
        }
        return new RecordPreview(recordSize, applicationDataLimit);
    }

    RecordPreview previewOutputRecord(int applicationDataSize) {
        int applicationDataLimit = Math.max(0, Math.min(this.getPlaintextLimit(), applicationDataSize));
        int recordSize = this.writeCipher.getCiphertextLimit(applicationDataLimit) + 5;
        return new RecordPreview(recordSize, applicationDataLimit);
    }

    boolean readFullRecord(byte[] input, int inputOff, int inputLen) throws IOException {
        if (inputLen < 5) {
            return false;
        }
        int length = TlsUtils.readUint16(input, inputOff + 3);
        if (inputLen != 5 + length) {
            return false;
        }
        short type = TlsUtils.readUint8(input, inputOff + 0);
        RecordStream.checkType(type, (short)10);
        RecordStream.checkLength(length, this.ciphertextLimit, (short)22);
        byte[] plaintext = this.decodeAndVerify(type, input, inputOff + 5, length);
        this.handler.processRecord(type, plaintext, 0, plaintext.length);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean readRecord() throws IOException {
        byte[] plaintext;
        if (!this.inputRecord.readHeader(this.input)) {
            return false;
        }
        short type = TlsUtils.readUint8(this.inputRecord.buf, 0);
        RecordStream.checkType(type, (short)10);
        int length = TlsUtils.readUint16(this.inputRecord.buf, 3);
        RecordStream.checkLength(length, this.ciphertextLimit, (short)22);
        this.inputRecord.readFragment(this.input, length);
        try {
            plaintext = this.decodeAndVerify(type, this.inputRecord.buf, 5, length);
        }
        finally {
            this.inputRecord.reset();
        }
        this.handler.processRecord(type, plaintext, 0, plaintext.length);
        return true;
    }

    byte[] decodeAndVerify(short type, byte[] ciphertext, int off, int len) throws IOException {
        long seqNo = this.readSeqNo.nextValue((short)10);
        byte[] decoded = this.readCipher.decodeCiphertext(seqNo, type, ciphertext, off, len);
        RecordStream.checkLength(decoded.length, this.plaintextLimit, (short)22);
        if (decoded.length < 1 && type != 23) {
            throw new TlsFatalAlert(47);
        }
        return decoded;
    }

    void writeRecord(short type, byte[] plaintext, int plaintextOffset, int plaintextLength) throws IOException {
        if (this.writeVersion == null) {
            return;
        }
        RecordStream.checkType(type, (short)80);
        RecordStream.checkLength(plaintextLength, this.plaintextLimit, (short)80);
        if (plaintextLength < 1 && type != 23) {
            throw new TlsFatalAlert(80);
        }
        long seqNo = this.writeSeqNo.nextValue((short)80);
        byte[] ciphertext = this.writeCipher.encodePlaintext(seqNo, type, plaintext, plaintextOffset, plaintextLength);
        RecordStream.checkLength(ciphertext.length, this.ciphertextLimit, (short)80);
        byte[] record = new byte[5 + ciphertext.length];
        TlsUtils.writeUint8(type, record, 0);
        TlsUtils.writeVersion(this.writeVersion, record, 1);
        TlsUtils.writeUint16(ciphertext.length, record, 3);
        System.arraycopy(ciphertext, 0, record, 5, ciphertext.length);
        try {
            this.output.write(record);
        }
        catch (InterruptedIOException e) {
            throw new TlsFatalAlert(80, (Throwable)e);
        }
        this.output.flush();
    }

    void notifyHelloComplete() {
        this.handshakeHash = this.handshakeHash.notifyPRFDetermined();
    }

    TlsHandshakeHash getHandshakeHash() {
        return this.handshakeHash;
    }

    OutputStream getHandshakeHashUpdater() {
        return this.handshakeHashUpdater;
    }

    TlsHandshakeHash prepareToFinish() {
        TlsHandshakeHash result = this.handshakeHash;
        this.handshakeHash = this.handshakeHash.stopTracking();
        return result;
    }

    void close() throws IOException {
        IOException io;
        block5: {
            this.inputRecord.reset();
            io = null;
            try {
                this.input.close();
            }
            catch (IOException e) {
                io = e;
            }
            try {
                this.output.close();
            }
            catch (IOException e) {
                if (io != null) break block5;
                io = e;
            }
        }
        if (io != null) {
            throw io;
        }
    }

    void flush() throws IOException {
        this.output.flush();
    }

    private static void checkType(short type, short alertDescription) throws IOException {
        switch (type) {
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                break;
            }
            default: {
                throw new TlsFatalAlert(alertDescription);
            }
        }
    }

    private static void checkLength(int length, int limit, short alertDescription) throws IOException {
        if (length > limit) {
            throw new TlsFatalAlert(alertDescription);
        }
    }

    private static class SequenceNumber {
        private long value = 0L;
        private boolean exhausted = false;

        private SequenceNumber() {
        }

        synchronized long nextValue(short alertDescription) throws TlsFatalAlert {
            if (this.exhausted) {
                throw new TlsFatalAlert(alertDescription);
            }
            long result = this.value++;
            if (this.value == 0L) {
                this.exhausted = true;
            }
            return result;
        }
    }

    private static class Record {
        private final byte[] header = new byte[5];
        volatile byte[] buf = this.header;
        volatile int pos = 0;

        private Record() {
        }

        void fillTo(InputStream input, int length) throws IOException {
            while (this.pos < length) {
                try {
                    int numRead = input.read(this.buf, this.pos, length - this.pos);
                    if (numRead < 0) break;
                    this.pos += numRead;
                }
                catch (InterruptedIOException e) {
                    this.pos += e.bytesTransferred;
                    e.bytesTransferred = 0;
                    throw e;
                }
            }
        }

        void readFragment(InputStream input, int fragmentLength) throws IOException {
            int recordLength = 5 + fragmentLength;
            this.resize(recordLength);
            this.fillTo(input, recordLength);
            if (this.pos < recordLength) {
                throw new EOFException();
            }
        }

        boolean readHeader(InputStream input) throws IOException {
            this.fillTo(input, 5);
            if (this.pos == 0) {
                return false;
            }
            if (this.pos < 5) {
                throw new EOFException();
            }
            return true;
        }

        void reset() {
            this.buf = this.header;
            this.pos = 0;
        }

        private void resize(int length) {
            if (this.buf.length < length) {
                byte[] tmp = new byte[length];
                System.arraycopy(this.buf, 0, tmp, 0, this.pos);
                this.buf = tmp;
            }
        }
    }
}

