/*
 * Decompiled with CFR 0.152.
 */
package kl.ssl.gmvpn.crypto.impl;

import java.io.IOException;
import kl.ssl.gmvpn.crypto.TlsCertificate;
import kl.ssl.gmvpn.crypto.TlsCipher;
import kl.ssl.gmvpn.crypto.TlsCryptoParameters;
import kl.ssl.gmvpn.crypto.TlsHMAC;
import kl.ssl.gmvpn.crypto.TlsSecret;
import kl.ssl.gmvpn.crypto.impl.AbstractTlsCrypto;
import org.bouncycastle.util.Arrays;

public abstract class AbstractTlsSecret
implements TlsSecret {
    protected byte[] data;

    protected AbstractTlsSecret(byte[] data) {
        this.data = data;
    }

    protected abstract TlsSecret adoptLocalSecret(byte[] var1);

    protected void checkAlive() {
        if (this.data == null) {
            throw new IllegalStateException("Secret has already been extracted or destroyed");
        }
    }

    protected abstract AbstractTlsCrypto getCrypto();

    @Override
    public TlsCipher createCipher(TlsCryptoParameters cryptoParams, int encryptionAlgorithm, int macAlgorithm) throws IOException {
        return this.getCrypto().createCipher(cryptoParams, encryptionAlgorithm, macAlgorithm);
    }

    @Override
    public synchronized void destroy() {
        if (this.data != null) {
            Arrays.fill((byte[])this.data, (byte)0);
            this.data = null;
        }
    }

    @Override
    public synchronized byte[] encrypt(TlsCertificate certificate) throws IOException {
        this.checkAlive();
        return this.getCrypto().createEncryptor(certificate).encrypt(this.data, 0, this.data.length);
    }

    @Override
    public synchronized byte[] extract() {
        this.checkAlive();
        byte[] result = this.data;
        this.data = null;
        return result;
    }

    @Override
    public synchronized TlsSecret hkdfExpand(short hashAlgorithm, byte[] info, int length) {
        int copyLength;
        this.checkAlive();
        byte[] prk = this.data;
        AbstractTlsCrypto crypto = this.getCrypto();
        TlsHMAC hmac2 = crypto.createHMAC(hashAlgorithm);
        hmac2.setKey(prk, 0, prk.length);
        byte[] okm = new byte[length];
        int hashLen = hmac2.getMacLength();
        byte[] t = new byte[hashLen];
        byte counter = 0;
        for (int pos = 0; pos < length; pos += copyLength) {
            if (counter != 0) {
                hmac2.update(t, 0, t.length);
            }
            hmac2.update(info, 0, info.length);
            hmac2.update(new byte[]{counter = (byte)((byte)(counter + 1))}, 0, 1);
            hmac2.calculateMAC(t, 0);
            copyLength = Math.min(hashLen, length - pos);
            System.arraycopy(t, 0, okm, pos, copyLength);
        }
        return this.adoptLocalSecret(okm);
    }

    @Override
    public synchronized TlsSecret hkdfExtract(short hashAlgorithm, byte[] ikm) {
        this.checkAlive();
        byte[] salt = this.data;
        AbstractTlsCrypto crypto = this.getCrypto();
        TlsHMAC hmac2 = crypto.createHMAC(hashAlgorithm);
        hmac2.setKey(salt, 0, salt.length);
        hmac2.update(ikm, 0, ikm.length);
        byte[] prk = hmac2.calculateMAC();
        return this.adoptLocalSecret(prk);
    }

    synchronized byte[] copyData() {
        return Arrays.clone((byte[])this.data);
    }
}

