/*
 * Decompiled with CFR 0.152.
 */
package kl.ssl.gmvpn.crypto.impl.jcajce;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import kl.ssl.gmvpn.TlsFatalAlert;
import kl.ssl.gmvpn.crypto.TlsCertificate;
import kl.ssl.gmvpn.crypto.TlsCryptoException;
import kl.ssl.gmvpn.crypto.TlsVerifier;
import kl.ssl.gmvpn.crypto.impl.RSAUtil;
import kl.ssl.gmvpn.crypto.impl.jcajce.JcaTlsCrypto;
import kl.ssl.gmvpn.crypto.impl.jcajce.JcaTlsRSAVerifier;
import kl.ssl.gmvpn.crypto.impl.jcajce.JcaTlsSM2Verifier;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.TBSCertificate;
import org.bouncycastle.crypto.params.DSAPublicKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.jcajce.util.JcaJceHelper;

public class JcaTlsCertificate
implements TlsCertificate {
    protected final JcaTlsCrypto crypto;
    protected final X509Certificate certificate;
    protected ECPublicKey pubKeyEC = null;
    protected RSAPublicKey pubKeyRSA = null;

    public static JcaTlsCertificate convert(JcaTlsCrypto crypto, TlsCertificate certificate) throws IOException {
        if (certificate instanceof JcaTlsCertificate) {
            return (JcaTlsCertificate)certificate;
        }
        return new JcaTlsCertificate(crypto, certificate.getEncoded());
    }

    public static X509Certificate parseCertificate(JcaJceHelper helper, byte[] encoding) throws IOException {
        try {
            byte[] derEncoding = Certificate.getInstance((Object)encoding).getEncoded("DER");
            ByteArrayInputStream input = new ByteArrayInputStream(derEncoding);
            X509Certificate certificate = (X509Certificate)helper.createCertificateFactory("X.509").generateCertificate(input);
            if (input.available() != 0) {
                throw new IOException("Extra data detected in stream");
            }
            return certificate;
        }
        catch (GeneralSecurityException e) {
            throw new TlsCryptoException("unable to decode certificate", e);
        }
    }

    public JcaTlsCertificate(JcaTlsCrypto crypto, byte[] encoding) throws IOException {
        this(crypto, JcaTlsCertificate.parseCertificate(crypto.getHelper(), encoding));
    }

    public JcaTlsCertificate(JcaTlsCrypto crypto, X509Certificate certificate) {
        this.crypto = crypto;
        this.certificate = certificate;
    }

    @Override
    public TlsVerifier createVerifier(short signatureAlgorithm) throws IOException {
        this.validateKeyUsage(128);
        switch (signatureAlgorithm) {
            case 1: {
                this.validateRSA_PKCS1();
                return new JcaTlsRSAVerifier(this.crypto, this.getPubKeyRSA());
            }
            case 12: {
                return new JcaTlsSM2Verifier(this.crypto, this.getPubKeyEC());
            }
        }
        throw new TlsFatalAlert(46);
    }

    @Override
    public byte[] getEncoded() throws IOException {
        try {
            return this.certificate.getEncoded();
        }
        catch (CertificateEncodingException e) {
            throw new TlsCryptoException("unable to encode certificate: " + e.getMessage(), e);
        }
    }

    @Override
    public byte[] getExtension(ASN1ObjectIdentifier extensionOID) throws IOException {
        byte[] encoding = this.certificate.getExtensionValue(extensionOID.getId());
        return encoding == null ? null : ((ASN1OctetString)ASN1Primitive.fromByteArray((byte[])encoding)).getOctets();
    }

    @Override
    public BigInteger getSerialNumber() {
        return this.certificate.getSerialNumber();
    }

    @Override
    public String getSigAlgOID() {
        return this.certificate.getSigAlgOID();
    }

    ECPublicKey getPubKeyEC() throws IOException {
        try {
            return (ECPublicKey)this.getPublicKey();
        }
        catch (ClassCastException e) {
            throw new TlsFatalAlert(46, (Throwable)e);
        }
    }

    RSAPublicKey getPubKeyRSA() throws IOException {
        try {
            return (RSAPublicKey)this.getPublicKey();
        }
        catch (ClassCastException e) {
            throw new TlsFatalAlert(46, (Throwable)e);
        }
    }

    @Override
    public short getLegacySignatureAlgorithm() throws IOException {
        PublicKey publicKey = this.getPublicKey();
        try {
            this.validateKeyUsage(128);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TlsFatalAlert(43, (Throwable)e);
        }
        if (publicKey instanceof RSAPublicKey) {
            return 1;
        }
        if (publicKey instanceof DSAPublicKey) {
            return 2;
        }
        if (publicKey instanceof ECPublicKey) {
            return 12;
        }
        throw new TlsFatalAlert(43);
    }

    @Override
    public boolean supportsSignatureAlgorithm(short signatureAlgorithm) throws IOException {
        if (!this.supportsKeyUsage(128)) {
            return false;
        }
        PublicKey publicKey = this.getPublicKey();
        switch (signatureAlgorithm) {
            case 1: {
                return this.supportsRSA_PKCS1() && publicKey instanceof RSAKeyParameters;
            }
            case 2: {
                return publicKey instanceof DSAPublicKeyParameters;
            }
            case 3: {
                return publicKey instanceof ECPublicKeyParameters;
            }
            case 4: 
            case 5: 
            case 6: {
                return this.supportsRSA_PSS_RSAE() && publicKey instanceof RSAKeyParameters;
            }
            case 9: 
            case 10: 
            case 11: {
                return this.supportsRSA_PSS_PSS(signatureAlgorithm) && publicKey instanceof RSAKeyParameters;
            }
        }
        return false;
    }

    @Override
    public TlsCertificate useInRole(int connectionEnd, int keyExchangeAlgorithm) throws IOException {
        if (connectionEnd == 0) {
            switch (keyExchangeAlgorithm) {
                case 1: {
                    this.validateKeyUsage(32);
                    this.pubKeyRSA = this.getPubKeyRSA();
                    return this;
                }
                case 2: {
                    this.pubKeyEC = this.getPubKeyEC();
                    return this;
                }
            }
        }
        throw new TlsFatalAlert(46);
    }

    protected PublicKey getPublicKey() throws IOException {
        try {
            return this.certificate.getPublicKey();
        }
        catch (RuntimeException e) {
            throw new TlsFatalAlert(43, (Throwable)e);
        }
    }

    protected SubjectPublicKeyInfo getSubjectPublicKeyInfo() throws IOException {
        return SubjectPublicKeyInfo.getInstance((Object)this.getPublicKey().getEncoded());
    }

    public X509Certificate getX509Certificate() {
        return this.certificate;
    }

    protected boolean supportsKeyUsage(int keyUsageBits) {
        KeyUsage ku;
        Extensions exts;
        try {
            exts = TBSCertificate.getInstance((Object)this.certificate.getTBSCertificate()).getExtensions();
        }
        catch (CertificateEncodingException e) {
            return false;
        }
        if (exts != null && (ku = KeyUsage.fromExtensions((Extensions)exts)) != null) {
            int bits = ku.getBytes()[0] & 0xFF;
            return (bits & keyUsageBits) == keyUsageBits;
        }
        return true;
    }

    protected boolean supportsRSA_PKCS1() throws IOException {
        AlgorithmIdentifier pubKeyAlgID = this.getSubjectPublicKeyInfo().getAlgorithm();
        return RSAUtil.supportsPKCS1(pubKeyAlgID);
    }

    protected boolean supportsRSA_PSS_PSS(short signatureAlgorithm) throws IOException {
        AlgorithmIdentifier pubKeyAlgID = this.getSubjectPublicKeyInfo().getAlgorithm();
        return RSAUtil.supportsPSS_PSS(signatureAlgorithm, pubKeyAlgID);
    }

    protected boolean supportsRSA_PSS_RSAE() throws IOException {
        AlgorithmIdentifier pubKeyAlgID = this.getSubjectPublicKeyInfo().getAlgorithm();
        return RSAUtil.supportsPSS_RSAE(pubKeyAlgID);
    }

    protected void validateKeyUsage(int keyUsageBits) throws IOException {
    }

    protected void validateRSA_PKCS1() throws IOException {
        if (!this.supportsRSA_PKCS1()) {
            throw new TlsFatalAlert(46);
        }
    }
}

