/*
 * Decompiled with CFR 0.152.
 */
package com.koal.kms.sdk.ed;

import com.ghca.kms.thrift.api.ChallengeRequest;
import com.ghca.kms.thrift.api.KmsApi;
import com.ghca.kms.thrift.api.PingRequest;
import com.koal.kms.sdk.ed.KmsClientConfig;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import kl.ssl.gmvpn.crypto.impl.jcajce.JcaTlsCryptoProvider;
import kl.ssl.jsse.provider.KlGMJsseProvider;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.transport.MyTSSLTransportFactory;
import org.apache.thrift.transport.TSSLTransportFactory;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.apache.thrift.transport.layered.TFramedTransport;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class KmsApiClientFactory
extends BasePooledObjectFactory<KmsApi.Client> {
    private final KmsClientConfig kmsClientConfig = KmsClientConfig.getInstance();

    public KmsApi.Client create() throws TTransportException {
        TTransport socketTransport;
        String address = this.kmsClientConfig.getAddress();
        String host = address.split(":")[0];
        int port = Integer.parseInt(address.split(":")[1]);
        if (this.kmsClientConfig.useTLS()) {
            socketTransport = this.kmsClientConfig.useRsa() ? this.getSecureSocketRsa(host, port) : this.getSecureSocket(host, port);
        } else {
            socketTransport = this.getPlainSocket(host, port);
            socketTransport.open();
        }
        TBinaryProtocol protocol = new TBinaryProtocol(socketTransport, true, true);
        return new KmsApi.Client(protocol);
    }

    private TTransport getPlainSocket(String host, int port) throws TTransportException {
        return new TFramedTransport(new TSocket(host, port, 60000));
    }

    private TTransport getSecureSocket(String host, int port) throws TTransportException {
        if (Security.getProvider("KLGMJSSE") == null) {
            Security.removeProvider("BC");
            Security.insertProviderAt((Provider)new BouncyCastleProvider(), 1);
            JcaTlsCryptoProvider cryptoProvider = new JcaTlsCryptoProvider();
            cryptoProvider.setProvider((Provider)new BouncyCastleProvider());
            cryptoProvider.create(new SecureRandom());
            Security.addProvider(new KlGMJsseProvider(cryptoProvider));
        }
        MyTSSLTransportFactory.TSSLTransportParameters params = new MyTSSLTransportFactory.TSSLTransportParameters();
        params.setKeyStore(this.kmsClientConfig.getKeyStorePath(), this.kmsClientConfig.getKeyStorePassword());
        params.setTrustStore(this.kmsClientConfig.getTrustStorePath(), this.kmsClientConfig.getTrustStorePassword());
        return MyTSSLTransportFactory.getClientSocket(host, port, 60000, params);
    }

    private TTransport getSecureSocketRsa(String host, int port) throws TTransportException {
        TSSLTransportFactory.TSSLTransportParameters params = new TSSLTransportFactory.TSSLTransportParameters();
        params.setKeyStore(this.kmsClientConfig.getKeyStorePath(), this.kmsClientConfig.getKeyStorePassword());
        params.setTrustStore(this.kmsClientConfig.getTrustStorePath(), this.kmsClientConfig.getTrustStorePassword());
        return TSSLTransportFactory.getClientSocket(host, port, 60000, params);
    }

    public PooledObject<KmsApi.Client> wrap(KmsApi.Client client) {
        return new DefaultPooledObject((Object)client);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validateObject(PooledObject<KmsApi.Client> p) {
        KmsApi.Client client;
        KmsApi.Client client2 = client = (KmsApi.Client)p.getObject();
        synchronized (client2) {
            if (this.ping(client)) {
                return true;
            }
            return this.getChallenge(client);
        }
    }

    private boolean ping(KmsApi.Client client) {
        try {
            client.ping(new PingRequest("ping"));
            return true;
        }
        catch (TException e) {
            return false;
        }
    }

    private boolean getChallenge(KmsApi.Client client) {
        try {
            ChallengeRequest request = new ChallengeRequest();
            request.setAccessKey(this.kmsClientConfig.getAccessKey());
            client.getChallenge(request);
            return true;
        }
        catch (TException e) {
            return false;
        }
    }

    public void destroyObject(PooledObject<KmsApi.Client> p) throws Exception {
        TTransport tTransport;
        try {
            tTransport = ((KmsApi.Client)p.getObject()).getInputProtocol().getTransport();
            if (null != tTransport && tTransport.isOpen()) {
                tTransport.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            tTransport = ((KmsApi.Client)p.getObject()).getOutputProtocol().getTransport();
            if (null != tTransport && tTransport.isOpen()) {
                tTransport.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.destroyObject(p);
    }
}

