/*
 * Decompiled with CFR 0.152.
 */
package kl.ssl.gmvpn;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import kl.ssl.gmvpn.AbstractTlsPeer;
import kl.ssl.gmvpn.Certificate;
import kl.ssl.gmvpn.CertificateRequest;
import kl.ssl.gmvpn.CertificateStatus;
import kl.ssl.gmvpn.CertificateStatusRequest;
import kl.ssl.gmvpn.MaxFragmentLength;
import kl.ssl.gmvpn.NamedGroup;
import kl.ssl.gmvpn.NewSessionTicket;
import kl.ssl.gmvpn.ProtocolName;
import kl.ssl.gmvpn.ProtocolVersion;
import kl.ssl.gmvpn.TlsECCUtils;
import kl.ssl.gmvpn.TlsExtensionsUtils;
import kl.ssl.gmvpn.TlsFatalAlert;
import kl.ssl.gmvpn.TlsServer;
import kl.ssl.gmvpn.TlsServerContext;
import kl.ssl.gmvpn.TlsSession;
import kl.ssl.gmvpn.TlsUtils;
import kl.ssl.gmvpn.crypto.TlsCrypto;
import kl.ssl.gmvpn.crypto.TlsECConfig;

public abstract class AbstractTlsServer
extends AbstractTlsPeer
implements TlsServer {
    protected TlsServerContext context;
    protected int[] cipherSuites;
    protected int[] offeredCipherSuites;
    protected Hashtable clientExtensions;
    protected boolean encryptThenMACOffered;
    protected short maxFragmentLengthOffered;
    protected boolean truncatedHMacOffered;
    protected boolean clientSentECPointFormats;
    protected CertificateStatusRequest certificateStatusRequest;
    protected ProtocolVersion serverVersion;
    protected int selectedCipherSuite;
    protected Vector clientProtocolNames;
    protected ProtocolName selectedProtocolName;
    protected Hashtable serverExtensions;

    public AbstractTlsServer(TlsCrypto crypto) {
        super(crypto);
    }

    protected boolean allowCertificateStatus() {
        return true;
    }

    protected boolean allowEncryptThenMAC() {
        return true;
    }

    protected boolean allowTruncatedHMac() {
        return false;
    }

    protected Hashtable checkServerExtensions() {
        this.serverExtensions = TlsExtensionsUtils.ensureExtensionsInitialised(this.serverExtensions);
        return this.serverExtensions;
    }

    protected int[] getCipherSuites() {
        return this.cipherSuites;
    }

    protected int getMaximumNegotiableCurveBits() {
        int[] clientSupportedGroups = this.context.getSecurityParametersHandshake().getClientSupportedGroups();
        if (clientSupportedGroups == null) {
            return NamedGroup.getMaximumCurveBits();
        }
        int maxBits = 0;
        for (int i = 0; i < clientSupportedGroups.length; ++i) {
            maxBits = Math.max(maxBits, NamedGroup.getCurveBits(clientSupportedGroups[i]));
        }
        return maxBits;
    }

    protected int getMaximumNegotiableFiniteFieldBits() {
        int[] clientSupportedGroups = this.context.getSecurityParametersHandshake().getClientSupportedGroups();
        if (clientSupportedGroups == null) {
            return NamedGroup.getMaximumFiniteFieldBits();
        }
        int maxBits = 0;
        for (int i = 0; i < clientSupportedGroups.length; ++i) {
            maxBits = Math.max(maxBits, NamedGroup.getFiniteFieldBits(clientSupportedGroups[i]));
        }
        return maxBits;
    }

    protected Vector getProtocolNames() {
        return null;
    }

    protected abstract int[] getSupportedCipherSuites();

    protected boolean isSelectableCipherSuite(int cipherSuite, int availCurveBits, int availFiniteFieldBits, Vector sigAlgs) {
        return TlsUtils.isValidCipherSuiteForVersion(cipherSuite, this.context.getServerVersion()) && availCurveBits >= TlsECCUtils.getMinimumCurveBits(cipherSuite) && TlsUtils.isValidCipherSuiteForSignatureAlgorithms(cipherSuite, sigAlgs);
    }

    protected boolean preferLocalCipherSuites() {
        return false;
    }

    protected boolean selectCipherSuite(int cipherSuite) throws IOException {
        this.selectedCipherSuite = cipherSuite;
        return true;
    }

    protected int selectECDH(int minimumCurveBits) {
        int[] clientSupportedGroups = this.context.getSecurityParametersHandshake().getClientSupportedGroups();
        if (clientSupportedGroups == null) {
            return this.selectECDHDefault(minimumCurveBits);
        }
        for (int i = 0; i < clientSupportedGroups.length; ++i) {
            int namedGroup = clientSupportedGroups[i];
            if (NamedGroup.getCurveBits(namedGroup) < minimumCurveBits) continue;
            return namedGroup;
        }
        return -1;
    }

    protected int selectECDHDefault(int minimumCurveBits) {
        return minimumCurveBits <= 256 ? 23 : (minimumCurveBits <= 384 ? 24 : (minimumCurveBits <= 521 ? 25 : -1));
    }

    protected ProtocolName selectProtocolName() throws IOException {
        Vector serverProtocolNames = this.getProtocolNames();
        if (null == serverProtocolNames || serverProtocolNames.isEmpty()) {
            return null;
        }
        ProtocolName result = this.selectProtocolName(this.clientProtocolNames, serverProtocolNames);
        if (null == result) {
            throw new TlsFatalAlert(120);
        }
        return result;
    }

    protected ProtocolName selectProtocolName(Vector clientProtocolNames, Vector serverProtocolNames) {
        for (int i = 0; i < serverProtocolNames.size(); ++i) {
            ProtocolName serverProtocolName = (ProtocolName)serverProtocolNames.elementAt(i);
            if (!clientProtocolNames.contains(serverProtocolName)) continue;
            return serverProtocolName;
        }
        return null;
    }

    protected boolean shouldSelectProtocolNameEarly() {
        return true;
    }

    @Override
    public void init(TlsServerContext context) {
        this.context = context;
        this.cipherSuites = this.getSupportedCipherSuites();
    }

    @Override
    public void notifyHandshakeBeginning() throws IOException {
        super.notifyHandshakeBeginning();
        this.offeredCipherSuites = null;
        this.clientExtensions = null;
        this.encryptThenMACOffered = false;
        this.maxFragmentLengthOffered = 0;
        this.truncatedHMacOffered = false;
        this.clientSentECPointFormats = false;
        this.certificateStatusRequest = null;
        this.selectedCipherSuite = -1;
        this.selectedProtocolName = null;
        this.serverExtensions = null;
    }

    @Override
    public TlsSession getSessionToResume(byte[] sessionID) {
        return null;
    }

    @Override
    public void notifyClientVersion(ProtocolVersion clientVersion) throws IOException {
    }

    @Override
    public void notifyFallback(boolean isFallback) throws IOException {
        if (isFallback) {
            ProtocolVersion[] serverVersions = this.getSupportedVersions();
            ProtocolVersion clientVersion = this.context.getClientVersion();
            if (!clientVersion.isTLS()) {
                throw new TlsFatalAlert(80);
            }
            ProtocolVersion latestServerVersion = ProtocolVersion.getLatestTLS(serverVersions);
            if (null != latestServerVersion && latestServerVersion.isLaterVersionOf(clientVersion)) {
                throw new TlsFatalAlert(86);
            }
        }
    }

    @Override
    public void notifyOfferedCipherSuites(int[] offeredCipherSuites) throws IOException {
        this.offeredCipherSuites = offeredCipherSuites;
    }

    @Override
    public void processClientExtensions(Hashtable clientExtensions) throws IOException {
        this.clientExtensions = clientExtensions;
        if (null != clientExtensions) {
            this.clientProtocolNames = TlsExtensionsUtils.getALPNExtensionClient(clientExtensions);
            if (this.shouldSelectProtocolNameEarly() && null != this.clientProtocolNames && !this.clientProtocolNames.isEmpty()) {
                this.selectedProtocolName = this.selectProtocolName();
            }
            this.encryptThenMACOffered = TlsExtensionsUtils.hasEncryptThenMACExtension(clientExtensions);
            this.maxFragmentLengthOffered = TlsExtensionsUtils.getMaxFragmentLengthExtension(clientExtensions);
            if (this.maxFragmentLengthOffered >= 0 && !MaxFragmentLength.isValid(this.maxFragmentLengthOffered)) {
                throw new TlsFatalAlert(47);
            }
            this.truncatedHMacOffered = TlsExtensionsUtils.hasTruncatedHMacExtension(clientExtensions);
            this.clientSentECPointFormats = null != TlsExtensionsUtils.getSupportedPointFormatsExtension(clientExtensions);
            this.certificateStatusRequest = TlsExtensionsUtils.getStatusRequestExtension(clientExtensions);
        }
    }

    @Override
    public ProtocolVersion getServerVersion() throws IOException {
        ProtocolVersion[] serverVersions = this.getSupportedVersions();
        ProtocolVersion[] clientVersions = this.context.getClientSupportedVersions();
        for (int i = 0; i < clientVersions.length; ++i) {
            ProtocolVersion clientVersion = clientVersions[i];
            if (!ProtocolVersion.contains(serverVersions, clientVersion)) continue;
            return clientVersion;
        }
        throw new TlsFatalAlert(70);
    }

    @Override
    public int getSelectedCipherSuite() throws IOException {
        Vector sigAlgs = TlsUtils.getUsableSignatureAlgorithms(this.context.getSecurityParametersHandshake().getClientSigAlgs());
        int availCurveBits = this.getMaximumNegotiableCurveBits();
        int availFiniteFieldBits = this.getMaximumNegotiableFiniteFieldBits();
        int[] cipherSuites = TlsUtils.getCommonCipherSuites(this.offeredCipherSuites, this.getCipherSuites(), this.preferLocalCipherSuites());
        for (int i = 0; i < cipherSuites.length; ++i) {
            int cipherSuite = cipherSuites[i];
            if (!this.isSelectableCipherSuite(cipherSuite, availCurveBits, availFiniteFieldBits, sigAlgs) || !this.selectCipherSuite(cipherSuite)) continue;
            return cipherSuite;
        }
        throw new TlsFatalAlert(40);
    }

    @Override
    public Hashtable getServerExtensions() throws IOException {
        if (!this.shouldSelectProtocolNameEarly() && null != this.clientProtocolNames && !this.clientProtocolNames.isEmpty()) {
            this.selectedProtocolName = this.selectProtocolName();
        }
        if (null != this.selectedProtocolName) {
            TlsExtensionsUtils.addALPNExtensionServer(this.checkServerExtensions(), this.selectedProtocolName);
        }
        if (this.encryptThenMACOffered && this.allowEncryptThenMAC() && TlsUtils.isBlockCipherSuite(this.selectedCipherSuite)) {
            TlsExtensionsUtils.addEncryptThenMACExtension(this.checkServerExtensions());
        }
        if (this.maxFragmentLengthOffered >= 0 && MaxFragmentLength.isValid(this.maxFragmentLengthOffered)) {
            TlsExtensionsUtils.addMaxFragmentLengthExtension(this.checkServerExtensions(), this.maxFragmentLengthOffered);
        }
        if (this.truncatedHMacOffered && this.allowTruncatedHMac()) {
            TlsExtensionsUtils.addTruncatedHMacExtension(this.checkServerExtensions());
        }
        if (this.clientSentECPointFormats && TlsECCUtils.isECCCipherSuite(this.selectedCipherSuite)) {
            TlsExtensionsUtils.addSupportedPointFormatsExtension(this.checkServerExtensions(), new short[]{0});
        }
        if (null != this.certificateStatusRequest && this.allowCertificateStatus()) {
            this.checkServerExtensions().put(TlsExtensionsUtils.EXT_status_request, TlsExtensionsUtils.createEmptyExtensionData());
        }
        return this.serverExtensions;
    }

    @Override
    public Vector getServerSupplementalData() throws IOException {
        return null;
    }

    @Override
    public CertificateStatus getCertificateStatus() throws IOException {
        return null;
    }

    @Override
    public CertificateRequest getCertificateRequest() throws IOException {
        return null;
    }

    @Override
    public TlsECConfig getECDHConfig() throws IOException {
        int minimumCurveBits = TlsECCUtils.getMinimumCurveBits(this.selectedCipherSuite);
        int namedGroup = this.selectECDH(minimumCurveBits);
        return TlsECCUtils.createNamedECConfig(this.context, namedGroup);
    }

    @Override
    public void processClientSupplementalData(Vector clientSupplementalData) throws IOException {
        if (clientSupplementalData != null) {
            throw new TlsFatalAlert(10);
        }
    }

    @Override
    public void notifyClientCertificate(Certificate clientCertificate) throws IOException {
        throw new TlsFatalAlert(80);
    }

    @Override
    public NewSessionTicket getNewSessionTicket() throws IOException {
        return new NewSessionTicket(0L, TlsUtils.EMPTY_BYTES);
    }
}

