/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import org.geotools.factory.Hints;
import org.geotools.util.Converter;
import org.geotools.util.ConverterFactory;

public class EnumerationConverterFactory
implements ConverterFactory {
    public Converter createConverter(Class<?> source, Class<?> target, Hints hints) {
        if (String.class.equals(source) && target.isEnum() || source.isEnum() && String.class.equals(source)) {
            return new EnumConverter();
        }
        return null;
    }

    private static class EnumConverter
    implements Converter {
        private EnumConverter() {
        }

        public <T> T convert(Object source, Class<T> target) throws Exception {
            if (source instanceof String && target.isEnum()) {
                return Enum.valueOf(target, (String)source);
            }
            if (source.getClass().isEnum() && String.class.equals(target)) {
                return (T)((Enum)source).name();
            }
            return null;
        }
    }
}

