/*
 * Decompiled with CFR 0.152.
 */
package com.koal.kms.sdk.ed.thrift.transport;

import com.koal.kms.sdk.ed.KmsClientConfig;
import com.koal.kms.sdk.ed.KmsClientConfigInitializer;
import com.koal.kms.sdk.ed.thrift.transport.TransportCreator;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.client.HttpClient;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustAllStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultClientConnectionReuseStrategy;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.ssl.PrivateKeyStrategy;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.apache.thrift.transport.THttpClient;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;

public class TransportCreatorHttp
implements TransportCreator {
    private static final String PROTOCOL_HTTP = "http";
    private static final String PROTOCOL_HTTPS = "https";
    private final KmsClientConfig kmsClientConfig;

    public TransportCreatorHttp(KmsClientConfig kmsClientConfig) {
        this.kmsClientConfig = kmsClientConfig;
    }

    @Override
    public TTransport createTransport(String host, int port, int timeout) throws TTransportException {
        THttpClient tHttpClient;
        String contextPath = this.kmsClientConfig.getContextPath();
        try {
            tHttpClient = this.kmsClientConfig.useTLS() ? new THttpClient("https://" + host + ":" + port + contextPath, (HttpClient)this.buildHttpClient()) : new THttpClient("http://" + host + ":" + port, (HttpClient)this.buildHttpClient());
        }
        catch (Exception e) {
            throw new TTransportException(e.getMessage(), (Throwable)e);
        }
        tHttpClient.setCustomHeader("kid", this.kmsClientConfig.getKcspKid());
        tHttpClient.open();
        return tHttpClient;
    }

    private CloseableHttpClient buildHttpClient() throws UnrecoverableKeyException, CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException, KeyManagementException {
        return HttpClients.custom().setConnectionManager((HttpClientConnectionManager)this.poolingHttpClientConnectionManager()).setConnectionReuseStrategy((ConnectionReuseStrategy)new DefaultClientConnectionReuseStrategy()).setConnectionManagerShared(true).build();
    }

    private PoolingHttpClientConnectionManager poolingHttpClientConnectionManager() throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException, UnrecoverableKeyException, KeyManagementException {
        byte[] trustStoreByte;
        String trustStorePath = this.kmsClientConfig.getTrustStorePath();
        String keyStorePath = this.kmsClientConfig.getKeyStorePath();
        char[] trustStorePassword = this.toNullableCharArray(this.kmsClientConfig.getTrustStorePassword());
        SSLContextBuilder sslContextBuilder = SSLContexts.custom();
        sslContextBuilder = KmsClientConfigInitializer.isInitialized() ? (null != (trustStoreByte = this.kmsClientConfig.getInitializer().getTrustStore()) && trustStoreByte.length != 0 ? this.loadTrustMaterial(new ByteArrayInputStream(trustStoreByte), sslContextBuilder, trustStorePassword, null) : sslContextBuilder.loadTrustMaterial(null, (TrustStrategy)new TrustAllStrategy())) : (null != trustStorePath && !"".equals(trustStorePath) ? sslContextBuilder.loadTrustMaterial(new File(trustStorePath), trustStorePassword) : sslContextBuilder.loadTrustMaterial(null, (TrustStrategy)new TrustAllStrategy()));
        char[] keyStorePassword = this.toNullableCharArray(this.kmsClientConfig.getKeyStorePassword());
        char[] keyPassword = this.toNullableCharArray(this.kmsClientConfig.getKeyPassword());
        if (KmsClientConfigInitializer.isInitialized()) {
            byte[] keyStoreByte = this.kmsClientConfig.getInitializer().getKeyStore();
            if (null != keyStoreByte && keyStoreByte.length != 0) {
                sslContextBuilder = this.loadKeyMaterial(new ByteArrayInputStream(keyStoreByte), sslContextBuilder, keyStorePassword, keyPassword, null);
            }
        } else if (null != keyStorePath && !"".equals(keyStorePath)) {
            sslContextBuilder = sslContextBuilder.loadKeyMaterial(new File(keyStorePath), keyStorePassword, keyPassword);
        }
        SSLContext sslContext = sslContextBuilder.build();
        SSLConnectionSocketFactory sslConnectionSocketFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        Registry build = RegistryBuilder.create().register(PROTOCOL_HTTP, (Object)PlainConnectionSocketFactory.getSocketFactory()).register(PROTOCOL_HTTPS, (Object)sslConnectionSocketFactory).build();
        PoolingHttpClientConnectionManager poolingHttpClientConnectionManager = new PoolingHttpClientConnectionManager(build);
        poolingHttpClientConnectionManager.setMaxTotal(this.kmsClientConfig.getPooling().getMaxTotal());
        poolingHttpClientConnectionManager.setValidateAfterInactivity(this.kmsClientConfig.getPooling().getValidatePeriod());
        return poolingHttpClientConnectionManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SSLContextBuilder loadKeyMaterial(ByteArrayInputStream byteArrayInputStream, SSLContextBuilder sslContextBuilder, char[] storePassword, char[] keyPassword, PrivateKeyStrategy aliasStrategy) throws NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException, CertificateException, IOException {
        KeyStore identityStore = KeyStore.getInstance(KeyStore.getDefaultType());
        try {
            identityStore.load(byteArrayInputStream, storePassword);
        }
        finally {
            byteArrayInputStream.close();
        }
        return sslContextBuilder.loadKeyMaterial(identityStore, keyPassword, aliasStrategy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SSLContextBuilder loadTrustMaterial(ByteArrayInputStream byteArrayInputStream, SSLContextBuilder sslContextBuilder, char[] storePassword, TrustStrategy trustStrategy) throws NoSuchAlgorithmException, KeyStoreException, CertificateException, IOException {
        KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
        try {
            trustStore.load(byteArrayInputStream, storePassword);
        }
        finally {
            byteArrayInputStream.close();
        }
        return sslContextBuilder.loadTrustMaterial(trustStore, trustStrategy);
    }

    private char[] toNullableCharArray(String string) {
        if (null != string) {
            return string.toCharArray();
        }
        return null;
    }
}

