/*
 * Decompiled with CFR 0.152.
 */
package wContour;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Interpolate {
    public static List<double[]> createGridXY_Delt(double Xlb, double Ylb, double Xrt, double Yrt, double XDelt, double YDelt) {
        int i;
        int Xnum = (int)((Xrt - Xlb) / XDelt + 1.0);
        int Ynum = (int)((Yrt - Ylb) / YDelt + 1.0);
        double[] X = new double[Xnum];
        double[] Y = new double[Ynum];
        for (i = 0; i < Xnum; ++i) {
            X[i] = Xlb + (double)i * XDelt;
        }
        for (i = 0; i < Ynum; ++i) {
            Y[i] = Ylb + (double)i * YDelt;
        }
        ArrayList<double[]> values = new ArrayList<double[]>();
        values.add(X);
        values.add(Y);
        return values;
    }

    public static void createGridXY_Num(double Xlb, double Ylb, double Xrt, double Yrt, double[] X, double[] Y) {
        int i;
        int Xnum = X.length;
        int Ynum = Y.length;
        double XDelt = (Xrt - Xlb) / (double)Xnum;
        double YDelt = (Yrt - Ylb) / (double)Ynum;
        for (i = 0; i < Xnum; ++i) {
            X[i] = Xlb + (double)i * XDelt;
        }
        for (i = 0; i < Ynum; ++i) {
            Y[i] = Ylb + (double)i * YDelt;
        }
    }

    public static double[][] interpolation_IDW_Neighbor(double[][] SCoords, double[] X, double[] Y, int NumberOfNearestNeighbors) {
        int j;
        int i;
        int colNum = X.length;
        int rowNum = Y.length;
        int pNum = SCoords.length;
        double[][] GCoords = new double[rowNum][colNum];
        int points = NumberOfNearestNeighbors;
        Object[][] NW = new Object[1][points];
        for (i = 0; i < rowNum; ++i) {
            for (j = 0; j < colNum; ++j) {
                double w;
                int p;
                GCoords[i][j] = -999.0;
                double SV = 0.0;
                double SW = 0.0;
                for (p = 0; p < points; ++p) {
                    if (Math.pow(X[j] - SCoords[p][0], 2.0) + Math.pow(Y[i] - SCoords[p][1], 2.0) == 0.0) {
                        GCoords[i][j] = SCoords[p][2];
                        break;
                    }
                    w = 1.0 / (Math.pow(X[j] - SCoords[p][0], 2.0) + Math.pow(Y[i] - SCoords[p][1], 2.0));
                    NW[0][p] = w;
                    NW[1][p] = p;
                }
                if (GCoords[i][j] != -999.0) continue;
                for (p = points; p < pNum; ++p) {
                    if (Math.pow(X[j] - SCoords[p][0], 2.0) + Math.pow(Y[i] - SCoords[p][1], 2.0) == 0.0) {
                        GCoords[i][j] = SCoords[p][2];
                        break;
                    }
                    w = 1.0 / (Math.pow(X[j] - SCoords[p][0], 2.0) + Math.pow(Y[i] - SCoords[p][1], 2.0));
                    double aMin = Double.parseDouble(NW[0][0].toString());
                    int aP = 0;
                    for (int l = 1; l < points; ++l) {
                        if (!(Double.parseDouble(NW[0][l].toString()) < aMin)) continue;
                        aMin = Double.parseDouble(NW[0][l].toString());
                        aP = l;
                    }
                    if (!(w > aMin)) continue;
                    NW[0][aP] = w;
                    NW[1][aP] = p;
                }
                if (GCoords[i][j] != -999.0) continue;
                for (p = 0; p < points; ++p) {
                    SV += Double.parseDouble(NW[0][p].toString()) * SCoords[Integer.parseInt(NW[1][p].toString())][2];
                    SW += Double.parseDouble(NW[0][p].toString());
                }
                GCoords[i][j] = SV / SW;
            }
        }
        double s = 0.5;
        for (i = 1; i < rowNum - 1; ++i) {
            for (j = 1; j < colNum - 1; ++j) {
                GCoords[i][j] = GCoords[i][j] + s / 4.0 * (GCoords[i + 1][j] + GCoords[i - 1][j] + GCoords[i][j + 1] + GCoords[i][j - 1] - 4.0 * GCoords[i][j]);
            }
        }
        return GCoords;
    }

    public static double[][] interpolation_IDW_Neighbor(double[][] SCoords, double[] X, double[] Y, int NumberOfNearestNeighbors, double unDefData) {
        int j;
        int i;
        int colNum = X.length;
        int rowNum = Y.length;
        int pNum = SCoords.length;
        double[][] GCoords = new double[rowNum][colNum];
        int points = NumberOfNearestNeighbors;
        double[] AllWeights = new double[pNum];
        double[][] NW = new double[2][points];
        for (i = 0; i < rowNum; ++i) {
            for (j = 0; j < colNum; ++j) {
                double w;
                int p;
                GCoords[i][j] = unDefData;
                double SV = 0.0;
                double SW = 0.0;
                int NWIdx = 0;
                for (p = 0; p < pNum; ++p) {
                    if (SCoords[p][2] == unDefData) {
                        AllWeights[p] = -1.0;
                        continue;
                    }
                    if (Math.pow(X[j] - SCoords[p][0], 2.0) + Math.pow(Y[i] - SCoords[p][1], 2.0) == 0.0) {
                        GCoords[i][j] = SCoords[p][2];
                        break;
                    }
                    AllWeights[p] = w = 1.0 / (Math.pow(X[j] - SCoords[p][0], 2.0) + Math.pow(Y[i] - SCoords[p][1], 2.0));
                    if (NWIdx < points) {
                        NW[0][NWIdx] = w;
                        NW[1][NWIdx] = p;
                    }
                    ++NWIdx;
                }
                if (GCoords[i][j] != unDefData) continue;
                for (p = 0; p < pNum; ++p) {
                    w = AllWeights[p];
                    if (w == -1.0) continue;
                    double aMin = NW[0][0];
                    int aP = 0;
                    for (int l = 1; l < points; ++l) {
                        if (!(NW[0][l] < aMin)) continue;
                        aMin = NW[0][l];
                        aP = l;
                    }
                    if (!(w > aMin)) continue;
                    NW[0][aP] = w;
                    NW[1][aP] = p;
                }
                for (p = 0; p < points; ++p) {
                    SV += NW[0][p] * SCoords[(int)NW[1][p]][2];
                    SW += NW[0][p];
                }
                GCoords[i][j] = SV / SW;
            }
        }
        double s = 0.5;
        for (i = 1; i < rowNum - 1; ++i) {
            for (j = 1; j < colNum - 1; ++j) {
                GCoords[i][j] = GCoords[i][j] + s / 4.0 * (GCoords[i + 1][j] + GCoords[i - 1][j] + GCoords[i][j + 1] + GCoords[i][j - 1] - 4.0 * GCoords[i][j]);
            }
        }
        return GCoords;
    }

    public static double[][] interpolation_IDW_Radius(double[][] SCoords, double[] X, double[] Y, int NeededPointNum, double radius, double unDefData) {
        int j;
        int i;
        int colNum = X.length;
        int rowNum = Y.length;
        int pNum = SCoords.length;
        double[][] GCoords = new double[rowNum][colNum];
        for (i = 0; i < rowNum; ++i) {
            for (j = 0; j < colNum; ++j) {
                GCoords[i][j] = unDefData;
                boolean ifPointGrid = false;
                double SV = 0.0;
                double SW = 0.0;
                int vNum = 0;
                for (int p = 0; p < pNum; ++p) {
                    if (SCoords[p][2] == unDefData || SCoords[p][0] < X[j] - radius || SCoords[p][0] > X[j] + radius || SCoords[p][1] < Y[i] - radius || SCoords[p][1] > Y[i] + radius) continue;
                    if (Math.pow(X[j] - SCoords[p][0], 2.0) + Math.pow(Y[i] - SCoords[p][1], 2.0) == 0.0) {
                        GCoords[i][j] = SCoords[p][2];
                        ifPointGrid = true;
                        break;
                    }
                    if (!(Math.sqrt(Math.pow(X[j] - SCoords[p][0], 2.0) + Math.pow(Y[i] - SCoords[p][1], 2.0)) <= radius)) continue;
                    double w = 1.0 / (Math.pow(X[j] - SCoords[p][0], 2.0) + Math.pow(Y[i] - SCoords[p][1], 2.0));
                    SW += w;
                    SV += SCoords[p][2] * w;
                    ++vNum;
                }
                if (ifPointGrid || vNum < NeededPointNum) continue;
                GCoords[i][j] = SV / SW;
            }
        }
        double s = 0.5;
        for (i = 1; i < rowNum - 1; ++i) {
            for (j = 1; j < colNum - 2; ++j) {
                if (GCoords[i][j] == unDefData || GCoords[i + 1][j] == unDefData || GCoords[i - 1][j] == unDefData || GCoords[i][j + 1] == unDefData || GCoords[i][j - 1] == unDefData) continue;
                GCoords[i][j] = GCoords[i][j] + s / 4.0 * (GCoords[i + 1][j] + GCoords[i - 1][j] + GCoords[i][j + 1] + GCoords[i][j - 1] - 4.0 * GCoords[i][j]);
            }
        }
        return GCoords;
    }

    public static double[][] interpolation_Grid(double[][] GridData, double[] X, double[] Y, double unDefData, double[] nX, double[] nY) {
        int i;
        int nxNum = X.length * 2 - 1;
        int nyNum = Y.length * 2 - 1;
        nX = new double[nxNum];
        nY = new double[nyNum];
        double[][] nGridData = new double[nyNum][nxNum];
        for (i = 0; i < nxNum; ++i) {
            nX[i] = i % 2 == 0 ? X[i / 2] : (X[(i - 1) / 2] + X[(i - 1) / 2 + 1]) / 2.0;
        }
        for (i = 0; i < nyNum; ++i) {
            nY[i] = i % 2 == 0 ? Y[i / 2] : (Y[(i - 1) / 2] + Y[(i - 1) / 2 + 1]) / 2.0;
            for (int j = 0; j < nxNum; ++j) {
                ArrayList<Double> dList;
                double b;
                double a;
                if (i % 2 == 0 && j % 2 == 0) {
                    nGridData[i][j] = GridData[i / 2][j / 2];
                    continue;
                }
                if (i % 2 == 0 && j % 2 != 0) {
                    a = GridData[i / 2][(j - 1) / 2];
                    b = GridData[i / 2][(j - 1) / 2 + 1];
                    dList = new ArrayList<Double>();
                    if (a != unDefData) {
                        dList.add(a);
                    }
                    if (b != unDefData) {
                        dList.add(b);
                    }
                    if (dList.isEmpty()) {
                        nGridData[i][j] = unDefData;
                        continue;
                    }
                    if (dList.size() == 1) {
                        nGridData[i][j] = (Double)dList.get(0);
                        continue;
                    }
                    nGridData[i][j] = (a + b) / 2.0;
                    continue;
                }
                if (i % 2 != 0 && j % 2 == 0) {
                    a = GridData[(i - 1) / 2][j / 2];
                    b = GridData[(i - 1) / 2 + 1][j / 2];
                    dList = new ArrayList();
                    if (a != unDefData) {
                        dList.add(a);
                    }
                    if (b != unDefData) {
                        dList.add(b);
                    }
                    if (dList.isEmpty()) {
                        nGridData[i][j] = unDefData;
                        continue;
                    }
                    if (dList.size() == 1) {
                        nGridData[i][j] = (Double)dList.get(0);
                        continue;
                    }
                    nGridData[i][j] = (a + b) / 2.0;
                    continue;
                }
                a = GridData[(i - 1) / 2][(j - 1) / 2];
                b = GridData[(i - 1) / 2][(j - 1) / 2 + 1];
                double c = GridData[(i - 1) / 2 + 1][(j - 1) / 2 + 1];
                double d = GridData[(i - 1) / 2 + 1][(j - 1) / 2];
                dList = new ArrayList();
                if (a != unDefData) {
                    dList.add(a);
                }
                if (b != unDefData) {
                    dList.add(b);
                }
                if (c != unDefData) {
                    dList.add(c);
                }
                if (d != unDefData) {
                    dList.add(d);
                }
                if (dList.isEmpty()) {
                    nGridData[i][j] = unDefData;
                    continue;
                }
                if (dList.size() == 1) {
                    nGridData[i][j] = (Double)dList.get(0);
                    continue;
                }
                double aSum = 0.0;
                Iterator i$ = dList.iterator();
                while (i$.hasNext()) {
                    double dd = (Double)i$.next();
                    aSum += dd;
                }
                nGridData[i][j] = aSum / (double)dList.size();
            }
        }
        return nGridData;
    }

    public static double[][] cressman(double[][] stationData, double[] X, double[] Y, double unDefData) {
        ArrayList<Double> radList = new ArrayList<Double>();
        radList.add(10.0);
        radList.add(7.0);
        radList.add(4.0);
        radList.add(2.0);
        radList.add(1.0);
        return Interpolate.cressman(stationData, X, Y, unDefData, radList);
    }

    public static double[][] cressman(double[][] stData, double[] X, double[] Y, double unDefData, List<Double> radList) {
        int j;
        double y;
        double x;
        int i;
        int xNum = X.length;
        int yNum = Y.length;
        int pNum = stData.length;
        double[][] gridData = new double[yNum][xNum];
        int irad = radList.size();
        double xMin = X[0];
        double xMax = X[X.length - 1];
        double yMin = Y[0];
        double yMax = Y[Y.length - 1];
        double xDelt = X[1] - X[0];
        double yDelt = Y[1] - Y[0];
        double sum = 0.0;
        double total = 0.0;
        int stNum = 0;
        double[][] stationData = new double[pNum][3];
        for (i = 0; i < pNum; ++i) {
            x = stData[i][0];
            y = stData[i][1];
            stationData[i][0] = (x - xMin) / xDelt;
            stationData[i][1] = (y - yMin) / yDelt;
            stationData[i][2] = stData[i][2];
            if (stationData[i][2] == unDefData) continue;
            total += stationData[i][2];
            ++stNum;
        }
        total /= (double)stNum;
        double HITOP = -9.999E20;
        double HIBOT = 9.999E20;
        double[][] TOP = new double[yNum][xNum];
        double[][] BOT = new double[yNum][xNum];
        for (i = 0; i < yNum; ++i) {
            for (j = 0; j < xNum; ++j) {
                TOP[i][j] = HITOP;
                BOT[i][j] = HIBOT;
            }
        }
        double rad = radList.size() > 0 ? radList.get(0) : 4.0;
        for (i = 0; i < yNum; ++i) {
            y = i;
            yMin = y - rad;
            yMax = y + rad;
            for (j = 0; j < xNum; ++j) {
                x = j;
                xMin = x - rad;
                xMax = x + rad;
                stNum = 0;
                sum = 0.0;
                for (int s = 0; s < pNum; ++s) {
                    double dis;
                    double val = stationData[s][2];
                    double sx = stationData[s][0];
                    double sy = stationData[s][1];
                    if (sx < 0.0 || sx >= (double)(xNum - 1) || sy < 0.0 || sy >= (double)(yNum - 1) || val == unDefData || sx < xMin || sx > xMax || sy < yMin || sy > yMax || (dis = Math.sqrt(Math.pow(sx - x, 2.0) + Math.pow(sy - y, 2.0))) > rad) continue;
                    sum += val;
                    ++stNum;
                    if (TOP[i][j] < val) {
                        TOP[i][j] = val;
                    }
                    if (!(BOT[i][j] > val)) continue;
                    BOT[i][j] = val;
                }
                gridData[i][j] = stNum == 0 ? unDefData : sum / (double)stNum;
            }
        }
        for (int p = 0; p < irad; ++p) {
            rad = radList.get(p);
            for (i = 0; i < yNum; ++i) {
                y = i;
                yMin = y - rad;
                yMax = y + rad;
                for (j = 0; j < xNum; ++j) {
                    if (gridData[i][j] == unDefData) continue;
                    x = j;
                    xMin = x - rad;
                    xMax = x + rad;
                    sum = 0.0;
                    double wSum = 0.0;
                    for (int s = 0; s < pNum; ++s) {
                        double calVal;
                        double dis;
                        double val = stationData[s][2];
                        double sx = stationData[s][0];
                        double sy = stationData[s][1];
                        if (sx < 0.0 || sx >= (double)(xNum - 1) || sy < 0.0 || sy >= (double)(yNum - 1) || val == unDefData || sx < xMin || sx > xMax || sy < yMin || sy > yMax || (dis = Math.sqrt(Math.pow(sx - x, 2.0) + Math.pow(sy - y, 2.0))) > rad) continue;
                        int i1 = (int)sy;
                        int j1 = (int)sx;
                        int i2 = i1 + 1;
                        int j2 = j1 + 1;
                        double a = gridData[i1][j1];
                        double b = gridData[i1][j2];
                        double c = gridData[i2][j1];
                        double d = gridData[i2][j2];
                        ArrayList<Double> dList = new ArrayList<Double>();
                        if (a != unDefData) {
                            dList.add(a);
                        }
                        if (b != unDefData) {
                            dList.add(b);
                        }
                        if (c != unDefData) {
                            dList.add(c);
                        }
                        if (d != unDefData) {
                            dList.add(d);
                        }
                        if (dList.isEmpty()) continue;
                        if (dList.size() == 1) {
                            calVal = (Double)dList.get(0);
                        } else if (dList.size() <= 3) {
                            double aSum = 0.0;
                            Iterator i$ = dList.iterator();
                            while (i$.hasNext()) {
                                double dd = (Double)i$.next();
                                aSum += dd;
                            }
                            calVal = aSum / (double)dList.size();
                        } else {
                            double x1val = a + (c - a) * (sy - (double)i1);
                            double x2val = b + (d - b) * (sy - (double)i1);
                            calVal = x1val + (x2val - x1val) * (sx - (double)j1);
                        }
                        double eVal = val - calVal;
                        double w = (rad * rad - dis * dis) / (rad * rad + dis * dis);
                        sum += eVal * w;
                        wSum += w;
                    }
                    if (wSum < 1.0E-6) {
                        gridData[i][j] = unDefData;
                        continue;
                    }
                    double aData = gridData[i][j] + sum / wSum;
                    gridData[i][j] = Math.max(BOT[i][j], Math.min(TOP[i][j], aData));
                }
            }
        }
        return gridData;
    }

    public static double[][] assignPointToGrid(double[][] SCoords, double[] X, double[] Y, double unDefData) {
        int i;
        int colNum = X.length;
        int rowNum = Y.length;
        int pNum = SCoords.length;
        double[][] GCoords = new double[rowNum][colNum];
        double dX = X[1] - X[0];
        double dY = Y[1] - Y[0];
        int[][] pNums = new int[rowNum][colNum];
        for (i = 0; i < rowNum; ++i) {
            for (int j = 0; j < colNum; ++j) {
                pNums[i][j] = 0;
                GCoords[i][j] = 0.0;
            }
        }
        for (int p = 0; p < pNum; ++p) {
            if (Interpolate.doubleEquals(SCoords[p][2], unDefData)) continue;
            double x = SCoords[p][0];
            double y = SCoords[p][1];
            if (x < X[0] || x > X[colNum - 1] || y < Y[0] || y > Y[rowNum - 1]) continue;
            int j = (int)((x - X[0]) / dX);
            int i2 = (int)((y - Y[0]) / dY);
            int[] nArray = pNums[i2];
            int n = j;
            nArray[n] = nArray[n] + 1;
            double[] dArray = GCoords[i2];
            int n2 = j;
            dArray[n2] = dArray[n2] + SCoords[p][2];
        }
        for (i = 0; i < rowNum; ++i) {
            for (int j = 0; j < colNum; ++j) {
                GCoords[i][j] = pNums[i][j] == 0 ? unDefData : GCoords[i][j] / (double)pNums[i][j];
            }
        }
        return GCoords;
    }

    private static boolean doubleEquals(double a, double b) {
        return Math.abs(a / b - 1.0) < 1.0E-11;
    }
}

