/*
 * Decompiled with CFR 0.152.
 */
package kl.ssl.gmvpn;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import kl.ssl.gmvpn.ProtocolVersion;
import kl.ssl.gmvpn.TlsContext;
import kl.ssl.gmvpn.TlsFatalAlert;
import kl.ssl.gmvpn.TlsProtocol;
import kl.ssl.gmvpn.TlsUtils;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.io.TeeInputStream;

public class ClientHello {
    private final ProtocolVersion clientVersion;
    private final byte[] random;
    private final byte[] sessionID;
    private final byte[] cookie;
    private final int[] cipherSuites;
    private final Hashtable extensions;

    public ClientHello(ProtocolVersion clientVersion, byte[] random, byte[] sessionID, byte[] cookie, int[] cipherSuites, Hashtable extensions) {
        this.clientVersion = clientVersion;
        this.random = random;
        this.sessionID = sessionID;
        this.cookie = cookie;
        this.cipherSuites = cipherSuites;
        this.extensions = extensions;
    }

    public int[] getCipherSuites() {
        return this.cipherSuites;
    }

    public ProtocolVersion getClientVersion() {
        return this.clientVersion;
    }

    public byte[] getCookie() {
        return this.cookie;
    }

    public Hashtable getExtensions() {
        return this.extensions;
    }

    public byte[] getRandom() {
        return this.random;
    }

    public byte[] getSessionID() {
        return this.sessionID;
    }

    public void encode(TlsContext context, OutputStream output) throws IOException {
        TlsUtils.writeVersion(this.clientVersion, output);
        output.write(this.random);
        TlsUtils.writeOpaque8(this.sessionID, output);
        if (null != this.cookie) {
            TlsUtils.writeOpaque8(this.cookie, output);
        }
        TlsUtils.writeUint16ArrayWithUint16Length(this.cipherSuites, output);
        TlsUtils.writeUint8ArrayWithUint8Length(new short[]{0}, output);
        TlsProtocol.writeExtensions(output, this.extensions);
    }

    public static ClientHello parse(ByteArrayInputStream messageInput, OutputStream dtlsOutput) throws TlsFatalAlert {
        try {
            return ClientHello.implParse(messageInput, dtlsOutput);
        }
        catch (TlsFatalAlert e) {
            throw e;
        }
        catch (IOException e) {
            throw new TlsFatalAlert(50, (Throwable)e);
        }
    }

    private static ClientHello implParse(ByteArrayInputStream messageInput, OutputStream dtlsOutput) throws IOException {
        int cipher_suites_length;
        ByteArrayInputStream input = messageInput;
        if (null != dtlsOutput) {
            input = new TeeInputStream((InputStream)input, dtlsOutput);
        }
        ProtocolVersion clientVersion = TlsUtils.readVersion(input);
        byte[] random = TlsUtils.readFully(32, (InputStream)input);
        byte[] sessionID = TlsUtils.readOpaque8(input, 0, 32);
        byte[] cookie = null;
        if (null != dtlsOutput) {
            int maxCookieLength = ProtocolVersion.DTLSv12.isEqualOrEarlierVersionOf(clientVersion) ? 255 : 32;
            cookie = TlsUtils.readOpaque8(messageInput, 0, maxCookieLength);
        }
        if ((cipher_suites_length = TlsUtils.readUint16(input)) < 2 || (cipher_suites_length & 1) != 0 || messageInput.available() < cipher_suites_length) {
            throw new TlsFatalAlert(50);
        }
        int[] cipherSuites = TlsUtils.readUint16Array(cipher_suites_length / 2, input);
        short compression_methods_length = TlsUtils.readUint8(input);
        if (compression_methods_length < 1) {
            throw new TlsFatalAlert(47);
        }
        short[] compressionMethods = TlsUtils.readUint8Array(compression_methods_length, input);
        if (!Arrays.contains((short[])compressionMethods, (short)0)) {
            throw new TlsFatalAlert(40);
        }
        Hashtable extensions = null;
        if (messageInput.available() > 0) {
            byte[] extBytes = TlsUtils.readOpaque16(input);
            TlsProtocol.assertEmpty(messageInput);
            extensions = TlsProtocol.readExtensionsData(extBytes);
        }
        return new ClientHello(clientVersion, random, sessionID, cookie, cipherSuites, extensions);
    }
}

