/*
 * Decompiled with CFR 0.152.
 */
package kl.ssl.gmvpn.crypto.impl.jcajce;

import java.security.GeneralSecurityException;
import kl.ssl.gmvpn.TlsUtils;
import kl.ssl.gmvpn.crypto.TlsSecret;
import kl.ssl.gmvpn.crypto.impl.AbstractTlsCrypto;
import kl.ssl.gmvpn.crypto.impl.AbstractTlsSecret;
import kl.ssl.gmvpn.crypto.impl.jcajce.JcaTlsCrypto;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SM3Digest;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Strings;

public class JceTlsSecret
extends AbstractTlsSecret {
    protected final JcaTlsCrypto crypto;

    public JceTlsSecret(JcaTlsCrypto crypto, byte[] data) {
        super(data);
        this.crypto = crypto;
    }

    @Override
    public synchronized TlsSecret deriveUsingPRF(int prfAlgorithm, String label, byte[] seed, int length) {
        this.checkAlive();
        byte[] labelSeed = Arrays.concatenate((byte[])Strings.toByteArray((String)label), (byte[])seed);
        try {
            byte[] result = prfAlgorithm == 0 ? this.prf_1_0(this.data, labelSeed, length) : this.prf_1_2(prfAlgorithm, this.data, labelSeed, length);
            return this.crypto.adoptLocalSecret(result);
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException();
        }
    }

    @Override
    protected TlsSecret adoptLocalSecret(byte[] data) {
        return this.crypto.adoptLocalSecret(data);
    }

    @Override
    protected AbstractTlsCrypto getCrypto() {
        return this.crypto;
    }

    protected void hmacHash(String digestName, byte[] secret, int secretOff, int secretLen, byte[] seed, byte[] output) throws GeneralSecurityException {
        HMac mac = new HMac((Digest)new SM3Digest());
        mac.init((CipherParameters)new KeyParameter(secret, secretOff, secretLen));
        byte[] a = seed;
        int macSize = mac.getMacSize();
        byte[] b1 = new byte[macSize];
        byte[] b2 = new byte[macSize];
        for (int pos = 0; pos < output.length; pos += macSize) {
            mac.update(a, 0, a.length);
            mac.doFinal(b1, 0);
            a = b1;
            mac.update(a, 0, a.length);
            mac.update(seed, 0, seed.length);
            mac.doFinal(b2, 0);
            System.arraycopy(b2, 0, output, pos, Math.min(macSize, output.length - pos));
        }
    }

    protected byte[] prf_1_0(byte[] secret, byte[] labelSeed, int length) throws GeneralSecurityException {
        int s_half = (secret.length + 1) / 2;
        byte[] b1 = new byte[length];
        this.hmacHash("MD5", secret, 0, s_half, labelSeed, b1);
        byte[] b2 = new byte[length];
        this.hmacHash("SHA1", secret, secret.length - s_half, s_half, labelSeed, b2);
        for (int i = 0; i < length; ++i) {
            int n = i;
            b1[n] = (byte)(b1[n] ^ b2[i]);
        }
        return b1;
    }

    protected byte[] prf_1_2(int prfAlgorithm, byte[] secret, byte[] labelSeed, int length) throws GeneralSecurityException {
        String digestName = this.crypto.getDigestName(TlsUtils.getHashAlgorithmForPRFAlgorithm(prfAlgorithm)).replaceAll("-", "");
        byte[] result = new byte[length];
        this.hmacHash(digestName, secret, 0, secret.length, labelSeed, result);
        return result;
    }
}

